

; This code displays the values of the RX and TX ring buffer pointers.

IMPORT_WORD     <__video_seg>

TI_vidofst      equ     3830
TO_vidofst      equ     3990
RI_vidofst      equ     3806
RO_vidofst      equ     3966

localproc       dsp_TXIN
public          dsp_TXIN
        push    di
        push    ax
        mov     ax,TX_IN
        mov     di,TI_vidofst
        jmp s   dsp_dbg
localproc       dsp_TXOUT
public          dsp_TXOUT
        push    di
        push    ax
        mov     ax,TX_OUT
        mov     di,TO_vidofst
        jmp s   dsp_dbg
localproc       dsp_RXIN
public          dsp_RXIN
        push    di
        push    ax
        mov     ax,RX_IN
        mov     di,RI_vidofst
        jmp s   dsp_dbg
localproc       dsp_RXOUT
public          dsp_RXOUT
        push    di
        push    ax
        mov     ax,RX_OUT
        mov     di,RO_vidofst

dsp_dbg:
        push    cx
        push    es
        mov     cx,4
        mov     es,DGROUP:__video_seg
        cld
        call    dsp_word
        pop     es
        pop     cx
        pop     ax
        pop     di
        ret

dsp_word:
        push    ax
        mov     al,ah
        call    dsp_byte
        pop     ax
dsp_byte:
        xor     ah,ah
        shl     ax,cl
        shr     al,cl
        xchg    ah,al
        call    dsp_dgt
        xchg    ah,al
dsp_dgt:
        push    ax
        mov     ah,7
        add     al,'0'
        cmp     al,'9'
        jbe     dgt2scrn
        add     al,ah
dgt2scrn:
        stosw
        pop     ax
        ret

dsp_RXOUT       endp
dsp_RXIN        endp
dsp_TXOUT       endp
dsp_TXIN        endp

