
/******************************************************************************
 COMM.H -- header file for C programs using async functions.

   Mike Dumdei,  6 Holly Lane,  Texarkana TX  75503

******************************************************************************/

#define         COM1            1
#define         COM2            2

/*  ---- Return codes ----  */
#define         R_OK            0
#define         R_NOPORT       -1
#define         R_PORTINUSE    -2
#define         R_BAUDERR      -3
#define         R_PARITYERR    -4
#define         R_DTABITERR    -5
#define         R_STPBITERR    -6
#define         R_BADARG       -7
#define         R_NOMEM        -8
#define         R_TXERR        -9


/*  ---- Bit masks ----  */
                        /*    S T A T 2    */
#define         B_XUSE       0x0001     /* using XON/XOFF protocol bit */
#define         B_XRXD       0x0002     /* XOFF received bit */
#define         B_XSENT      0x0004     /* XOFF sent bit */
#define         B_TXEMPTY    0x0008     /* nothing to transmit bit */
#define         B_CTS        0x0010     /* clear to send bit */
#define         B_DSR        0x0020     /* data set ready bit */
#define         B_FLOWHALT   0x0040     /* flow halt indicator bit */
#define         B_MNTR_CD    0x0080     /* monitor CD bit */

                        /*    S T A T 1    */
#define         B_RXOVF      0x0100     /* rx buffer overflow indic bit */
#define         B_OVERRUN    0x0200     /* char overrun error bit */
#define         B_PARITY     0x0400     /* parity error bit */
#define         B_FRAMING    0x0800     /* framing error bit */
#define         B_BREAK      0x1000     /* line break signal detected */
#define         B_BADPORT    0x2000     /* bad port bit */
#define         B_RXEMPTY    0x4000     /* rx buffer empty bit */
#define         B_CD         0x8000     /* carrier detect bit mask */


/* ---- Function declarations ---- */
int     async_open(int, char *, int, int);      /* open async port */
int     async_close(int);                       /* close async port */
int     async_tx(int, char);                    /* transmit character */
int     async_rx(int);                          /* receive a character */
int     async_reset(int);                       /* Reset rx error condition */
int     async_stat(int, int);                   /* get stat1/stat2 bytes */
int     async_carrier(int);                     /* fast ck for carrier dtct */
int     async_setbpds(int, char *);             /* change line parameters */
int     async_rxcnt(int);                       /* get # bytes in rx buffer */
int     async_txfree(int);                      /* get bytes free in tx bufr */
int     async_rxflush(int);                     /* flush the receive buffer */
int     async_txflush(int);                     /* flush the transmit buffer */
int     async_msr(int);                         /* get modem status register */
int     async_msrflow(int, int);                /* set MSR related flw cntrl */
int     async_xonoff(int, int);                 /* XON/OFF protocl on/off */
int     async_xoffclr(int);                     /* manually clr XOFF rx'd */
int     async_xonany(int, int);                 /* Any char = XON  on/off */
int     async_dtr(int, int);                    /* DTR on/off */
int     async_rts(int, int);                    /* RTS on/off */
int     async_tximd(int, char *, int);          /* Tx blk data as next out */
int     async_strip(int, char);                 /* Set bit stripping mask */

