
title TRANSMIT BLOCK DATA IMMEDIATE
include subfx.h

;  Mike Dumdei,  6 Holly Lane,  Texarkana TX  75503

IMPORT_NEAR     <__tx_inton, __txblk_fill>

;*****************************************************************************
; ASYNC_TXIMD -- Gets block passed by C caller and puts it in the transmit
; buffer ahead of anything else already in the buffer.  Returns R_TXERR if
; the port argument was invalid or there was insufficient room in the buffer.
; Returns number bytes left in buffer if tx was successful.
;*****************************************************************************
begseg          COMM_TEXT
publicproc      _async_tximd
        push    bp
        mov     bp,sp
        push    si
        push    di
        push    es              ;setup stack and save regs
        call    __ck_port_arg   ;ck port argument & load pointers
        mov     ax,R_TXERR
        jz      async_texit2    ;bad port if ZR
        mov     cx,TxImdCnt
        jcxz    get_txfree      ;exit if chars to tx = 0
        cli
        mov     bx,TX_FREE
        sub     bx,cx           ;ck if enough room in the buffer
        jc      async_texit2    ;and exit if not
        mov     TX_FREE,bx      ;else set new TX_FREE value
        mov     bx,TX_OUT       ;get ptr to nxt char to tx would have been
        sub     bx,cx
        cmp     bx,TX_TOP
        jnb     set_new_out
        sub     bx,TX_TOP
        add     bx,TX_BTM
set_new_out:
        mov     TX_OUT,bx       ;adjust TX_OUT to point to new nxt char out
        mov     di,bx
        mov     es,RXTX_SEG     ;get seg of rx/tx bufrs
        mov     bx,TxImdOfst    ;ES:DI=new TX_OUT   BX=blk ofst
        mov     dx,5
        cmp     cx,dx           ;going to tx 5 chars, start tx, reenable
        ja      more_than5      ; interrupts, & then finish the move
        xor     dx,dx
        push    dx              ;none left to move aftr 1st group if < 5 in 1st
        jmp s   move_first
more_than5:
        sub     cx,dx
        push    cx              ;bytes left to move after moving 1st 5
        mov     cx,dx           ;set CX=5 -- nbr to move before tx is started
move_first:
        call    __txblk_fill    ;move 1st group to tx buffer
        and     TX_STAT,n B_TXEMPTY ;clear bit that indicates nothing to tx
        jnz     txint_ok2       ;NZ = tx alrdy on or flow cntrl halt active
        push    bx
        call    __tx_inton      ;else start things going if they're not alrdy
        pop     bx
txint_ok2:
        sti
        pop     cx              ;number bytes left to put in buffer
        jcxz    get_txfree
        call    __txblk_fill    ;move rest of block to tx buf if there is more
get_txfree:
        mov     ax,TX_FREE
async_texit2:
        sti
        pop     es
        pop     di
        pop     si
        mov     sp,bp
        ret                     ;restore regs and exit
_async_tximd    endp

endseg          COMM_TEXT
        end
