
title SET COMMUNICATION PARAMETERS
include subfx.h

;  Mike Dumdei,  6 Holly Lane,  Texarakana TX  75503

IMPORT_NEAR     <__convert_bpds, __set_bpds>

;******************************************************************************
; ASYNC_SETBPDS -- Changes the baud rate, parity, data, or stop bit settings
; of an opened comm port.  Returns R_OK if successful else returns err code.
;******************************************************************************
begseg          COMM_TEXT
publicproc      _async_setbpds
        push    bp
        mov     bp,sp
        push    si              ;C stk frame, save regs
        call    __ck_port_arg   ;get pointers, ck for valid port
        jz      setexit         ;err if ZR flag set on return
        mov     bx,BPDS_ptr     ;get passed pointer to the baud-parity-etc str
        call    __convert_bpds  ;attempt to convert string
        or      ax,ax
        jnz     setexit         ;no good if AX != 0 on return
        call    __set_bpds      ;set new values if passed parms were good
        sti
        xor     ax,ax           ;returning R_OK
setexit:
        pop     si
        pop     bp
        ret                     ;restore regs and exit
_async_setbpds  endp

endseg          COMM_TEXT
        end
