
title FLUSH RECEIVE BUFFER
include subfx.h

;  Mike Dumdei,  6 Holly Lane,  Texarkana TX  75503

ifdef DBUG
IMPORT_NEAR     <dsp_RXIN, dsp_RXOUT>
endif

;***************************************************************************
; ASYNC_RXFLUSH -- Clears the receive buffer.
;***************************************************************************
begseg          COMM_TEXT
publicproc      _async_rxflush
        push    bp
        mov     bp,sp
        push    si              ;C stck frame, save regs
        call    __ck_port_arg   ;ck for valid arg and load pointers
        jz      rxfl_exit       ;arg was bad if ZR set on rtrn
        cli
        mov     ax,RX_SIZE
        mov     RX_FREE,ax      ;reset free space variable
        mov     ax,RX_TOP
        mov     RX_IN,ax
        mov     RX_OUT,ax       ;reset rx buffer pointers
ifdef DBUG
        call    dsp_RXIN
        call    dsp_RXOUT
endif
rxfl_exit:
        sti
        pop     si
        pop     bp
        ret                     ;restore regs and exit
_async_rxflush  endp

endseg          COMM_TEXT
        end
