
title RTS SET/RESET
include subfx.h

;  Mike Dumdei,  6 Holly Lane,  Texarkana TX  75503

;******************************************************************************
; ASYNC_RTS -- Sets or clears 'request to send' based on passed flag.  Returns
;  R_NOPORT if port invalid else returns R_OK.
;******************************************************************************
begseg          COMM_TEXT
publicproc      _async_rts
        push    bp
        mov     bp,sp
        push    si              ;stack frame setup
        call    __ck_port_arg   ;ck if valid, load pointers
        jz      rts_exit        ;bad arg if ZR flag set
        mov     dx,COM_BASE
        add     dx,4            ;xFC)modem control register
        in      al,dx
        cmp     Flag,OFF
        jne     rts_on
        and     al,n B_RTS      ;clear RTS bit
        jmp s   snd_MCRbyte     ;exits through DTR proc
rts_on:
        or      al,B_RTS        ;set RTS bit
snd_MCRbyte:
        out     dx,al           ;send new mask to UART
        xor     ax,ax           ;returning R_OK
rts_exit:
        pop     si
        pop     bp
        ret                     ;restore regs and exit
_async_rts      endp

endseg          COMM_TEXT
        end

