
title ENABLE/DISABLE MSR MONITORING
include subfx.h

;  Mike Dumdei,  6 Holly Lane,  Texarkana TX  75503

IMPORT_NEAR     <__tx_inton>

;****************************************************************************
; ASYNC_MSRFLOW  -- Enables or disables the monitoring of modem signals CTS,
;       DSR, or CD when transmitting.
;        Example: rcode = async_flow(COM1, B_CTS + B_CD);
;       The above would halt the transmitter if CTS goes low or if carrier
;       detect is lost -- keep in mind no commands will get sent to the modem
;       either (translated: don't monitor CD before connecting).  Returns
;       R_NOPORT if bad port arg is given, R_BADARG if invalid bits in Flag,
;       else returns R_OK.
;****************************************************************************
begseg          COMM_TEXT
publicproc      _async_msrflow
        push    bp
        mov     bp,sp
        push    si              ;stack frame setup
        call    __ck_port_arg   ;ck if valid, load pointers
        jz      msrflw_exit     ;bad arg if ZR flag set
        mov     ax,R_BADARG     ;setup in case of bad argument
        mov     dx,1011000001001111b ;mask / NOT mask  for msr bits
        test    MSRMntrFlg,dl
        jnz     msrflw_exit     ;bad arg if any improper bits set in flag
        mov     cx,dx
        mov     al,MSRMntrFlg   ;get passed MSR flow mask
        not     al              ;AL = NOT Flag
        mov     MSR_MASK,al     ;update MSR_MASK variable
        not     al              ;AL = Flag
        cli
        and     cl,TX_STAT      ;CL= TX_STAT with all mdm flw bits clr'd
        and     ch,MSR_VAL
        and     ch,al           ;CH= bits in MSR val to be used in flow chk'g
        xor     al,ch           ;AL= not function of bits to be tested
        or      al,cl           ;AL= new TX_STAT
        mov     TX_STAT,al      ;store it
        jnz     msrflw_exit     ;TX_STAT == NZ = don't start up txmtr
        call    __tx_inton      ;TX_STAT == ZR = start up txmtr
msrflw_exit:
        sti
        pop     si
        pop     bp
        ret                     ;restore regs and exit
_async_msrflow  endp

endseg          COMM_TEXT
        end
