.xlist

;**************************************************************************
; INCLUDE FILE FOR ALL 'ASM' MODULES FOR MICROSOFT 'C' PROGRAMS
;  sets up segments and defines common equates
;**************************************************************************

;  Mike Dumdei,  6 Holly Lane,  Texarkana TX  75503

;------- Memory model macros ----------------------------
irp     cdmod, <MEDIUM,LARGE,HUGE>
        ifdef   cdmod
        FARCODE equ 1
        endif
endm
irp     dtmod, <COMPACT,LARGE,HUGE>
        ifdef   dtmod
        FARDATA equ 1
        endif
endm

;------ Define segments macro ---------------------------
defseg  macro   farname
ifdef FARCODE                   ;;---- f a r c o d e ----
farname SEGMENT BYTE PUBLIC 'CODE'
farname ENDS
bTXT    equ     Byte Ptr farname:
wTXT    equ     Word Ptr farname:
ofTXT   equ     offset farname:
TXT     equ     farname
BOFST = 6
else                            ;;---- n e a r c o d e ----
_TEXT   SEGMENT BYTE PUBLIC 'CODE'
_TEXT   ENDS
bTXT    equ     Byte Ptr _TEXT:
wTXT    equ     Word Ptr _TEXT:
ofTXT   equ     offset _TEXT:
TXT     equ     _TEXT
BOFST = 4
endif                           ;;---- f a r  &  n e a r ----
_DATA   SEGMENT WORD PUBLIC 'DATA'
_DATA   ENDS
DGROUP  GROUP   _DATA
        endm

;------- Begin/End code segment macros ------------------
begseg  macro   farname
ifdef FARCODE
        ASSUME  CS:farname, DS:DGROUP, SS:DGROUP
farname segment
else
        ASSUME  CS:_TEXT, DS:DGROUP, SS:DGROUP
_TEXT   segment
endif
        endm

endseg  macro   farname
ifdef FARCODE
farname ends
else
_TEXT   ends
endif
        endm

;------- Procedure macros -------------------------------
publicproc      macro   pname
        public  pname
ifdef FARCODE
pname           proc    far
else
pname           proc    near
endif
        endm

localproc       macro   pname
pname           proc    near
        endm

;------- Function entry and exit macros -----------------
fstart  macro   req_bytes
        push    bp              ;; sets up stack frame + if arg is given
        mov     bp,sp           ;; does call to chkstk function to see
ifnb    <req_bytes>             ;; if space is available
        mov     ax,req_bytes    ;; IF USING __chkstk YOU MUST DECLARE IT AS
        call    __chkstk        ;; AN EXTERNAL IN THE SOURCE THAT USES IT
endif
        push    di
        push    si
        endm

fend    macro
        pop     si              ;; clears stack frame and exits to caller
        pop     di
        mov     sp,bp
        pop     bp
        ret
        endm

;------ Define external procedures/variables macros -----
IMPORT_NEAR     macro   list
        irp     x,<list>
        extrn   x:near
        endm
        endm
IMPORT_FAR      macro   list
        irp     x,<list>
        extrn   x:far
        endm
        endm
IMPORT_BYTE     macro   list
        irp     x,<list>
        extrn   x:byte
        endm
        endm
IMPORT_WORD     macro   list
        irp     x,<list>
        extrn   x:word
        endm
        endm
IMPORT_ABS      macro   list
        irp     x,<list>
        extrn   x:abs
        endm
        endm

;------- Useful equates -------------------------------
bptr    equ     Byte Ptr
wptr    equ     Word Ptr
s       equ     short
n       equ     not
ofst    equ     offset
bbp     equ     Byte Ptr [BP]
wbp     equ     Word Ptr [BP]
bbx     equ     Byte Ptr [BX]
wbx     equ     Word Ptr [BX]
bsi     equ     Byte Ptr [SI]
wsi     equ     Word Ptr [SI]
bdi     equ     Byte Ptr [DI]
wdi     equ     Word Ptr [DI]
bDG     equ     Byte Ptr DGROUP:
wDG     equ     Word Ptr DGROUP:
ofDG    equ     offset DGROUP:
DG      equ     DGROUP
.list
