
title GET CARRIER STATUS
include subfx.h

;  Mike Dumdei,  6 Holly Lane,  Texarkana TX 75503

;******************************************************************************
; ASYNC_CARRIER  --  Returns TRUE (1) if carrier is present else returns
;       FALSE (0).  Returns R_NOPORT (-1) if invalid port.
;******************************************************************************

begseg          COMM_TEXT
publicproc      _async_carrier
        push    bp
        mov     bp,sp
        push    si              ;stack frame setup
        call    __ck_port_arg   ;ck if valid, load pointers
        jz      carr_exit       ;bad arg if ZR flag set
        xor     ax,ax           ;set up in case no carrier
        test    MSR_VAL,B_CD    ;ck MSR value for CD (RLSD)
        jz      carr_exit       ;ZR test result == no carrier
        inc     ax              ;NZ test result == carrier present
carr_exit:
        pop     si
        pop     bp
        ret                     ;restore regs and exit
_async_carrier  endp

endseg          COMM_TEXT
        end
