
title GET STATUS INFORMATION
include subfx.h

;  Mike Dumdei,  6 Holly Lane,  Texarkana TX 75503

;******************************************************************************
; ASYNC_STAT -- Returns STAT1 in AH & STAT2 in AL after the mask passed by
;               the function call is applied (STAT1;STAT2 && StatMask).
;               Bit 5 of stat1 is not used by the stat function -- instead
;               returns R_NOPORT if invalid port.
;Bit maps of status bytes:
;-- Values returned by async_stat (1 & 2) and async_rx high byte (1 only)
;   STAT1: 0=rx bufr ovrfl   1=char overrun     2=parity err    3=framing err
;          4=break intrpt    5=invalid port     6=rx bufr empty 7=no carrier
;   STAT2: 0=XON/OFF in use  1=XOFF received    2=XOFF sent     3=tx buf empty
;          4=montr'g CTS     5=montr'g DSR      6=flw hlt actv  7=montr'g CD
;******************************************************************************

begseg          COMM_TEXT
publicproc      _async_stat
        push    bp
        mov     bp,sp
        push    si              ;stack frame setup
        call    __ck_port_arg   ;ck if valid, load pointers
        jz      stat_exit       ;bad arg if ZR flag set
        mov     bh,STAT1        ;get STAT1 byte
        mov     ax,RX_FREE
        cmp     ax,RX_SIZE      ;rx bufr empty?
        jne     get_stat2
        or      bh,B_RXEMPTY    ;set bit if RX bufr is empty
get_stat2:
        mov     bl,STAT2
        mov     al,TX_STAT
        and     al,FLOW_MASK
        jz      get_monitrd_bits
        or      bl,B_FLOWHALT   ;set bit if tx is currently stopped by flw cks
get_monitrd_bits:
        mov     al,MSR_MASK
        not     al
        or      bl,al           ;get modem signals being monitored
;ck_if_txbuf_empty:
        mov     ax,TX_FREE
        cmp     ax,TX_SIZE
        jne     add_mask
        or      bl,B_TXEMPTY    ;set bit if tx buffer is empty
add_mask:
        mov     ax,bx
        and     ax,StatMask     ;mask off according to passed mask
stat_exit:
        pop     si
        pop     bp
        ret                     ;restore regs and exit
_async_stat     endp

endseg          COMM_TEXT
        end
