
title DTR SET/RESET
include subfx.h

;  Mike Dumdei,  6 Holly Lane,  Texarkana TX  75503

;******************************************************************************
; ASYNC_DTR -- Sets or clears 'data terminal ready' based on passed flag.
;  Returns R_NOPORT if port invalid else returns R_OK.
;******************************************************************************
begseg          COMM_TEXT
publicproc      _async_dtr
        push    bp
        mov     bp,sp
        push    si              ;stack frame setup
        call    __ck_port_arg   ;ck if valid, load pointers
        jz      dtr_exit        ;bad arg if ZR flag set
        mov     dx,COM_BASE
        add     dx,4            ;xFC)modem control register
        in      al,dx
        cmp     Flag,OFF
        jne     dtr_on
        and     al,n B_DTR      ;clear DTR bit
        jmp s   snd_MCRbyte
dtr_on:
        or      al,B_DTR        ;set DTR bit
snd_MCRbyte:
        out     dx,al           ;send new mask to UART
        xor     ax,ax           ;returning R_OK
dtr_exit:
        pop     si
        pop     bp
        ret                     ;restore regs and exit
_async_dtr      endp

endseg          COMM_TEXT
        end

