/******************************************************************************

FBNLIB.H

This file contains definitions of manifest constants and structures used
in the FBN function library and function prototypes for all the library
functions except the protocol file transfer functions.

Version of 6 May 1991

Abbreviated version of 6 June 1991 to include in COMRESET source
package.  Removed references to functions not used in this program.

******************************************************************************/

/***********
  constants
 ***********/

/* general purpose constants */

#define TRUE            1               /* boolean true                      */
#define FALSE           0               /* boolean false                     */
#define ENDFILE         0x1a            /* CP/M type end of file marker      */
#define MAX_PATH        80              /* maximum length of a file name     */

/******************
  extern variables
 ******************/

/* the following variables are defined in PCSERIAL.ASM */

extern short mderrs;                   /* # errors recorded at modem port    */
extern short aperrs;                   /* # errors recorded at aux port      */
extern short mp_ready;                 /* is modem port initialized & ready? */
extern short ap_ready;                 /* is aux port initialized & ready?   */

/*********************
  function prototypes
 *********************/

/********************************
 * computer dependent functions *
 ********************************/

/* modem serial port control functions */

int mdbaud(unsigned baud_rate);
void mdclr(void);
int mdcts(void);
int mddcd(void);
int mddsr(void);
void mddtr(int value);
int mdfifo(int);
int mdiful(void);
int mdin(void);
int mdist(void);
int mdlook(void);
void mdnohs(void);
void mdnoxo(void);
void mdoclr(void);
int mdoful(void);
int mdost(void);
void mdout(int letter);
int mdparams(int data_bits, int parity, int stop_bits);
int mdri(void);
void mdrts(int value);
void mdsend(char *out_string);
void mdsths(void);
void mdstxo(void);
void mdxoff(void);
void mdxon(void);
int mdxost(void);
void mpclose(int assert_dtr);
int mpopen(unsigned port, unsigned intrpt, unsigned ibuf, unsigned obuf);

/* end of file */
