         title   Control-Break handler for Lattice C programs
         name    cbreak
         include dos.mac
;
;  Control-Break Interrupt Handler for Lattice C programs
;  running on IBM PC's  ( and ROM BIOS compatibles ).
;
;  Written by:      Ray Duncan,  May 1985  ( DDJ #107 September 1985 )
;
;  Transcribed by:  Lee J. Sarama, August 1985
;
;  This module allows C programs running on the IBM PC
;  to retain control when the user enters a Control-break
;  and/or Control-C.  This is accomplished by taking over the
;  Int 23H (MS-DOS Control-Break) and Int 1BH (IBM PC Rom BIOS
;  Keyboard Driver Control-Break) Interrupt Vectors.
;  The interupt handler sets an internal flag (which must be
;  declared  STATIC INT) to TRUE within the C program;  the C
;  program can poll or ignore this flag as it wishes.
;
;  The Module follows the Lattice C parameter passing
;  conventions,  and also relies on the Lattice file DOS.MAC
;  for the definitions of certain constants and macros.
;
;  The Int 23H Control-Break handler is a function of MS-DOS
;  and is present on all MS-DOS machines,  however, the INT 1BH
;  handler is a function of the IBM PC ROM BIOS and will not
;  necessarily be present on other machines.
;
;
         if    lprog
args     equ   6                   ;offset of arguments, Large models
         else
args     equ   4                   ;offset of arguments, Small models
         endif
;
cr       equ   0DH                 ;ASCII carriage return
lf       equ   0AH                 ;ASCII line feed
;
         pseg
;
         public capture,release    ;Function names for C
;
;
;  The function CAPTURE is called by the C program to
;  take ove the MS-DOS and keyboard driver Control-
;  Break interrupts ( 1BH and 23H).  It is passed the
;  address of a flag within the C program which is set
;  to TRUE whenever a Control-Break and/or Control-C
;  is detected.  The function is used in the form:
;
;                   static int flag;
;                   capture (&flag);
;
;
capture  proc  near                ;Take over Control-Break
         push  bp                  ;interrupt vectors
         mov   bp,sp
         push  ds
         mov   ax,word ptr [bp+args]
         mov   cs:flag,ax          ;save address of interger
         mov   cs:flag+2,ds        ;flag variable in C program
                                   ;pick up original vector contents
         mov   ax,3523H            ;for interrupt 23H (MS-DOS
         int   21H                 ;Control-Break handler)
;
         mov   cs:int23,bx
         mov   cs:int23+2,es
         mov   ax,351BH            ;and interrupt 1BH
         int   21H                 ;(IBM PC ROM BIOS keyboard driver
         mov   cs:int1b,bx         ;Control-Break interrupt handler)
         mov   cs:int1b+2,es
;
         push  cs                  ;set address of new handler
         pop   ds
         mov   dx,offset ctrlbrk   ;load offset of Control-Break
         mov   ax,02523H           ;for interrupt 23H
         int   21H
;
         mov   ax,0251BH           ;for interrupt 1BH
         int   21H
;
         pop   ds                  ;restore registers and
         pop   bp                  ;return to C program
;
         ret
;
capture  endp
;
;
;  The function RELEASE is called by the C program to
;  return the MS-DOS and keyboard driver Control-Break
;  interrupt vectors ( 1BH and 23H) to their original state.
;  Interrupt 23H is also automatically restored by MS-DOS
;  upon the termination of a process,  however,  calling
;  RELEASE allows the C program to restore the default
;  action of a Control-C withiout terminating.  The function
;  is used in the form:
;
;                   release();
;
;
release  proc  near                ;Restore Control-Break interrupt
         push  bp                  ;vectors to their original state
         mov   bp,sp
         push  ds
         mov   dx,cs:int1b         ;Set interrupt 1BH
         mov   ds,cs:int1b+2       ;(MS-DOS Control-Break
         mov   ax,0251BH           ;interrupt handler)
         int   21H
;
         mov   dx,cs:int23         ;Set interrupt 23H
         mov   ds,cs:int23+2       ;(IBM PC ROM BIOS keyboard driver
         mov   ax,02523H           ;Control-Break interrupt handler)
         int   21H
;
         pop   ds                  ;restore registers and
         pop   bp                  ;return to C program
;
         ret
;
release  endp
;
;
;  This is the actual interrupt handler which is called by
;  the ROM BIOS keyboard driver and/or by MS-DOS when a
;  Control-C and/or Control-Break is detected.  Since the
;  interrupt handler may be called asynchronously by the
;  keyboard driver,  it is severely restricted in what it
;  may do without crashing the system (e.g. no calls on
;  DOS allowed).  In this version,  it simply sets a flag
;  within the C program to TRUE to indicate that a Control-
;  C and/or Control-Break has been detected;  the address of
;  this flag was passed by the C program during the call to
;  the CAPTURE function.
;
;
ctrlbrk  proc  far                 ;Control-Break interrupt handler
         push  bx                  ;Save affected regiserts
         push  ds
;
         mov   bx,cs:flag          ;set flag within C program
         mov   ds,cs:flag+2        ;to "TRUE"
         mov   word ptr ds:[bx],-1
;
         pop   ds                  ;restore registers and
         pop   bx                  ;exit
;
         iret
;
ctrlbrk  endp
;
;
flag     dw    0,0                 ;Long address of C program's
                                   ;Control-Break detected flag
;
int23    dw    0,0                 ;Original contents of MS-DOS
                                   ;Control-Break interrupt 23H vector
;
int1b    dw    0,0                 ;Original contents of ROM BIOS
                                   ;keyboard driver Control-Break
                                   ;interrupt 1BH vector
;
         endps
;
         end
