;
;Sample application program to be used with customized boot routine.
;
cseg	segment
	assume	cs:cseg,ds:cseg
	org	100h	;COM files start at offset 100 (hex)
start	proc	far
;
;Output greeting string.
;
	mov	si,offset greeting_string
	call	string_out	;Display initial message
;
;Program is finished-enter an infinite loop.
;
end_loop:
	jmp	end_loop
;
;Label strings.
;
greeting_string	db	0dh,0ah,'Congratulations!',0dh,0ah
	db	0dh,0ah,'You have booted a sample application program.'
	db	0dh,0ah,0
start	endp
;
;Subroutine outputs the string starting at SI.  String is terminated
;  with a 0 byte.
;
string_out	proc	near
	lodsb		;Get the next character
	and	al,al	;Is it a 0 byte to mark end?
	jnz	not_end
	ret		;If so, we're done
not_end:
	push	si
	sub	bh,bh	;Display page 0
	mov	ah,14	;Teletype-like character output function #
	int	10h	;Display the character
	pop	si
	jmp	string_out
string_out	endp
cseg	ends
	end	start	;Program is to begin at label START
