;
;Program to make a bootable disk, set to load and run the application
;  program upon booting.
;
stack	segment	para stack 'STACK'
	db	64 dup('stack   ')
stack	ends
;
;Note: for convenience, both the boot routine and the application program
;  are contained in a single segment.  This limits the maximum size of the
;  application program to slightly less than 64K.
;
dseg	segment
boot_len	equ	512	;Maximum length of boot routine
msg1	db	0dh,0ah,'File containing boot routine: $'
msg2	db	0dh,0ah,'Boot routine file cannot be opened.',0dh,0ah,'$'
bootname	db	15,?,15 dup(?)	;Temporary storage for boot routine
					; file name
bootfcb	db	37 dup(?)	;File control block for boot routine file
bootbuf	db	boot_len dup(?)	;Buffer to hold boot routine
prog_len	equ	4096	;Maximum length of application program buffer
				; (must be a multiple of 128)
msg3	db	0dh,0ah,'File containing application program: $'
msg4	db	0dh,0ah,'Application program file cannot be opened.'
	db	0dh,0ah,'$'
progname	db	15,?,15 dup(?)	;Temporary storage for boot routine
					; file name
progfcb	db	37 dup(?)	;File control block for boot routine file
;
;Buffer for the application program.  The DUP factor should be large
;  enough to hold the whole program, but less than 64K.
;
progbuf	db	prog_len dup(?)
progend	label	byte	;End of the program buffer
;
;Each 4-byte group describes the parameters to be used when formatting
;  a sector.  This format block is used for an 8-sector track.
;
format_block	db	0,0,1,2
	db	0,0,2,2
	db	0,0,3,2
	db	0,0,4,2
	db	0,0,5,2
	db	0,0,6,2
	db	0,0,7,2
	db	0,0,8,2
msg5	db	0dh,0ah,0dh,0ah,'Insert a blank disk in drive A:.'
	db	0dh,0ah,'This disk will be wiped out, so be careful!'
	db	0dh,0ah,'Strike any key to begin...',7,'$'
msg6	db	0dh,0ah,0dh,0ah,'The disk in drive A: is ready to boot.'
	db	0dh,0ah,'$'
dseg	ends
;
cseg	segment
	assume	cs:cseg,ds:dseg,es:dseg
start	proc	far
	push	ds
	sub	ax,ax
	push	ax	;Set stack for return to DOS
;
;Set working data segment.
;
	mov	ax,dseg
	mov	ds,ax
	mov	es,ax	;Set ES for the parse filename function
;
;Get the boot routine file control block set up.
;
	mov	dx,offset msg1
	mov	ah,9
	int	21h	;Prompt for boot file name
	mov	dx,offset bootname
	mov	ah,0ah
	int	21h	;Get boot file name
	mov	si,offset bootname+2	;Skip the count bytes in bootname
	mov	di,offset bootfcb
	mov	al,1
	mov	ah,29h
	int	21h	;Parse the filename into a file control block
;
;Open the boot routine file.
;
	mov	dx,offset bootfcb
	mov	ah,0fh
	int	21h	;Open it
	and	al,al
	jz	read_boot
;
;Error in trying to open the boot routine file.
;
	mov	dx,offset msg2
	mov	ah,9
	int	21h	;Notify of error
	jmp	done
;
;Read in the boot record.
;The record point field is set to the top of the file (record 0) by the open.
;
read_boot:
;
;First set load address.
;
	mov	dx,offset bootbuf
	mov	ah,1ah
	int	21h
;
;Now read it.
;
	mov	dx,offset bootfcb
	mov	cx,boot_len/128	;# of 128-byte records to be read
	mov	ah,27h
	int	21h	;Read it as a single block
;
;Now read in the application program.
;Get the application routine file control block set up.
;
	mov	dx,offset msg3
	mov	ah,9
	int	21h	;Prompt for application file name
	mov	dx,offset progname
	mov	ah,0ah
	int	21h	;Get application file name
	mov	si,offset progname+2	;Skip the count bytes in progname
	mov	di,offset progfcb
	mov	al,1
	mov	ah,29h
	int	21h	;Parse the filename into a file control block
;
;Open the application routine file.
;
	mov	dx,offset progfcb
	mov	ah,0fh
	int	21h	;Open it
	and	al,al
	jz	read_appl
;
;Error in trying to open the application routine file.
;
	mov	dx,offset msg4
	mov	ah,9
	int	21h	;Notify of error
	jmp	done
;
;Read in the application program.
;The record point field is set to the top of the file (record 0) by the open.
;
read_appl:
;
;First set load address.
;
	mov	dx,offset progbuf
	mov	ah,1ah
	int	21h
;
;Now read it.
;
	mov	dx,offset progfcb
	mov	cx,prog_len/128	;# of 128-byte records to be read
	mov	ah,27h
	int	21h	;Read it as a single block
;
;Now write on the disk in drive A:.
;
;Warn the user first!
;
	mov	dx,offset msg5
	mov	ah,9
	int	21h
;
;Wait for user to strike a new key to proceed.
;
	mov	ax,0c01h	;DOS function empties key buffer before
	int	21h		; reading next character
;
;Format and write the boot record via BIOS.
;
	sub	dx,dx	;Side 0, drive 0
	sub	ch,ch	;Track 0
	mov	cl,1	;Sector 1
	mov	bx,offset format_block	;Point to format parameters
	mov	ah,5	;BIOS format track function
	mov	al,8	;Format with 8 sectors
	int	13h	;Format the track
;
;Write the track.
;
	sub	dx,dx	;Side 0, drive 0
	sub	ch,ch	;Track 0
	mov	cl,1	;Start at sector 1
	mov	bx,offset bootbuf	;Take input from here
	mov	ah,3	;BIOS write sector function
	mov	al,1	;Write 1 sector
	int	13h	;Write the boot track
;
;Format and write each track of the application program in turn.
;
	mov	ch,1	;Start at track 1
	mov	bx,offset progbuf	;Point to start of application
					; program
appl_loop:
	push	bx
	push	cx
	call	format_write_track
	pop	cx
	pop	bx
	inc	ch	;Point to the next track
	add	bx,1000h	;Point to the next section of program code
	cmp	bx,offset progend	;See if we're at the end of the
	jb	appl_loop		; application program buffer
;
;Notify finished.
;
	mov	dx,offset msg6
	mov	ah,9
	int	21h
;
;Return to DOS.
;
done:
	ret
start	endp
;
;Subroutine to format and write the data starting at DS:BX to track CH.
;
format_write_track	proc	near
;
;First format the track.
;
	push	bx	;Save the data to be written address
	sub	dx,dx	;Side 0, drive 0
	mov	cl,1	;Start at sector 1
	mov	bx,offset format_block	;Point to format parameters
	mov	[bx],ch	;Set each of the format records to point to the
			; track to be formatted
	mov	[bx+4],ch
	mov	[bx+8],ch
	mov	[bx+12],ch
	mov	[bx+16],ch
	mov	[bx+20],ch
	mov	[bx+24],ch
	mov	[bx+28],ch
	mov	ah,5	;BIOS format track function
	mov	al,8	;Format with 8 sectors
	int	13h	;Format the track
	pop	bx	;Retrieve the address of the data to be written
;
;Write the track.
;
	sub	dx,dx	;Side 0, drive 0
	mov	cl,1	;Start at sector 1
	mov	ah,3	;BIOS write sector function
	mov	al,8	;Write 8 sectors
	int	13h	;Write the track
;
	ret
format_write_track	endp
cseg	ends
	end	start	;Program will begin at label START
