DATA     SEGMENT   WORD PUBLIC 'data'
DATA     ENDS
DGROUP   GROUP     data
CODE     SEGMENT   BYTE PUBLIC 'code'
         ASSUME    CS:CODE,DS:DGROUP

;declare Function BIOSPrint%( T$, BYVAL P%)

;t% = BIOSprint%( T$, p% )
;T$ = NEAR sting to send to printer
;p% = printer number 1..3
;t% = Number of chars NOT printed (0=all chars printed)
;     returned in this manner to allow easy implementation
;     of error recovery and print continuance using MID$()

PUBLIC          BIOSPRINT
BIOSPRINT       PROC FAR

        PUSH    BP          ;save BP
        MOV     BP,SP       ;set to address BP
        push    si          ;save seg-registers used

        mov     dx, [bp]+6  ;get printer port number
        dec     dx          ;adjust to 0..2

        mov     bx,[bp]+8   ;get string descriptor
        mov     cx,[bx]     ;get string length
        cmp     cx,00       ;is it a null string?
        je      BIOSPrDone  ;YES, skip string processing

        mov     si,[bx]+2   ;get string address (near strings only)

BIOSPrLoop:
        lodsb               ;get char to print into AL, [ds:si]

        xor     ah, ah      ;be sure function is zero
        int     17h         ;bios int

        and     ax, 2900h   ;test for printer error
        jne     BIOSPrDone  ;jump out of loop for error

        loop    BIOSPrLoop  ;one less char not printed (cx=cx-1) jne

BIOSPrDone:
        mov     ax, cx      ;set number of chars NOT printed

        pop     si
        pop     bp
        ret     4

BIOSPRINT       endp
CODE     ENDS
         END

