.XLIST
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; CONTENTS:                                                                ;;
;;         Contains equ statements that interface to DOS through            ;;
;;         DosInt (21h) Each label has a name.                              ;;
;; Dos Functions divided up as follows....                                  ;;
;;     HEX VALUE(S)      MEANING                                            ;;
;;     ------------      -------                                            ;;
;;         0             Program Terminate (Old version)                    ;;
;;      1  -  C          Traditional Character device I/O                   ;;
;;      D  -  24         Traditional File Manegment (FCB'S)                 ;;
;;     25  -  26         Traditional Non-Device Functions                   ;;
;;     27  -  29         Traditional File Manegment (FCB's)                 ;;
;;     2A  -  2E         Traditional Non-Device Functions                   ;;
;;     2F  -  38         Extended Function Group                            ;;
;;     39  -  3B         Directory Group                                    ;;
;;     3C  -  46         Extended File manegment Group                      ;;
;;        47             Directory Group                                    ;;
;;     48  -  4B         Extended Menory Manegment Group                    ;;
;;     4C  -  4F         Extended Function Group                            ;;
;;     54  -  57         Extended Function Group                            ;;
;;     59  -  5C         Extended Function Group                            ;;
;;        62             Extended Function Group                            ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; The Equates........................

DosInt                  equ     21h             ; Interrupt to Dos

DosProgramStop          equ     0h      ; 'Old' Way of ending program

DosKbdInput             equ     1h      ; Waits for 1 char from KBD
DosScrOutput            equ     2h      ; Prints char in DL to screen
DosAuxInput             equ     3h      ; Input from Auxilarry device
DosAuxOutput            equ     4h      ; Output to auxilarrry device
DosLptOutput            equ     5h      ; Output char in DL to LPT device
DosConsoleIO            equ     6h      ; Depnding in DL, out or in
DosDConInNoEcho         equ     7h      ; DIRECT console in with no echo
DosConInNoEcho          equ     8h      ; Console input with no echo (Checks)
DosPrintString          equ     9h      ; Prints string (DS:DX) ending with $
DosBufferedKbdIn        equ     0Ah     ; Buffered keyboard input
DosCheckStdInStat       equ     0Bh     ; Checks for waiting char on input
DosClrKbdInvoke         equ     0Ch     ; Clear buffer and does {AL}

DosDiskReset            equ     0Dh     ; Flushes all bufferes and resets disk
DosSetCurrDisk          equ     0Eh     ; Selcts current default drive (0=A)
DosOpenFCB              equ     0Fh     ; Opens file in FCB fromat
DosCloseFCB             equ     10h     ; Closes FCB
DosFindFirstFCB         equ     11h     ; Finds first occuring FCB file
DosFindNextFCB          equ     12h     ; Finds the next FCB
DosDeleteFCB            equ     13h     ; Deletes an FCB
DosSeqReadFCB           equ     14h     ; Read file sequencially on FCB
DosSeqWriteFCB          equ     15h     ; WriteSequencially
DosCreateFCB            equ     16h     ; Create file in Directory
DosRenameFCB            equ     17h     ; Rename file
DosGetCurrDisk          equ     19h     ; Get the current Diskette
DosSetDTA               equ     1Ah     ; Set the Disk Tranfer Address
DosGetFAT               equ     1Bh     ; Get FAT from disk
DosGetFATSpecific       equ     1Ch     ; FAT being specific and not current
DosRandReadFCB          equ     21h     ; Random FCB read
DosRandWriteFCB         equ     22h     ; Random FCB Write
DosFileSizeFCB          equ     23h     ; File size of FCB
DosSetRelRec            equ     24h     ; Set Relative record field

DosSetVec               equ     25h     ; Set current Interrupt vector
DosCreateNewPSP         equ     26h     ; Create a new Program Segment Pre

DosRandBlockReadFCB     equ     27h     ; Randommly read FCB Block o data
DosRandBlockWriteFCB    equ     28h     ; Write, also
DosParseFileName        equ     29h     ; Parses filename into FCB format

DosGetDate              equ     2Ah     ; Get the current date
DosSetDate              equ     2Bh     ; Set the current date
DosGetTime              equ     2Ch     ; Get the current time
DosSetTime              equ     2Dh     ; Set the current Time
DosSetVerify            equ     2Eh     ; Set/Reset verify switch

DosGetDTA               equ     2Fh     ; Get the current DTA
DosGetVersion           equ     30h     ; Get the current version of DOS
DosTSRType1             equ     31h     ; Terminate and stay resident type 1
DosCtrlBreakCheck       equ     33h     ; Control Break checking
DosGetVec               equ     35h     ; Get interrupt vector
DosDiskBytesFree        equ     36h     ; Get Disk bytes free
DosCountryInfo          equ     38h     ; Get/Set country Parms

DosMkDir                equ     39h     ; Make a directory
DosRmDir                equ     3Ah     ; Remove a subdirectory
DosChDir                equ     3Bh     ; Change currentDirectory

DosCreateFile           equ     3Ch     ; Create a file (ASCIIZ)
DosOpenFile             equ     3Dh     ; Open file (ASCIIZ)
DosCloseFile            equ     3Eh     ; Close file (Handle from Create/open)
DosReadFile             equ     3Fh     ; Read from handle
DosWriteFile            equ     40h     ; Write to file Handle
DosDelFile              equ     41h     ; Delete file from dir spec (ASCIIZ)
DosSeek                 equ     42h     ; Seek into a file (handle)
DosChangeFileMode       equ     43h     ; Change file type (HRSA)
DosIOCTL                equ     44h     ; IO control for devices
DosDUPHandle            equ     45h     ; Duplicate file handle
DosForceDUPHandle       equ     46h     ; Force a duplicate handle

DosGetCurrDir           equ     47h     ; Get Current Directory

DosAllocMem             equ     48h     ; Allocate memory
DosFreeAllocMem         equ     49h     ; Free Up allocated memory
DosModMemBlock          equ     4Ah     ; Modify memory blocks
DosExec                 equ     4Bh     ; Execute (Load and execute)

DosExitProgram          equ     4Ch     ; End program with return code
DosGetRetCode           equ     4Dh     ; Get subprocess return code
DosFindFirst            equ     4Eh     ; Find First matching file (ASCIIZ)
DosFindNext             equ     4Fh     ; Find Next Matching File (ASCIIZ)

DosGetVerify            equ     54h     ; Get current verify state
DosRenFile              equ     56h     ; Rename file (ASCIIZ)
DosTimeDateStamp        equ     57h     ; Time And Dtae stamp

DosGetExtErr            equ     59h     ; Get extended error

DosCreateTempFile       equ     5Ah     ; Create a temporary file
DosCreateNewFile        equ     5Bh     ; Create a new file (PATH)
DosFileLock             equ     5Ch     ; Lock/Unlock file acsess

DosGetPSP               equ     62h     ; Get PSP Address
.LIST
