                        PAGE    ,132
                        Title   System Key Interface -- TSR
                        .286c

;----------------------------------------------------------------------------;
; This SysReq Interface file is actually composed of 2 parts.  One part is   ;
; the Int routine that detects a SysReq Key Depress/Release and the second   ;
; part being the code that installs this routine as a TSR. Modify the code   ;
; to your hearts content.  This is simply a way to to it in Assembly.        ;
;----------------------------------------------------------------------------;

; Include the Dos Calls Equates from this file -- Note only a few are
; used here, but that include file may prove useful.

INCLUDE DOSCALLS.INC


; Other Undocumented Stuff... NOT IN DOSCALLS.INC
DosVarCall  EQU 34h     ; Function to get dos busy flag
DosNotBusy  EQU 0h      ; This is =0 when this is!!


_TEXT  SEGMENT
                ASSUME cs:_TEXT, ds:_TEXT, ss:_TEXT, es:_TEXT
                ORG 100H
ENTRY:          Jmp     Install


Copyright       db      '(C) Copyright 1988, Jovo Systems Incorporate'
Installed       db      'SYSKEY installed.',13,10,'$'
MakeMsg         db      'System Key Request -- MAKE   '
MakeMsgLen      EQU     $-MakeMsg
BreakMsg        db      'System Key Request -- BREAK  '
BreakMsgLen     EQU     $-BreakMsg
UnkMsg          db      'System Key Request -- UNKNOWN'
UnkMsgLen       EQU     $-UnkMsg

OldInt15        dd      ?       ; Old address of  int 15
DosBusyAddress  dd      ?       ; Address of where to find if DOS is busy

                PUBLIC  OldInt15
                PUBLIC  DosBusyAddress

SysKeyCode      EQU     85h     ; The code for this
Make            EQU     0h      ; Make code
Break           EQU     1h      ; Break code




SysKeyInt       Proc    FAR
                PUBLIC  SysKeyInt
;----------------------------------------------------------------------------;
; This is where INT 15h goes to and we check if key was pressed and such.    ;
; and thus if not, we jump to the old BIOS routine used otherwise.           ;
;----------------------------------------------------------------------------;
                ASSUME  ds:NOTHING      ;
                Cmp     Ah,SysKeyCode   ; Is key being gener. ?
                Je      KeyON           ; YES!
OldCall:        Jmp     Cs:[OldInt15]   ;
                                        ;
        KeyON:                          ;
                Push    Ds              ;
                Push    Si              ;
                Lds     Si,cs:DosBusyAddress
                Cmp     Byte Ptr ds:[si],0
                Jz      ghead           ;
                Pop     Si              ;
                Pop     Ds              ;
                Jmp     OldCall         ; Call the old int -- DOS BUSY!!
        ghead:                          ;
                Pop     Si              ;
                Pop     Ds              ;
                                        ; At This point DOS is not busy
                Sti                     ;
                Pusha                   ; Push all

                Push    Es              ;
                                        ;
                Push    Cs              ;
                Pop     Es              ;
                                        ;
        Test1:                          ;
                Cmp     Al,Make         ; Is it a make?
                Jne     Test2           ; No, Check for break
                                        ;
; HERE IS WHERE THE SysReq KEY IS DEPRESSED, PROCESSING MAY BEGIN HERE
; But for now in this TSR, we simple print an anoying message on the screen.

                Mov     Bp,OFFSET MakeMsg
                Mov     Cx,MakeMsgLen   ;
                Jmp     Short   PrtM    ;
                                        ;
        Test2:                          ;
                Cmp     Al,Break        ; Is it a Break?
                Jne     UnknownKey      ; NO, It is UNKNOWN
                                        ;
; HERE Is where the SysReq KEY Has Been Released (After Depressing, of course)
; It is here where you should place your Desired code, i.e.
; Task Managers (Switchers), Some Utility TSR, or a call to a TSR or
; if you are daring enough, a menu for all TSR's which selects one to
; 'pull up'.
                Mov     Bp, OFFSET BreakMsg
                Mov     Cx,BreakMsgLen  ;
                Jmp     Short   PrtM    ;
                                        ;
        UnknownKey:                     ;
                Mov     Bp, OFFSET UnkMsg
                Mov     Cx,UnkMsgLen    ;
                                        ;
        PrtM:                           ;
                Mov     Ax,1300h        ;
                Mov     Bx,4            ;
                Mov     Dx,0116h        ;
                Int     10h             ;
                                        ;
                                        ;
                Pop     Es              ;
                Popa                    ;
                Ret     2               ;
SysKeyInt       Endp


                ASSUME  ds:_TEXT

Install Proc    Near
;----------------------------------------------------------------------------;
; Installs thing and stays resident.                                         ;
;----------------------------------------------------------------------------;
        ; Set Up our routine to snag the Sys key in interrupt
                Mov     Ah,DosGetVec    ; Get the vector
                Mov     Al,15h          ; This
                Int     DosInt          ;
                Mov     Word Ptr OldInt15,Bx
                Mov     Ax,Es
                Mov     Word Ptr OldInt15+2,Ax
                Push    Cs
                Pop     Es
                Mov     Dx, OFFSET SysKeyInt
                Mov     Al,15h
                Mov     Ah,DosSetVec    ;
                Int     DosInt          ;

        ; Get the Address of the Busy flag in DOS
                Push    Es              ;
                Push    Bx              ;
                Mov     Ax,DosVarCall*256   ; The Function
                Int     DosInt          ; Call Dos
                Mov     Ax,Es           ;
                Mov     Word Ptr DosBusyAddress,Bx  ; Save this
                Mov     Word Ptr DosBusyAddress+2,Ax; And this
                Pop     Bx              ;
                Pop     Es              ;
        ; Now, finish Up with a message.......
                Mov     Dx, OFFSET Installed
                Mov     Ah,DosPrintString
                Int     DosInt
                Mov     Bx,OFFSET Install       ; Get add of this
                Mov     Ax,Bx           ;
                Mov     Cl,4            ; Divide by 16
                Shr     Ax,Cl           ;
                Inc     Ax              ;
                Mov     Dx,Ax           ;
                Mov     Al,0            ;
                Mov     Ah,DosTSRType1  ;
                Int     DosInt          ; Bye Bye
Install         Endp

_TEXT           ENDS

                END     ENTRY

