                   PAGE    ,132
; ============== Turbo Prolog Interface ===================================
; The Purpose of these Clauses is to Fixup a name so that They look nice
; In turbo prolog..
; Note that the call is fixup(Instring,Outstring),
; Turbo Prolog Supplies us with the address of the Instring at [Bp+10] modif.
; The Outstring address we MUST supply to turbo prolog and this address MUST
; be placed at [Bp+6]modified .
; Note that the latest changes have made the algorithm so that the
; array of strings is now circular.
;
; Note that to use this for turbo prolog, you must declare this routine
; external asm in the GLOBAL PREDICATES SECTION, i.e.
;
; GLOBAL PREDICATES
;        .
;        .
;        .
; determ fixup(STRING,STRING) - (i,o) language asm
;
; A string Must be used as the parameter type.

.XLIST
XchgSeg         MACRO   Seg1,Seg2
                Push    Seg1        ; Save the Segment register
                Push    Seg2        ; Save the Segment register
                Pop     Seg1        ; Put Segment here
                Pop     Seg2        ; The same for the first
                ENDM

Pusha           MACRO
                Push    Ax          ; Save the regs
                Push    Bx          ;
                Push    Cx          ;
                Push    Dx          ;
                Push    Bp          ;
                Push    Si          ;
                Push    Di          ;
                Pushf               ; And the fags
                ENDM

Popa            MACRO
                Popf                ; Pop All
                Pop     Di          ;
                Pop     Si          ;
                Pop     Bp          ;
                Pop     Dx          ;
                Pop     Cx          ;
                Pop     Bx          ;
                Pop     Ax          ;
                ENDM

.LIST


                Public  fixup_0

InputArg        Equ [Bp+10]
OutputArg       Equ [Bp+6]
BytesPerEntry   Equ 40


Fixup           Segment Byte
                Assume  Cs:Fixup

DataArea        DB      40 dup(BytesPerEntry dup("*"))  ; A 40x40 array
OldDs           Dw      ?
OldEs           Dw      ?
CurrPos         Db      0           ; Defines current position
CurrOff         Dw      OFFSET DataArea ; This is what it starts at -- Changes


fixup_0         Proc    Far
;-----------------------------------------------------------------------------;
; form is fixup(String,String) -- (i,o)                                       ;
;-----------------------------------------------------------------------------;
                Push    Bp                      ; Modified Bp, here!
                Mov     Bp,Sp                   ;
                Pusha                           ;
                Mov     OldDs,Ds                ;
                Mov     OldEs,Es                ;
                Lds     Si,InputArg             ;
                Push    Cs                      ; DatArea Segment is same as Cs
                Pop     Es                      ; To here
                Mov     Di,CurrOff              ; Snag the current offset
                Call    Proper                  ;
                Lds     Si,OutputArg            ; Place OUR ADDRESS HERE
                Mov     [Si+2],Es               ;
                Mov     [Si],Di                 ; Now Prolog knows where
                Inc     CurrPos                 ; Increment this
                Add     CurrOff,BytesPerEntry   ; Add to have new ofset next
                Mov     Ax,CurrOff              ; Get the current offset
                Mov     Bx,(SIZE DataArea)*BytesPerEntry; Get the # bytes there
                Cwd                             ; Do this
                Div     Bx                      ; Check it out
                Jo      NoCirculate             ; If OV then it's not past end
                Mov     Ax,OFFSET DataArea      ; Get the offset
                Mov     CurrOff,Ax              ; Save the first value
                Mov     CurrPos,0               ; And Clear this
NoCirculate:    Mov     Ax,OldDs                ;
                Mov     Ds,Ax                   ;
                Mov     Ax,OldEs                ;
                Mov     Es,Ax                   ;
                Popa                            ;
                Pop     Bp                      ;
                Ret     8                       ; Retrun removing parms
fixup_0         Endp

                                                Page
Length          Proc    Near
;-----------------------------------------------------------------------------;
;   Returns the length of an asciiz string.                                   ;
;   INPUT:                                                                    ;
;      DS:SI  = Address of ASCIIZ string                                      ;
;   OUTPUT:                                                                   ;
;      AX = Length of string (Not including the NULL char at end              ;
;-----------------------------------------------------------------------------;
                Push    Di          ;
                Push    Cx          ; Save them
                                    ;
                Xor     Cx,Cx       ; Clear to 0
                Not     Cx          ; And flip the bits
                Cld                 ;
                Mov     Di,Si       ;
                XchgSeg Ds,Es       ;
                                    ;
                Mov     Al,0        ; Search
                Repnz   Scasb       ; Scan for the 0
                Not     Cx          ; Flip the bits back
                Mov     Ax,Cx       ; Put count Here
                Dec     Ax          ; And take one out -- do not include 0
                XchgSeg Ds,Es       ;
                                    ;
                Pop     Cx          ; Get the old Cx
                Pop     Di          ; Get the ols si
                Ret                 ; And exit
Length          Endp

                                                Page
LowerCase       Proc    Near
;-----------------------------------------------------------------------------;
; Converts entire input string to lowercase.                                  ;
; INPUT :                                                                     ;
;    DS:SI = Address of source string.                                        ;
;    ES:DI = Address of new string exactly like first exept all lc.           ;
; OUTPUT :                                                                    ;
;    ES:DI = Address of New string all in lowercase.                          ;
;-----------------------------------------------------------------------------;
                Pusha               ;
                Cld                 ; Yep
                                    ;
                Call    Length      ; Get the Length
                Mov     Cx,Ax       ; Put it for the count
_UtoLtop:       Lodsb               ; Get it
                Cmp     Al,'A'      ; Well
                Jb      @F          ; Nope
                Cmp     Al,'Z'      ; Well...
                Ja      @F          ; Nope skip add
                Add     Al,20h      ; Convert to lower case
@@:             Stosb               ;
                Loop    _UtoLtop    ; Back
                                    ;
                Popa                ;
                Ret                 ;
LowerCase       Endp

                                                Page
Proper          Proc    Near
;-----------------------------------------------------------------------------;
; Make a given input string to proper format. i. e.                           ;
;    "THIS IS A STRING",0     made proper would look like...                  ;
;    "This Is A String",0                                                     ;
; INPUT :                                                                     ;
;      DS:SI = Source input string.                                           ;
;      ES:DI = Destination address.                                           ;
; OUTPUT:                                                                     ;
;      ES:DI = address of output proper string.                               ;
;-----------------------------------------------------------------------------;
                Pusha               ;
                Cld                 ;
                                    ; First convert to lowercase
                Mov     Di,Si       ; First make the source all lower
                Push    Es          ;
                Mov     Ax,Ds       ; Equate source and destination
                Mov     Es,Ax       ; so we can call below.
                Call    LowerCase   ; Make it all like lower case
                                    ; Now search and do.
                Pop     Es          ;
                Popa                ;
                Pusha               ;
                Mov     Ah,0        ; Clear our flag
_FindWord:      Lodsb               ;
                Cmp     Al,0        ; Are we done
                Je      _ProperDone ;
                Cmp     Al,'a'      ; well?
                Jb      @F          ;
                Cmp     Al,'z'      ;
                Ja      @F          ;
                Add     Al,-20h     ; Ok
                Dec     Ah          ;
@@:             Stosb               ;
                Or      Ah,Ah       ;
                Jns     _FindWord   ; Not negative then keep finding
                                    ; Found word and converted
_FindDelim:     Lodsb               ; Grab
                Cmp     Al,0        ;
                Je      _ProperDone ;
                Cmp     Al,'a'      ; Well
                Jae     _Pt2xx      ;
                Jmp     SHORT   _DFp;
_Pt2xx:         Cmp     Al,'z'      ; Ok?
                Jbe     @F          ; Skip the flag reset
_DFp:           Inc     Ah          ; Back to 0
@@:             Stosb               ;
                Or      Ah,Ah       ;
                Js      _FindDelim  ; While negative keep searching
                Jmp     _FindWord   ; Back to word search
_ProperDone:    Stosb               ; Save the ASCIIZ
                                    ;
                Popa                ;
                Ret                 ;
Proper          Endp


Fixup           Ends
                END
