

;structures

rh		struc		;request header 
rh_len		db	?	;len of packet
rh_unit		db	?     	;unit code 
				;(block devices only)
rh_cmd		db	?     	;device driver command
rh_status	dw	?     	;returned by device driver 
rh_res1		dd	?     	;reserved
rh_res2		dd	?     	;reserved
rh		ends	      	;

rh0		struc		;Initialization (command 0)
rh0_rh		db	size rh dup (?)	;fixed portion
rh0_nunits	db	?     	;number of units 
				;(block devices only)
rh0_brk_ofs	dw	?     	;offset address for break
rh0_brk_seg	dw	?     	;segment address for break
rh0_bpb_tbo	dw	?     	;offset address of pointer
				;to BPB array
rh0_bpb_tbs	dw	?     	;segment address of pointer 
				;to BPB array
rh0_drv_ltr	db	?     	;first available drive 
				;(DOS 3+) (block only)
rh0		ends	      	;

rh1		struc		;Media_Check (command 1) 	
rh1_rh		db	size rh dup (?)	;fixed portion
rh1_media	db	?     	;media descriptor from DPB
rh1_md_stat	db	?     	;media status returned by 
				;device driver
rh1_volid_ofs	dw	?	;offset address of
				;volume identification
				;DOS 3+ only
rh1_volid_seg	dw	?	;segment address of
				;volume identification
				;DOS 3+ only
rh1		ends	      	;

rh2		struc		;Get_BPB (command 2)
rh2_rh		db	size rh dup(?)	;fixed portion
rh2_media	db	?     	;media descriptor from DPB 
rh2_buf_ofs	dw	?     	;offset address of 
				;data transfer area
rh2_buf_seg	dw	?     	;segment address of 
				;data transfer area
rh2_pbpbo	dw	?     	;offset address of 
				;pointer to BPB
rh2_pbpbs	dw	?     	;segment address of 
				;pointer to BPB
rh2		ends	      	;

rh3		struc		;IOCTL_INPUT (command 3)
rh3_rh		db	size rh dup(?)	;fixed portion
rh3_media	db	?     	;media descriptor from DPB
rh3_buf_ofs  	dw	?     	;offset address of 
				;data transfer area
rh3_buf_seg  	dw	?     	;segment address of 
				;data transfer area
rh3_count 	dw	?     	;transfer count 
				;(sectors for block) 
				;(bytes for character)
rh3_start	dw	?     	;start sector number 
				;(block devices only)
rh3		ends	      	;

rh4		struc		;INPUT (command 4)
rh4_rh		db	size rh dup(?)	;fixed portion
rh4_media	db	?     	;media descriptor from DPB
rh4_buf_ofs  	dw	?     	;offset address of 
				;data transfer area
rh4_buf_seg  	dw	?     	;segment address of 
				;data transfer area
rh4_count 	dw	?     	;transfer count 
				;(sectors for block) 
				;(bytes for character)
rh4_start	dw	?     	;start sector number 
				;(block devices only)
rh4_volid_ofs	dw	?	;offset address of
				;volume identification
				;DOS 3+ only
rh4_volid_seg	dw	?	;segment address of
				;volume identification
				;DOS 3+ only
rh4		ends	      	;

rh5		struc		;ND_INPUT (command 5)
rh5_rh		db	size rh dup (?)	;fixed portion
rh5_return	db	?     	;character returned
rh5		ends	      	;

rh6		struc		;Input_Status (command 6) 
rh6_len		db	?     	;len of packet
rh6_unit	db	?     	;unit code 
				;(block devices only)
rh6_cmd		db	?     	;device driver command
rh6_status	dw	?     	;returned by device driver 
rh6_res1	dd	?     	;reserved
rh6_res2	dd	?     	;reserved
rh6		ends	      	;

rh7		struc		;Input_Flush (command 7)
rh7_len		db	?     	;len of packet
rh7_unit	db	?     	;unit code 
				;(block devices only)
rh7_cmd		db	?     	;device driver command
rh7_status	dw	?     	;returned by device driver 
rh7_res1	dd	?     	;reserved
rh7_res2	dd	?     	;reserved
rh7		ends	      	;

rh8		struc		;OUTPUT (command 8)
rh8_rh		db	size rh dup(?)	;fixed portion
rh8_media	db	?     	;media descriptor from DPB
rh8_buf_ofs  	dw	?     	;offset address of 
				;data transfer area
rh8_buf_seg  	dw	?     	;segment address of 
				;data transfer area
rh8_count 	dw	?     	;transfer count 
				;(sectors for block) 
				;(bytes for character)
rh8_start	dw	?     	;start sector number 
				;(block devices only)
rh8_volid_ofs	dw	?	;offset address of
				;volume identification
				;DOS 3+ only
rh8_volid_seg	dw	?	;segment address of
				;volume identification
				;DOS 3+ only
rh8		ends	      	;

rh9		struc		;OUTPUT_VERIFY (command 9)
rh9_rh		db	size rh dup(?)	;fixed portion
rh9_media	db	?     	;media descriptor from DPB
rh9_buf_ofs  	dw	?     	;offset address of 
				;data transfer area
rh9_buf_seg  	dw	?     	;segment address of 
				;data transfer area
rh9_count 	dw	?     	;transfer count 
				;(sectors for block) 
				;(bytes for character)
rh9_start	dw	?     	;start sector number 
				;(block devices only)
rh9_volid_ofs	dw	?	;offset address of
				;volume identification
				;DOS 3+ only
rh9_volid_seg	dw	?	;segment address of
				;volume identification
				;DOS 3+ only
rh9		ends	      	;

rh10		struc		;Output_Status (command 10)
rh10_len	db	?     	;len of packet
rh10_unit	db	?     	;unit code 
				;(block devices only)
rh10_cmd	db	?     	;device driver command
rh10_status	dw	?     	;returned by device driver 
rh10_res1	dd	?     	;reserved
rh10_res2	dd	?     	;reserved
rh10		ends	      	;

rh11		struc		;Output_Flush (command 11)
rh11_len	db	?     	;len of packet
rh11_unit	db	?     	;unit code 
				;(block devices only)
rh11_cmd	db	?     	;device driver command
rh11_status	dw	?     	;returned by device driver 
rh11_res1	dd	?     	;reserved
rh11_res2	dd	?     	;reserved
rh11		ends	      	;

rh12		struc		;IOCTL_OUTPUT (command 12)
rh12_rh		db	size rh dup(?)	;fixed portion
rh12_media	db	?     	;media descriptor from DPB
rh12_buf_ofs  	dw	?     	;offset address of 
				;data transfer area
rh12_buf_seg  	dw	?     	;segment address of 
				;data transfer area
rh12_count 	dw	?     	;transfer count 
				;(sectors for block) 
				;(bytes for character)
rh12_start	dw	?     	;start sector number 
				;(block devices only)
rh12		ends	      	;

rh13		struc		;Open (command 13)
rh13_len	db	?     	;len of packet
rh13_unit	db	?     	;unit code 
				;(block devices only)
rh13_cmd	db	?     	;device driver command
rh13_status	dw	?     	;returned by device driver 
rh13_res1	dd	?     	;reserved
rh13_res2	dd	?     	;reserved
rh13		ends	      	;

rh14		struc		;Close command 14)
rh14_len	db	?     	;len of packet
rh14_unit	db	?     	;unit code 
				;(block devices only)
rh14_cmd	db	?     	;device driver command
rh14_status	dw	?     	;returned by device driver 
rh14_res1	dd	?     	;reserved
rh14_res2	dd	?     	;reserved
rh14		ends	      	;

rh15		struc		;Removable (command 15)
rh15_len	db	?     	;len of packet
rh15_unit	db	?     	;unit code 
				;(block devices only)
rh15_cmd	db	?     	;device driver command
rh15_status	dw	?     	;returned by device driver 
rh15_res1	dd	?     	;reserved
rh15_res2	dd	?     	;reserved
rh15		ends	      	;

rh16		struc		;OUTPUT_BUSY (command 16)
rh16_rh		db	size rh dup (?)	;fixed portion
rh16_media	db	?     	;media descriptor
rh16_buf_ofs 	dw	?     	;offset address of 
				;data transfer area
rh16_buf_seg 	dw	?     	;segment address of 
				;data transfer area
rh16_count	dw	?     	;byte count returned 
				;from device driver
rh16		ends	      	;

rh17		struc		;(command 17)
rh17_len	db	?     	;len of packet
rh17_unit	db	?     	;unit code 
				;(block devices only)
rh17_cmd	db	?     	;device driver command
rh17_status	dw	?     	;returned by device driver 
rh17_res1	dd	?     	;reserved
rh17_res2	dd	?     	;reserved
rh17		ends	      	;

rh18		struc		;(command 18)
rh18_len	db	?     	;len of packet
rh18_unit	db	?     	;unit code 
				;(block devices only)
rh18_cmd	db	?     	;device driver command
rh18_status	dw	?     	;returned by device driver 
rh18_res1	dd	?     	;reserved
rh18_res2	dd	?     	;reserved
rh18		ends	      	;

rh19		struc		;Generic_IOCTL (command 19)
rh19_rh		db	size rh dup (?)	;fixed portion
rh19_major 	db	?     	;major function
rh19_minor	db	?     	;minor function
rh19_SI		dw	?     	;contents of SI register
rh19_DI		dw	?     	;contents of DI register
rh19_pkt_ofs	dw	?     	;offset address of
				;generic IOCTL request 
rh19_pkt_seg	dw	?     	;segment address of 
				;generic IOCTL request
rh19		ends	      	;

rh20		struc		;(command 20)
rh20_len	db	?     	;len of packet
rh20_unit	db	?     	;unit code 
				;(block devices only)
rh20_cmd	db	?     	;device driver command
rh20_status	dw	?     	;returned by device driver 
rh20_res1	dd	?     	;reserved
rh20_res2	dd	?     	;reserved
rh20		ends	      	;

rh21		struc		;(command 21)
rh21_len	db	?     	;len of packet
rh21_unit	db	?     	;unit code 
				;(block devices only)
rh21_cmd	db	?     	;device driver command
rh21_status	dw	?     	;returned by device driver 
rh21_res1	dd	?     	;reserved
rh21_res2	dd	?     	;reserved
rh21		ends	      	;

rh22		struc		;(command 22)
rh22_len	db	?     	;len of packet
rh22_unit	db	?     	;unit code 
				;(block devices only)
rh22_cmd	db	?     	;device driver command
rh22_status	dw	?     	;returned by device driver 
rh22_res1	dd	?     	;reserved
rh22_res2	dd	?     	;reserved
rh22		ends	      	;

rh23		struc		;Get_Device (command 23)
rh23_rh		db	size rh dup (?)	;fixed portion
rh23_IO		db	?     	;Input (unit code)
				;Output (last device)
rh23_dev_cmd	db	?     	;command code 
rh23_dev_stat	dw	?     	;status
rh23_reserved	dd	?     	;reserved
rh23		ends	      	;

rh24		struc		;Set_Device (command 24)
rh24_rh		db	size rh dup (?)	;fixed portion
rh24_IO		db	?     	;Input (unit code)
				;Output (last device)
rh24_dev_cmd	db	?     	;command code 
rh24_dev_stat	dw	?     	;status
rh24_reserved	dd	?     	;reserved
rh24		ends	      	;


;commands that do not have unique portions to the request header:
;	INPUT_STATUS 	(command 6)
;	INPUT_FLUSH	(command 7)
;	OUTPUT_STATUS	(command 10)
;	OUTPUT_FLUSH	(command 11)
;	OPEN		(command 13)
;	CLOSE		(command 14)
;	REMOVEABLE	(command 15)
;	 

