PROJ = ASMCLOCK
PROJFILE = ASMCLOCK.MAK
DEBUG = 0

PWBRMAKE  = pwbrmake
NMAKEBSC1  = set
NMAKEBSC2  = nmake
PBTDEPEND  = $(PROJ).exe
PREP  = prep
PROFILE  = profile
PLIST  = plist
PROFSET  = set
PROFNMAKE  = nmake
CC  = cl
CFLAGS_G  = /W2 /Gw /Zp /BATCH /FR$*.sbr
CFLAGS_D  = /Zi /Gi$(PROJ).mdt /Od /Gs /FPa
CFLAGS_R  = /Oe /Og /Os /Gs /FPa
ASM  = ml
AFLAGS_G  = /Cp /W2 /WX /I.\ /FR$*.sbr /VM
AFLAGS_D  = /Zi
AFLAGS_R  =  /nologo
MAPFILE_D  = NUL
MAPFILE_R  = NUL
LFLAGS_G  =   /BATCH
LFLAGS_D  = /CO /NOF
LFLAGS_R  =  /NOF /NOP
LLIBS_G  = LIBW.LIB SLIBCEW.LIB
LINKER	= link
ILINK  = ilink
LRF  = echo > NUL
RC  = rc
BRFLAGS  =  /o $(PROJ).bsc
BROWSE	= 1

DEF_FILE  = ASMCLOCK.DEF
OBJS  = ASMCLOCK.obj
SBRS  = ASMCLOCK.sbr

all: $(PROJ).exe

.SUFFIXES:
.SUFFIXES: .sbr .obj .asm

ASMCLOCK.obj : ASMCLOCK.ASM

ASMCLOCK.sbr : ASMCLOCK.ASM


$(PROJ).bsc : $(SBRS)
	$(PWBRMAKE) @<<
$(BRFLAGS) $(SBRS)
<<

$(PROJ).pbt : 
	$(PROFSET) MAKEFLAGS=
	$(PROFNMAKE) $(NMFLAGS) -f $(PROJFILE) $(PBTDEPEND)
	$(PREP) /P $(PBTDEPEND) /OT $(PROJ).pbt

$(PROJ).exe : $(DEF_FILE) $(OBJS)
!IF $(DEBUG)
	$(LRF) @<<$(PROJ).lrf
$(RT_OBJS: = +^
) $(OBJS: = +^
)
$@
$(MAPFILE_D)
$(LLIBS_G: = +^
) +
$(LLIBS_D: = +^
) +
$(LIBS: = +^
)
$(DEF_FILE) $(LFLAGS_G) $(LFLAGS_D);
<<
!ELSE
	$(LRF) @<<$(PROJ).lrf
$(RT_OBJS: = +^
) $(OBJS: = +^
)
$@
$(MAPFILE_R)
$(LLIBS_G: = +^
) +
$(LLIBS_R: = +^
) +
$(LIBS: = +^
)
$(DEF_FILE) $(LFLAGS_G) $(LFLAGS_R);
<<
!ENDIF
	$(LINKER) @$(PROJ).lrf
	$(NMAKEBSC1) MAKEFLAGS=
	$(NMAKEBSC2) $(NMFLAGS) -f $(PROJFILE) $(PROJ).bsc


.asm.sbr :
!IF $(DEBUG)
	$(ASM) /Zs $(AFLAGS_G) $(AFLAGS_D) /FR$@ $<
!ELSE
	$(ASM) /Zs $(AFLAGS_G) $(AFLAGS_R) /FR$@ $<
!ENDIF

.asm.obj :
!IF $(DEBUG)
	$(ASM) /c $(AFLAGS_G) $(AFLAGS_D) /Fo$@ $<
!ELSE
	$(ASM) /c $(AFLAGS_G) $(AFLAGS_R) /Fo$@ $<
!ENDIF


run: $(PROJ).exe
	WIN $(PROJ).exe $(RUNFLAGS)

debug: $(PROJ).exe
	WIN CVW $(CVFLAGS) $(PROJ).exe $(RUNFLAGS)
