MASM51
DOSSEG

MODEL SMALL

.STACK  256

;SLOWDOWN        equ     0


RED             equ     01h
GREEN           equ     02h
BLUE            equ     04h
WHITE           equ     08h

VGA_SEGMENT     equ     0a000h
SC_INDEX        equ     3c4h
MAP_MASK        equ     2
SCREEN_WIDTH    equ     80
SCREEN_HEIGHT   equ     350
WORDS_OUT_OK    equ     1

ObjectStructure struc
Delay           dw      ?
BaseDelay       dw      ?
Image           dw      ?
XCoord          dw      ?
XInc            dw      ?
XLeftLimit      dw      ?
XRightLimit     dw      ?
YCoord          dw      ?
YInc            dw      ?
YTopLimit       dw      ?
YBottomLimit    dw      ?
PlaneSelect     db      ?
                db      ?
ObjectStructure ends


.DATA

Colors  db      029h
        db      02fh
        db      03bh
        db      02fh
        db      03dh
        db      02fh
        db      03bh
        db      02fh
        db      03ah
        db      02fh
        db      03bh
        db      02fh
        db      03dh
        db      02fh
        db      03bh
        db      02fh
        db      000h

Square  label   byte
        dw      48,6
        rept    8
        db      0,0,0,0,0,0
        endm
        .radix  2
        db      0,11111111,11111111,11111111,11111111,0
        db      0,11111111,11111111,11111111,11111111,0
        db      0,11111111,11111111,11111111,11111111,0
        db      0,11111111,11111111,11111111,11111111,0
        db      0,11111111,11111111,11111111,11111111,0
        db      0,11111111,11111111,11111111,11111111,0
        db      0,11111111,11111111,11111111,11111111,0
        db      0,11111111,11111111,11111111,11111111,0
        db      0,11111111,00000000,00000000,11111111,0
        db      0,11111111,00000000,00000000,11111111,0
        db      0,11111111,00000000,00000000,11111111,0
        db      0,11111111,00000000,00000000,11111111,0
        db      0,11111111,00000000,00000000,11111111,0
        db      0,11111111,00000000,00000000,11111111,0
        db      0,11111111,00000000,00000000,11111111,0
        db      0,11111111,00000000,00000000,11111111,0
        db      0,11111111,00000000,00000000,11111111,0
        db      0,11111111,00000000,00000000,11111111,0
        db      0,11111111,00000000,00000000,11111111,0
        db      0,11111111,00000000,00000000,11111111,0
        db      0,11111111,00000000,00000000,11111111,0
        db      0,11111111,00000000,00000000,11111111,0
        db      0,11111111,00000000,00000000,11111111,0
        db      0,11111111,00000000,00000000,11111111,0
        db      0,11111111,11111111,11111111,11111111,0
        db      0,11111111,11111111,11111111,11111111,0
        db      0,11111111,11111111,11111111,11111111,0
        db      0,11111111,11111111,11111111,11111111,0
        db      0,11111111,11111111,11111111,11111111,0
        db      0,11111111,11111111,11111111,11111111,0
        db      0,11111111,11111111,11111111,11111111,0
        db      0,11111111,11111111,11111111,11111111,0
        .radix  10
        rept    8
        db      0,0,0,0,0,0
        endm

Diamond label   byte
        dw      48,6
        rept    8
        db      0,0,0,0,0,0
        endm
        .radix  2
        db      0,00000000,00000001,10000000,00000000,0
        db      0,00000000,00000011,11000000,00000000,0
        db      0,00000000,00000111,11100000,00000000,0
        db      0,00000000,00001111,11110000,00000000,0
        db      0,00000000,00011111,11111000,00000000,0
        db      0,00000000,00111110,01111100,00000000,0
        db      0,00000000,01111100,00111110,00000000,0
        db      0,00000000,11111000,00011111,00000000,0
        db      0,00000001,11110000,00001111,10000000,0
        db      0,00000011,11100000,00000111,11000000,0
        db      0,00000111,11000000,00000011,11100000,0
        db      0,00001111,10000001,10000001,11110000,0
        db      0,00011111,00000011,11000000,11111000,0
        db      0,00111110,00000111,11100000,01111100,0
        db      0,01111100,00001111,11110000,00111110,0
        db      0,11111000,00011111,11111000,00011111,0
        db      0,11111000,00011111,11111000,00011111,0
        db      0,01111100,00001111,11110000,00111110,0
        db      0,00111110,00000111,11100000,01111100,0
        db      0,00011111,00000011,11000000,11111000,0
        db      0,00001111,10000001,10000001,11110000,0
        db      0,00000111,11000000,00000011,11100000,0
        db      0,00000011,11100000,00000111,11000000,0
        db      0,00000001,11110000,00001111,10000000,0
        db      0,00000000,11111000,00011111,00000000,0
        db      0,00000000,01111100,00111110,00000000,0
        db      0,00000000,00111110,01111100,00000000,0
        db      0,00000000,00011111,11111000,00000000,0
        db      0,00000000,00001111,11110000,00000000,0
        db      0,00000000,00000111,11100000,00000000,0
        db      0,00000000,00000011,11000000,00000000,0
        db      0,00000000,00000001,10000000,00000000,0
        .radix  10
        rept    8
        db      0,0,0,0,0,0
        endm

Circle  label   byte
        dw      42,6
        rept    8
        db      0,0,0,0,0,0
        endm
        .radix  2
        db      0,00000000,00000001,10000000,00000000,0
        db      0,00000000,00011111,11111000,00000000,0
        db      0,00000000,11111111,11111111,00000000,0
        db      0,00000011,11111111,11111111,11000000,0
        db      0,00000111,11111111,11111111,11100000,0
        db      0,00001111,11111111,11111111,11110000,0
        db      0,00011111,11111111,11111111,11111000,0
        db      0,00111111,11111111,11111111,11111100,0
        db      0,00111111,11111111,11111111,11111100,0
        db      0,01111111,11111100,00111111,11111110,0
        db      0,11111111,11110000,00001111,11111111,0
        db      0,11111111,11100000,00000111,11111111,0
        db      0,11111111,11100000,00000111,11111111,0
        db      0,11111111,11100000,00000111,11111111,0
        db      0,11111111,11100000,00000111,11111111,0
        db      0,11111111,11110000,00001111,11111111,0
        db      0,01111111,11111100,00111111,11111110,0
        db      0,00111111,11111111,11111111,11111100,0
        db      0,00111111,11111111,11111111,11111100,0
        db      0,00011111,11111111,11111111,11111000,0
        db      0,00001111,11111111,11111111,11110000,0
        db      0,00000111,11111111,11111111,11100000,0
        db      0,00000011,11111111,11111111,11000000,0
        db      0,00000000,11111111,11111111,00000000,0
        db      0,00000000,00011111,11111000,00000000,0
        db      0,00000000,00000001,10000000,00000000,0
        .radix  10
        rept    8
        db      0,0,0,0,0,0
        endm

        even

ObjectList      label   ObjectStructure
ObjectStructure <1,21,Diamond,88,8,80,512,16,0,0,350,RED>
ObjectStructure <1,25,Square,296,8,112,480,144,0,0,350,RED>
ObjectStructure <1,24,Diamond,88,8,80,512,256,0,0,350,RED>
ObjectStructure <1,16,Square,120,0,0,640,144,4,0,280,BLUE>
ObjectStructure <1,11,Diamond,208,0,0,640,144,4,0,280,BLUE>
ObjectStructure <1,5,Square,296,0,0,640,144,4,0,288,BLUE>
ObjectStructure <1,3,Diamond,384,0,0,640,144,4,0,288,BLUE>
ObjectStructure <1,22,Square,472,0,0,640,144,4,0,280,BLUE>
ObjectStructure <1,8,Diamond,200,8,0,576,48,6,0,280,GREEN>
ObjectStructure <1,8,Square,248,8,0,576,96,6,0,280,GREEN>
ObjectStructure <1,8,Diamond,296,8,0,576,144,6,0,280,GREEN>
ObjectStructure <1,8,Square,344,8,0,576,192,6,0,280,GREEN>
ObjectStructure <1,8,Diamond,392,8,0,576,240,6,0,280,GREEN>
ObjectStructure <1,10,Circle,300,8,20,576,86,0,0,350,RED>
ObjectListEnd   label   ObjectStructure

OUT_WORD        macro
if WORDS_OUT_OK
        out     dx,ax
else
        out     dx,al
        inc     dx
        xchg    ah,al
        out     dx,al
        dec     dx
        xchg    ah,al
endif
        endm

CONSTANT_TO_INDEXED_REGISTER    macro   ADDRESS, INDEX, VALUE
        mov     dx,ADDRESS
        mov     ax,(VALUE shl 8) + INDEX
        OUT_WORD
        endm

.CODE

Start   proc    near
        cld
        mov     ax,@Data
        mov     ds,ax
        mov     ax,0010h
        int     10h
        mov     ax,(10h shl 8) + 2
        push    ds
        pop     es
        mov     dx,offset Colors
        int     10h
        CONSTANT_TO_INDEXED_REGISTER SC_INDEX, MAP_MASK, 08h
        mov     ax,VGA_SEGMENT
        mov     es,ax
        sub     di,di
        mov     bp,SCREEN_HEIGHT/16
BackdropBlockLoop:
        call    DrawGridCross
        call    DrawGridVert
        dec     bp
        jnz     BackdropBlockLoop
        call    DrawGridCross
AnimationLoop:
        mov     bx,offset ObjectList
ObjectLoop:
        dec     [bx+Delay]
        jnz     DoNextObject
        mov     ax,[bx+BaseDelay]
        mov     [bx+Delay],ax
        mov     dx,SC_INDEX
        mov     ah,[bx+PlaneSelect]
        mov     al,MAP_MASK
        OUT_WORD
        mov     cx,[bx+XCoord]
        cmp     cx,[bx+XLeftLimit]
        ja      CheckXRightLimit
        neg     [bx+XInc]
CheckXRightLimit:
        cmp     cx,[bx+XRightLimit]
        jb      SetNewX
        neg     [bx+XInc]
SetNewX:
        add     cx,[bx+XInc]
        mov     [bx+XCoord],cx

        mov     dx,[bx+YCoord]
        cmp     dx,[bx+YTopLimit]
        ja      CheckYBottomLimit
        neg     [bx+YInc]
CheckYBottomLimit:
        cmp     dx,[bx+YBottomLimit]
        jb      SetNewY
        neg     [bx+YInc]
SetNewY:
        add     dx,[bx+YInc]
        mov     [bx+YCoord],dx

        mov     si,[bx+Image]
        call    DrawObject

DoNextObject:
        add     bx,size ObjectStructure
        cmp     bx,offset ObjectListEnd
        jb      ObjectLoop

if SLOWDOWN
        mov     cx,SLOWDOWN
DelayLoop:
        loop    DelayLoop
endif

CheckKey:
        mov     ah,1
        int     16h
        jz      AnimationLoop
        sub     ah,ah
        int     16h
        mov     ax,0003h
        int     10h
        mov     ah,4ch
        int     21h
Start   endp

DrawGridCross   proc    near
        mov     ax,0ffffh
        mov     cx,SCREEN_WIDTH/2-1
        rep     stosw
        mov     ax,0080h
        stosw
        ret
DrawGridCross   endp

DrawGridVert    proc    near
        mov     ax,0080h
        mov     dx,15
BackdropRowLoop:
        mov     cx,SCREEN_WIDTH/2
        rep     stosw
        dec     dx
        jnz     BackdropRowLoop
        ret
DrawGridVert    endp

DrawObject      proc    near
        mov     ax,SCREEN_WIDTH
        mul     dx
        shr     cx,1
        shr     cx,1
        shr     cx,1
        add     ax,cx
        mov     di,ax
        lodsw
        mov     dx,ax
        lodsw
        mov     bp,SCREEN_WIDTH
        sub     bp,ax
DrawLoop:
        mov     cx,ax
        rep     movsb
        add     di,bp
        dec     dx
        jnz     DrawLoop
        ret
DrawObject      endp

        END



