/* DISKS.C - necessary utility functions to read and write floppy 
             diskettes on a track by track basis.

   Laine Stump, sometime in 1987 or 88 (I can't remember)
   
   Do what you want with it. No rights reserved.

*/

#include <bios.h>
#include <stdio.h>
#include <stdlib.h>

#define FALSE 0
#define TRUE  1

#define DISKRESET  0
#define DISKREAD   2
#define DISKWRITE  3
#define DISKVERIFY 4
#define DISKFORMAT 5

/* following is for a standard 360k format */
#define NUMSECS    9
#define NUMBYTES 512
#define SECSIZE    2 /* for format track, 0=128, 1=256, 2=512, 3=1024 */
#define NUMTRACKS 40
#define NUMHEADS   2

typedef char TRACKBUFFER[NUMSECS*NUMBYTES];
typedef TRACKBUFFER *BUFPTR;

BUFPTR data[NUMTRACKS][NUMHEADS]; /* an array of pointers to TRACKBUFFER */

int recaldisk(int drive)  /* force a recalibration of the disk heads */
    /* NOTE: This function has not been fully tested! */
    {
    int success = 0;
    char scratch[1024];

    success = (biosdisk(DISKRESET,0,0,0,0,0,scratch)==0);
    success = (biosdisk(DISKREAD,drive,0,0,1,1,scratch)==0);
    }

int readtrack(int drive, int track, int head, BUFPTR data)
    {
    int ct, success = 0;

    for (ct = 0; (ct++ < 3) && (!success); )
        success = (biosdisk(DISKREAD,drive,head,track,1,NUMSECS,data)==0);
    return (success);
    }

int writetrack(int drive, int track, int head, BUFPTR data)
    {
    int ct, success = 0;

    for (ct = 0; (ct++ < 3) && (!success); )
        success = (biosdisk(DISKWRITE,drive,head,track,1,NUMSECS,data)==0);
    return (success);
    }

int formattrack(int drive, int track, int head)
    {
    int *tptr;  /* NOTE: tptr is VERY DEPENDENT on sizeof(int) being 2*sizeof(char) */
    int    ct;  /*       as well as low order byte being at lower address */
    int success = 0;
    static char formatinfo[NUMSECS][4] = { {0,0,1,SECSIZE},
                          {0,0,2,SECSIZE}, {0,0,3,SECSIZE},
                          {0,0,4,SECSIZE}, {0,0,5,SECSIZE},
                          {0,0,6,SECSIZE}, {0,0,7,SECSIZE},
                          {0,0,8,SECSIZE}, {0,0,9,SECSIZE} };

    tptr = (int *) formatinfo;
    for (ct = 0; ct++ < NUMSECS; )
        {
        *tptr = track | (head << 8);
        tptr += 2;
        }

    for (ct = 0; (ct++ < 3) && (!success); )
        {
        success = (biosdisk(DISKFORMAT,drive,head,track,0,NUMSECS,formatinfo)==0);
        success = success && (biosdisk(DISKVERIFY,drive,head,track,1,NUMSECS,0)==0);
        }
    return (success);
    }

void allocbuf(void)  /* allocate memory for all the pointers in "data" */
    /* you MUST call this function before calling readdisk or writedisk! */
    {
    int track, head;
    int success = TRUE;

    for (track = 0; (track < NUMTRACKS) && (success); track++)
        {
        for (head = 0; (head < NUMHEADS) && (success); head++)
            {
            if ((data[track][head] = (BUFPTR) calloc(NUMSECS,NUMBYTES)) == NULL)
                {
                puts("Not Enough Memory.");
                success = FALSE;
                }
            }
        }
    }

void readdisk(int drive)
    {
    int track, head;
    int success = TRUE;
    
    for (track = 0; (track < NUMTRACKS) && (success); track++)
        for (head = 0; (head < NUMHEADS) && (success); head++)
            success = readtrack(drive,track,head,data[track][head]);
    }

void writedisk (int drive)
    {
    int track, head;
    int success = TRUE;

    recaldisk(drive);
    for (track = 0; (track < NUMTRACKS) && (success); track++)
        {
        for (head = 0; (head < NUMHEADS) && (success); head++)
            {
            success = formattrack(drive,track,head);
            success = success && writetrack(drive,track,head,data[track][head]);
            }
        }
    }

/* an example program to copy a disk from A to B:

    allocbuf();
    readdisk(0);
    writedisk(1);
*/
