;SWAPDISK.ASM
;
;	swap drive assignment to, for example, route all drive B requests to C
;   this program only operates upon floppy drives!!!!!!
;
;   Laine Stump, January 1988, No Rights Reserved
;***************************************************************************
	INCLUDE		MSDOS.MAC	;macro definitions & other constants
;
CODE	segment 'CODE'
	assume	cs:code
FIRSTBYTE	equ	this byte	;between here & LASTBYTE remains res.

	ORG	100h
START:	JMP	INIT		;init code is at end so we can get rid of it.

INT13h	equ	this dword
    INT13Ofs	DW	?
    INT13Seg	DW	?

TABLE	DB	0,1,2,3		;table of drive translations
KEY	DW	'SD'

INTSERV	PROC	FAR
	CMP	AH,0FEh		;our own private code
	JNE	INTSERV2

	CMP     DL,3
	JA	INTRET
	CMP	DH,3
	JA	INTRET
	  PUSH	  BX
	  MOV	  BL,DL
	  MOV	  BH,0
	  MOV	  TABLE[BX],DH
	  POP	  BX
INTRET:	IRET

INTSERV2:
	CMP	DL,3
	JBE	INTSERVSWAP
    JMP    INT13h

INTSERVSWAP:
	  PUSH	  DX
	  PUSH	  BX
	  MOV	  BL,DL
	  MOV	  BH,0
	  MOV	  DL,TABLE[BX]
	  POP	  BX
	  PUSHF
	  CALL	  INT13h
	  POP	  DX
	  RET	2
INTSERV	  ENDP

LASTBYTE	equ	this byte

;************************************************************************
;
;	Below this point only used during initialization, then discarded
;
	assume	ds:code

FIRSTTIME	DB	0

ERR	DB	'proper syntax is: SWAPDISK dn where d is a-d and n is 0-3'
ERRLEN	equ	75-18

FIRST	DB	'installing SWAPDISK'
FIRSTLEN	equ	37-18

INIT:
	MOV	AL,13h			;get the original INT 13h vector
	DOS	GetVector

	CMP	word ptr ES:[BX-2],'SD'	;if already installed
	JE	ACTION			;go do the action

	MOV	FIRSTTIME,0FFh
	MOV	INT13Ofs,BX		;else install the new vector
	MOV	INT13Seg,ES

	MOV	AL,13h
	MOV	DX,offset INTSERV
	DOS	SetVector

ACTION:	MOV	BX,80h
	CMP	byte ptr CS:[BX],0
	JE	DONE

ACTION1:INC	BX
	CMP	byte ptr CS:[BX],' '
	JE	ACTION1
	MOV	DX,word ptr CS:[BX]	;DL=logical, DH=physical
	AND	DL,5Fh			;make drive letter uppercase
	SUB	DL,'A'			;DL is A - D
	SUB	DH,'0'			;DH is 0 - 3

	CMP	DL,3
	JA	ACTIONERROR
	CMP	DH,3
	JA	ACTIONERROR

	MOV	AH,0FEh			;call new extended INT 13 service
	INT	13h
	JMP	DONE

ACTIONERROR:
	MOV	BX,stdout
	MOV	CX,ERRLEN
	MOV	DX,offset ERR
	DOS	WriteHandle


DONE:	CMP	FIRSTTIME,0
	JNE	FIRSTEXIT

	DOS	EndF

FIRSTEXIT:
	MOV	BX,stdout
	MOV	CX,FIRSTLEN
	MOV	DX,offset FIRST
	DOS	WriteHandle

	MOV     DX,(LASTBYTE-FIRSTBYTE+15)/16
	MOV	AL,0
	DOS	TerminateKeep

CODE	ends
	end     START
