Static Function GetToken (sV As Variant, sDelimeter As String, nContinue As Integer) As Variant
    ' sV is the text string to parse
    ' sDelimeter is the token delimiter
    ' nContinue is a switch
    '    nContinue = 0,  initialize static variables, get 1st token
    '    nContinue = -1, continue with Static Values, get next token
    ' GetToken returns #NULL# when done
    ' =====   Marty Wolfson  CIS 73354,252   =====

    Dim n1 As Integer, n2 As Integer, nDeliLen As Integer

    Select Case nContinue
        Case -1     ' continue with static variables
            If n2 = 0 Then
                GetToken = Null
            Else
                n2 = InStr(n1 + nDeliLen, sV, sDelimeter)
                If n2 > 0 Then
                    GetToken = Mid(sV, n1 + nDeliLen, n2 - n1 - nDeliLen)
                Else
                    GetToken = Mid(sV, n1 + nDeliLen)
                End If
                n1 = n2
            End If
        Case 0      ' initialize static vars, get 1st token
            If sV > "" Then
                nDeliLen = Len(sDelimeter)
                n2 = InStr(1, sV, sDelimeter)
                n1 = n2
                If n2 > 0 Then
                    GetToken = Left(sV, n2 - 1)
                Else
                    GetToken = sV
                End If
            Else
                GetToken = Null
            End If
    End Select

End Function
