VERSION 2.00
Begin Form frmDDEDemo 
   BackColor       =   &H00FFFFFF&
   Caption         =   "WinPLOT DDE Demo"
   ClientHeight    =   3030
   ClientLeft      =   690
   ClientTop       =   5760
   ClientWidth     =   6315
   Height          =   3435
   Left            =   630
   ScaleHeight     =   3030
   ScaleWidth      =   6315
   Top             =   5415
   Width           =   6435
   Begin HScrollBar hsbSpeed 
      Height          =   255
      Left            =   3840
      Max             =   50
      Min             =   1
      TabIndex        =   9
      Top             =   120
      Value           =   1
      Width           =   915
   End
   Begin CommandButton cmdNext 
      Caption         =   " >"
      Height          =   315
      Left            =   1620
      TabIndex        =   7
      Top             =   60
      Width           =   315
   End
   Begin Frame Frame2 
      Caption         =   "Commands (no data)"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   1635
      Left            =   3420
      TabIndex        =   5
      Top             =   1320
      Width           =   2835
      Begin TextBox txtCmd 
         BorderStyle     =   0  'None
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "Courier New"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   1335
         Left            =   60
         MultiLine       =   -1  'True
         TabIndex        =   6
         Top             =   240
         Width           =   2715
      End
   End
   Begin Frame Frame1 
      BackColor       =   &H00FFFFFF&
      Caption         =   "Data file (commands && data)"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00000000&
      Height          =   1635
      Left            =   60
      TabIndex        =   3
      Top             =   1320
      Width           =   3255
      Begin TextBox txtData 
         BorderStyle     =   0  'None
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "Courier New"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   1335
         Left            =   60
         MultiLine       =   -1  'True
         TabIndex        =   4
         Top             =   240
         Width           =   3135
      End
   End
   Begin CheckBox chkPause 
      Caption         =   "Pause"
      Height          =   195
      Left            =   2700
      TabIndex        =   2
      Top             =   120
      Width           =   915
   End
   Begin Timer Timer1 
      Left            =   5820
      Top             =   0
   End
   Begin CommandButton cmdDemo 
      Caption         =   "Start Demo"
      Height          =   315
      Left            =   60
      TabIndex        =   0
      Top             =   60
      Width           =   1395
   End
   Begin Label Label2 
      Caption         =   "Speed"
      Height          =   195
      Left            =   4800
      TabIndex        =   10
      Top             =   120
      Width           =   615
   End
   Begin Label Label1 
      Caption         =   "Next"
      Height          =   255
      Left            =   1980
      TabIndex        =   8
      Top             =   120
      Width           =   555
   End
   Begin Label lblDemoStatus 
      BackColor       =   &H00FFFFFF&
      Height          =   795
      Left            =   60
      TabIndex        =   1
      Top             =   480
      Width           =   6135
   End
End
Option Explicit             ' use only defined vars only

Const w = 6.283185307       ' w=2*pi
Const NONE = 0              ' No DDE
Const MANUAL = 2            ' Manual DDE link
Const AUTOMATIC = 1         ' Automatic DDE Link
Const WHITE = &HFFFFFF      ' non selected background color
Const GREEN = &H808000      ' selected background color

Dim crlf As String * 2      ' hold the crlfLF string combo

Dim nsamp As Integer        ' total number of samples
Dim fs  As Single           ' sample frequency (Hz)
Dim start As Integer        ' app startup flag
Dim n As Integer            ' current sample # index
Dim t As Single             ' current time of sample
Dim x As Single
Dim y1 As Single
Dim y2 As Single

Dim cmd$                    ' used to build data
Dim con$                    ' used as DDE connection name

'   Used to build up a command string
'
Sub AddCommand (t$)
    cmd = cmd + t$ + crlf
End Sub

'    used to pause demo if checked
'
Sub chkPause_Click ()
End Sub

'   Main program loop - Once pressed the demo just loops
'
'   All demo link and command code is contained here
'
'   Basic mode of operation:
'       1) Establish link                           (LinkTopic\Item\Mode)
'       2) Send data file with necessary header     (LinkPoke)
'       3) Send control commands                    (LinkExecute)
'
'
Sub cmdDemo_Click ()
  Do
    lblDemoStatus = ""
    DemoStatus "Welcome to the WinPLOT Demo using DDE control"
    DemoStatus "Start WinPLOT for DDE if necessary"
    start = True                                ' signal that you are starting a new instance of WinPLOT
    con$ = "DemoScreen1"                               ' link connection instance name
    On Error GoTo StartApp                      ' if connection failure then attempt to start
    txtData.LinkMode = NONE
    txtData.LinkTopic = "WinPLOT|" + con$       ' the connection string must be unique to this instance
    txtData.LinkItem = "DDEData"                ' the actual name of the item in WinPLOT that accepts the data
    txtData.LinkMode = MANUAL                   ' all operations will be manually issued
    
' ----------------------------------------------------------------------------------------
    DemoStatus "Generate a Sinc function data file and set all the default items."
    DemoStatus "Then send the file off to WinPLOT to draw"
    nsamp = 128      ' number of samples
    fs = 80          ' sample frequency Hz
    cmd = ""
    AddCommand "DATASET=Demo"                       ' build the data header - all of the look and feel keywords are used here
    AddCommand "SIGNAL=Sin(X)/X"
    AddCommand "SAMPLE=X,sec.," + Str$(nsamp)
    AddCommand "INTERVAL=" + Str$(1 / fs)           ' Note: This is a automatic X
    AddCommand "DISPLAY=0,0,500,300"
    AddCommand "PLOT_TYPE=rect,axis,grid,legend"
    AddCommand "SYMB_COLOR=blue,red"
    AddCommand "SYMB_POINT=square,circle"
    AddCommand "SYMB_LINE=solid,solid"
    AddCommand "SET_X"                              ' shut off LOGs
    AddCommand "SET_Y"
    AddCommand "DATA"
    t = -nsamp / 2 / fs
    For n = 1 To nsamp                              ' build the data
        t = t + 1 / fs
        cmd = cmd + Str$(Sin(3 * w * t) / (3 * w * t)) + crlf   ' sinc function
    Next n
    txtCmd.BackColor = WHITE                        '
    txtData.BackColor = GREEN                       ' show data as active window
    txtData = cmd
    txtData.LinkPoke                                ' send off data & header
    DoEvents
    Call subDelay(15)                               ' wait
' ----------------------------------------------------------------------------------------
    lblDemoStatus = ""
    DemoStatus "WinPLOT also supports Polar plots ..."
    DemoStatus "Note the Keyword commands that are used."
    DemoStatus "The ACTIVE and AUTO are off to aviod unnecessary actions."
    cmd = ""
    AddCommand "ACTIVE=off"
    AddCommand "AUTO=off"
    AddCommand "PLOT_TYPE=polar"
    AddCommand "SET_X=-.1,1"
    AddCommand "SET_Y=-.1,1"
    AddCommand "DATASET=Polar"
    AddCommand "REDRAW"
    txtData.BackColor = WHITE
    txtCmd.BackColor = GREEN
    txtCmd = cmd
    txtData.LinkExecute txtCmd                      ' Note LinkExecute is for commands
    Call subDelay(15)
' ----------------------------------------------------------------------------------------
    lblDemoStatus = ""
    DemoStatus "WinPLOT can also preform some data transformations"
    DemoStatus "Here is the frequency spectrum of the Sinc functions"
    DemoStatus "Note the Y axis is LOG scale and the X-axis is Hz "
    
    cmd = ""
    AddCommand "OPERATION=spec"
    AddCommand "DATASET=Spectrum"
    AddCommand "PLOT_TYPE=rect"
    AddCommand "RESCALE"               ' force rescale on X
    AddCommand "SET_Y=.001,100,log"    ' force log-Y
    AddCommand "REDRAW"
    txtCmd = cmd
    txtData.LinkExecute txtCmd
    Call subDelay(15)
' ----------------------------------------------------------------------------------------
    lblDemoStatus = ""
    DemoStatus "WinPLOT can handle can handle a number of signals"
    cmd = ""
    nsamp = 64
    fs = nsamp / (4 * w)
    AddCommand "DATASET=Multi Signal Interactive"
    AddCommand "SIGNAL=Sin(X)/X,diff(Y1)"
    AddCommand "SET_Y"
    AddCommand "AUTO=on"   ' for next markers ??
    AddCommand "ACTIVE=on"
    AddCommand "DATA"
    t = -nsamp / 2 / fs
    For n = 1 To nsamp
        t = t + 1 / fs                             ' t=1/f
        y1 = Sin(t) / t                            ' sinc(t)
        y2 = y1 - Sin(t - 1 / fs) / (t - 1 / fs)   ' diff(sinc(t))
        cmd = cmd + Str$(t) + "," + Str$(y1) + "," + Str$(y2) + crlf    ' output signal
    Next n
    txtCmd.BackColor = WHITE
    txtData.BackColor = GREEN
    txtCmd = ""                                     ' just to show that the command window is not being used
    txtData = cmd
    txtData.LinkPoke
    Call subDelay(5)
    
' ----------------------------------------------------------------------------------------
    DemoStatus "Interactive operation is via mouse or keyboard"
    DemoStatus "Note the X & Y values being displayed"
    cmd = ""
    AddCommand "ACTIVE=on"
    AddCommand "AUTO=off"
    AddCommand "MARKER=25,1"
    txtData.BackColor = WHITE
    txtCmd.BackColor = GREEN
    txtCmd = cmd
    txtData.LinkExecute txtCmd
    Call subDelay(1)
    
    For n = 1 To 10
        cmd = ""
        AddCommand "MARKER=" + Str$(25 + n) + ",1"
        txtCmd = cmd
        txtData.LinkExecute txtCmd
        Call subDelay(.3)
    Next n
    DemoStatus "Now lets switch to signal #2"
    Call subDelay(1)
    For n = 1 To 10
        cmd = ""
        AddCommand "MARKER=" + Str$(35 - n) + ",2"
        txtCmd = cmd
        txtData.LinkExecute txtCmd
        Call subDelay(.3)
    Next n
    Call subDelay(2)
' ----------------------------------------------------------------------------------------
    lblDemoStatus = ""
    DemoStatus "We can Zoom In"
    cmd = ""
    AddCommand "SET_X=-5,0.5"
    AddCommand "SET_Y=-.3,.55"
    AddCommand "REDRAW"
    txtCmd = cmd
    txtData.LinkExecute txtCmd
    Call subDelay(5)
    
    DemoStatus "Remove the Axis and Legend"
    cmd = ""
    AddCommand "PLOT_TYPE=rect,noaxis,,nolegend"
    AddCommand "REDRAW"
    txtData.BackColor = WHITE
    txtCmd.BackColor = GREEN
    txtCmd = cmd
    txtData.LinkExecute txtCmd                      ' Note LinkExecute is for commands
    Call subDelay(5)
    
    DemoStatus "Change Signal colors and types "
    DemoStatus "and change the size of the window "
    cmd = ""
    AddCommand "SYMB_COLOR=green, purple"
    AddCommand "SYMB_LINE=dash, none"
    AddCommand "DISPLAY=0,0,400,1"
    AddCommand "REDRAW"
    txtCmd = cmd
    txtData.LinkExecute txtCmd
    Call subDelay(10)

' ------------------------------- Dual WinPLOT demo  ------------------------------------------------
    lblDemoStatus = ""
    DemoStatus "For a multi window demo lets mix two sin functions"
    nsamp = 128      ' number of samples
    fs = 40          ' sample frequency Hz
    cmd = ""
    AddCommand "INTERVAL=" + Str$(1 / fs)           ' Note: This is a automatic X
    AddCommand "PLOT_TYPE=rect,axis,grid,nolegend"
    AddCommand "SYMB_COLOR=red"
    AddCommand "SYMB_POINT=triangle"
    AddCommand "SYMB_LINE=solid,solid"
    AddCommand "AUTO=on"
    AddCommand "DATA"
    t = 0
    For n = 1 To nsamp                              ' build the data
        t = t + 1 / fs
        cmd = cmd + Str$(Sin(5 * w * t) + Sin(8 * w * t)) + crlf   ' ' output mixed sine wave - Y data
    Next n
    txtCmd.BackColor = WHITE                        '
    txtData.BackColor = GREEN                       ' show data as active window
    DemoStatus "Send it to the first window"
    txtData = "DATASET=Time Domain" + crlf + cmd
    txtData.LinkPoke                                ' send off data & header
    DoEvents
    Call subDelay(5)                               ' wait

    DemoStatus "Start a second window and calculate the spectrum"
    txtData = "DATASET=Frequency Domain" + crlf + "OPERATION=spectrum" + crlf + cmd
    con$ = "DemoScreen2"                  ' connect to second instance
    start = True
    txtData.LinkMode = NONE
    txtData.LinkTopic = "WinPLOT|" + con$
    txtData.LinkItem = "DDEData"
    txtData.LinkMode = MANUAL
    txtData.LinkPoke
    DoEvents
    Call subDelay(4)                               ' wait
    
    DemoStatus "And position it below first and change to histogram"
    cmd = ""
    AddCommand "DISPLAY=0,152,400,1"
    AddCommand "PLOT_TYPE=histogram"
    AddCommand "SYMB_COLOR=purple"
    txtData.BackColor = WHITE
    txtCmd.BackColor = GREEN
    txtCmd = cmd
    txtData.LinkExecute txtCmd
    Call subDelay(15)

' ----------------------------------------------------------------------------------------
    lblDemoStatus = ""
    DemoStatus "These are just some of the features available in WinPLOT"
    DemoStatus "This VB DDE Demo program is provided in the file 'DDE_DEMO.FRM'"
    DemoStatus "See the on-line help for details. "
    Call subDelay(20)
    
    DemoStatus "Now close this window"
    cmd = ""
    AddCommand "AUTO=off"
    AddCommand "EXIT"           ' this will cause this instance of WinPLOT to terminate
    txtCmd = cmd
    txtData.LinkExecute txtCmd
    Call subDelay(.1)
    
    txtCmd.BackColor = WHITE
    txtData.BackColor = GREEN
    txtCmd = ""
  Loop

'       if WinPLOT has is not running then an error is generated
'       note that with app.path DDE_DEMO must be in the same directory as WinPLOT
StartApp:
    If start = True Then start = Shell(app.Path + "\WINPLOT.EXE '" + con$ + "'", 1) ' shell only once if start is true to avoid instance errors
    DoEvents                        ' give the system time to do something
    If Err = 293 Then
        Resume Next   ' if DDE lost connection then must have Exited
    Else
        Resume        ' other faliure then keep going until success
    End If
End Sub

'   used to bypass the delay function
'
Sub cmdNext_Click ()
    cmdNext.Tag = "Clicked" ' used to tell the timmer fuction to continue
End Sub

'   This sub is used to display the Demo Text Display
'
Sub DemoStatus (t$)
    lblDemoStatus = lblDemoStatus + t$ + crlf
    DoEvents            ' allow to be displayed when busy
End Sub

'   This is a VB program which Demonstrates the use of Dynamic Data Exchange to Control WinPLOT.
'   See the on-line help for full details on the available commands
'
'   The demo will highlight the box that is controlling
'
'   You can pause this demo and issue your own data & commands by typing in the boxes and then double ckicking on the box
'
'   NOTE: This program will not work with a unregistered copy of WinPLOT.
'         The Link Topic of an unregistered copy is set to a hidden predetermined name.
'         The compiled demo program (DDE_DEMO.EXE) will work because it was compiled with this special name.
'
'   >> Program starts here
'
Sub Form_Load ()
    frmDDEDemo.Top = 360 * 15   ' position form  in bottom left corner
    frmDDEDemo.Left = 0
    crlf = Chr$(13) + Chr$(10)  ' carrage return & line feed characters
    hsbSpeed.Value = 5          ' set default Demo speed
End Sub

Sub Form_Unload (Cancel As Integer)
    End
End Sub

'    used for demo speed control
'
Sub hsbSpeed_Change ()
End Sub

'   This sub is used as a general delay
'   It works in conjunction with the Next, Pause and Delay controls
'
Sub subDelay (d As Single)
    timer1.Interval = d * 1000 * 5 / hsbSpeed.Value ' delay in seconds adjusted
    timer1.Tag = ""                                 ' clear the timer flag
    timer1.Enabled = True                           ' start the timer
    While (timer1.Tag = "" Or chkPause = 1) And cmdNext.Tag = ""
        ' wait until any of the above occurs
        DoEvents
    Wend
    cmdNext.Tag = ""
    timer1.Enabled = False
End Sub

'   Timer object used for delay function
'
Sub Timer1_Timer ()
    timer1.Tag = "Done" ' When the timer is done
End Sub

Sub txtCmd_DblClick ()
'    On Error GoTo ErrHand
    txtData.LinkExecute txtCmd
'    Exit Sub
'ErrHand:
'    Resume Next    ' for End command

End Sub

Sub txtData_DblClick ()
'    On Error GoTo PokeError
    txtData.LinkPoke
'    Exit Sub
'PokeError:
'    DoEvents
    
'    Resume

End Sub

