'            Example of how to write a new module (BASIC procedure)
'            ------------------------------------------------------


'            In BASIC, comments are preceded by a  '


SUB ModuleGaussFilter ()  ' The RADIOSIM modules are BASIC procedures
                          ' without any argument
DEFINT I-K, N
DEFDBL A-H, L-M, O-Y
DEFSTR Z

' --------------------- Beginning of the interactive part --------------
'
' see explanations in User's guide, section 6.1, and also 6.3.29 and 6.3.22
'
B = VAL(Z(1))
Noise$ = Z(2)
SELECT CASE Key$

CASE "BEGIN"
   ModuleName$ = "Gaussian filter"    ' name appearing in screen #2
                                      ' and in the .CAN file
   NbParam = 2
Z(1) = "3 dB RF bandwidth                           1010CH+0UF"
Z(2) = "Filter included in noise BW   (y/n)          N 1YYNN  "
EXIT SUB

CASE "EXCEPT"
'     Here are written the entering interdictions specific to this module;
'     this one has no interdictions.
'     For example, if
'                 IF B>10 THEN Ok$= "N"
'     would be written here, it would be prohibited to enter a bandwith
'     larger than  10 MHz
EXIT SUB

CASE "HELP"
Center "Gaussian filter"  ' procedure Center: see User's guide, section 6.3.6
Pn "Transfer fonction in EXP(- g F^2)"
Pn "Impulse response is also gaussian, in EXP(-(t)^2/g)"
' procedure Pn: see User's guide, section 6.3.33
EXIT SUB

END SELECT

' ---------------------- End of the interactive part ------------------

PRINT "Gaussian filter"
IF Noise$ <> "N" THEN NBw 0, 0, 0, "O"   ' opening file NBW by procedure Nbw
                                         ' see User's guide, section 6.3.27
IF Domain$ = "T" THEN Fft A(), B()       ' going to frequency domain
PRINT "3 dB RF bandwidth = ";
PRINT USING "#####.###"; B;
PRINT " "; Uf$
B = B * Uf / 2                           ' 3 dB bandwidth in baseband
G = LOG(2) / 2 / B / B
NBw 0, 1, 0, ""
FOR I = 1 TO N / 2 - 1
   F = I * dF
   A = EXP(-G * F * F)
   A(I) = A(I) * A
   B(I) = B(I) * A
   A(N - I) = A(N - I) * A
   B(N - I) = B(N - I) * A
   NBw I, A, 0, ""             ' characteristics of this filter are included
   NBw N - I, A, 0, ""         ' in the equivalent noise bandwidth, and
                               ' written in arrays Pre() and Pim().
NEXT I
A(N / 2) = 0  ' by principle, the signal is nulled at N/2. This has no effect
B(N / 2) = 0  ' if N and Ns are conveniently dimensionned (no spectrum folding).

NBw N / 2, 0, 0, ""
IF Noise$ <> "N" THEN NBw 0, 0, 0, "C"   ' file NBW is closed

END SUB

