10 REM*******************************************************************
20 REM*****  Heat Loss Calculations                                 *****
30 REM*****  Based on:                                              *****
40 REM*****     Jackson, David R., John M. Callahan                 *****
50 REM*****      Energy Conservation with a Microcomputer           *****
60 REM*****      BYTE, June 1981, pp. 178-208                       *****
70 REM*****  Programmed by:                                         *****
80 REM*****     David Hopper                                        *****
90 REM*****     SENES Consultants Ltd.                              *****
100 REM*****     499 McNicoll Ave.                                   *****
110 REM*****     Willowdale, Ontario                                 *****
120 REM*****     M2H 2C9                                             *****
130 REM*****     (416) 499-5030                                      *****
140 REM*****                                                         *****
150 REM*****    Data Definition                                      *****
160 REM*****                                                         *****
170 REM*******************************************************************
180 DIM S$(25)            :REM SURFACE NAMES
190 DIM A(25)             :REM SURFACE AREA
200 DIM R(25)             :REM SURFACE R-VALUE
210 DIM UA(25)            :REM SURFACE UA'S
220 DIM WA(25)           :REM SURFACE WATTAGE HEAT LOSS
230 T$=""                :REM TITLE
240 AC=0                 :REM INFILTRATION RATE
250 VI=0                 :REM FORCED VENTILATION
260 RT=0                 :REM RUN TIME OF FANS
270 DD(1)=0              :REM HEATING DEGREE DAYS
280 DD(2)=0              :REM COLLING DEGREE DAYS
290 V=0                  :REM BUILDING VOLUME
300 SU=0                 :REM UA ACCUMULATOR
310 SW=0                 :REM WA ACCUMULATOR
320 WI=0                 :REM INFILTRATION WATTAGE
330 REM*******************************************************************
340 REM*****  INPUT SECTION  *********************************************
350 REM*******************************************************************
360 CLS:KEY OFF
370 PRINT :PRINT
380 PRINT "   SENES BUILDING ENERGY LOAD MODEL"
390 PRINT "   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
400 PRINT :PRINT
410 INPUT " Title of the output                ";T$
420 INPUT " Air infiltration rate(AC/HR)       ";AC
430 INPUT " Installed fan capacity(CFM)        ";VI
440 INPUT " On time of fans(MIN/DAY)           ";RT
450 INPUT " Total # of heating degree days     ";DD(1)
460 INPUT " Total # of cooling degree days     ";DD(2)
470 INPUT " Outdoor design temperature(DEG F)  ";JI
480 INPUT " Indoor design temperature (DEG F)  ";JT
490 INPUT " Building volume (FT^3)             ";V
500 INPUT " Enter the # of building elements   ";N
510 PRINT
520 DT=JT-JI
530 FOR I=1 TO N
540  INPUT " Surface name       ";S$(I)
550  INPUT " Surface area(FT^2) ";A(I)
560  INPUT " Surface R-Value    ";R(I)
570 PRINT
580 REM***********************************************************************
590 REM******  Calculate UA's,WA's and conduction loads    *******************
600 REM***********************************************************************
610 UA(I)=(1/R(I))*A(I)
620 SU=SU+UA(I)
630 WA(I)=UA(I)*DT*.29299/1000
640 SW=SW+WA(I)
650 NEXT I
660 REM***********************************************************************
670 REM*****  Calculational section  *****************************************
680 REM***********************************************************************
690 IL=.24*.074*V*AC
700 VI=VI*RT/24
710 VL=.24*.074*VI
720 IN=IL+VL
730 TL=SU+IN
740 WI=IN*DT*.29299/1000
750 HL=(SU+IN)*24*DD(1)/10^6
760 CL=(SU+IN)*24*DD(2)/10^6
770 REM***********************************************************************
780 REM***** SCREEN output section  ******************************************
790 REM***********************************************************************
800 CLS:KEY OFF
810 PRINT :PRINT :PRINT
820 PRINT TAB(10) "Conduction and Ventilation Loads"
830 PRINT TAB(10) "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
840 PRINT :PRINT
850 PRINT TAB(10) ;T$
860 LT=LEN(T$)
870 TU$=STRING$(LT,126)
880 PRINT TAB(10) ;TU$
890 PRINT TAB(15) " Conduction Load Table"
900 PRINT TAB(15) " ~~~~~~~~~~~~~~~~~~~~~"
910 PRINT :PRINT
920 PRINT "|~~~~~~~~~~~~~~~~|~~~~~~~~~~~|~~~~~~~~~~~~|~~~~~~~~~~~~~~|~~~~~~~~~~|~~~~~~~~|"
930 PRINT "|    SURFACE     |   AREA    |     R      |     UA       |   LOAD   | WA(JAN)|"
940 PRINT "|     NAME       |  (FT^2)   |            |BTU/HR DEG F  |   (%)    |  (KW)  |"
950 PRINT "|~~~~~~~~~~~~~~~~|~~~~~~~~~~~|~~~~~~~~~~~~|~~~~~~~~~~~~~~|~~~~~~~~~~|~~~~~~~~|"
960 FOR I=1 TO N
970 PRINT "|";
980 PRINT USING " \           \  ";S$(I);
990 PRINT USING "|#######.## ";A(I);R(I);
1000 PRINT USING " | #######.##   |";UA(I);
1010 PRINT USING "  ###.##  |";UA(I)/TL*100;
1020 PRINT USING "  ##.###|";WA(I)
1030 NEXT I
1040 PRINT "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
1050 PRINT :PRINT
1060 PRINT TAB(15)" Ventilation Table"
1070 PRINT TAB(15)" ~~~~~~~~~~~~~~~~~"
1080 PRINT :PRINT
1090 PRINT "|~~~~~~~~~~~~~~~~|~~~~~~~|~~~~~~~~~~~~|~~~~~~~~~~~~~~~~|~~~~~~~~~|"
1100 PRINT "|     AIR        |AC RATE|  VENT RATE |  ENERGY LOAD   |  LOAD   |"
1110 PRINT "|   SOURCE       | AC/HR |  FT^3/HR   |  BTU/HR DEG F  |  (%)    |"
1120 PRINT "|~~~~~~~~~~~~~~~~|~~~~~~~|~~~~~~~~~~~~|~~~~~~~~~~~~~~~~|~~~~~~~~~|"
1130 PRINT "| Infiltration   |";
1140 PRINT USING " ###.##|";AC;
1150 PRINT USING " #######.## |";AC*V;
1160 PRINT USING "    #####.###   |";IL;
1170 PRINT USING "  ###.## |";IL/TL*100
1180 PRINT "|  Ventilation   |";
1190 PRINT USING " ###.##|";VI/V;
1200 PRINT USING " #######.## |";VI;
1210 PRINT USING "    #####.###   |";VL;
1220 PRINT USING "  ###.## |";VL/TL*100
1230 PRINT "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
1240 PRINT :PRINT
1250 PRINT " Yearly heating requirements for ";DD(1);" Heating degree days"
1260 PRINT USING " ###.## Million BTU ";HL
1270 PRINT :PRINT
1280 PRINT " Installed heater capacity for "
1290 PRINT USING " an outdoor design temperature of ### deg F";JI
1300 PRINT USING " and indoor design temperature of ### deg F";JT
1310 PRINT USING " neglecting infiltration should be ###.## KW";SW
1320 PRINT :PRINT
1330 PRINT " Total installed heater capacity for "
1340 PRINT USING " an outdoor design temperature of ### deg F";JI
1350 PRINT USING " and indoor design temperature of ### deg F";JT
1360 PRINT USING " including infiltration should be ###.## KW";SW+WI
1370 PRINT :PRINT
1380 PRINT " Yearly cooling requirements for ";DD(2);" Cooling degree days"
1390 PRINT USING " ###.## Million BTU ";CL
1400 PRINT :PRINT :PRINT
1410 PRINT "  Do you wish to print out these results(P)"
1420 INPUT "   or correct the input data(C)            ";Q$
1430 IF Q$="" THEN BEEP:GOTO 1410
1440 QQ=INSTR("PC",Q$):IF QQ=0 THEN BEEP:GOTO 1410
1450 ON QQ GOTO 1480,180
1460 REM***********************************************************************
1470 REM*****  printer output section  ****************************************
1480 REM***********************************************************************
1490 PRINT "  IS THE PRINTER TURNED ON ???"
1500 PRINT "  ############################"
1510 PRINT "  Press any KEY to continue"
1520 X$=INKEY$: IF X$="" THEN 1520
1530 LPRINT CHR$(15):WIDTH "LPT1:",132
1540 LPRINT "   SENES BUILDING ENERGY LOAD MODEL "
1550 LPRINT "   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
1560 LPRINT :LPRINT
1570 LPRINT TAB(10) "Conduction and Ventilation Loads"
1580 LPRINT TAB(10) "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
1590 LPRINT :LPRINT :LPRINT
1600 LPRINT TAB(10) ;T$
1610 LT=LEN(T$)
1620 TU$=STRING$(LT,126)
1630 LPRINT TAB(10) ;TU$
1640 LPRINT TAB(15) " Conduction Load Table"
1650 LPRINT TAB(15) " ~~~~~~~~~~~~~~~~~~~~~"
1660 LPRINT :LPRINT
1670 LPRINT "|~~~~~~~~~~~~~~~~|~~~~~~~~~~~|~~~~~~~~~~~~|~~~~~~~~~~~~~~|~~~~~~~~~~|~~~~~~~~|"
1680 LPRINT "|    SURFACE     |   AREA    |     R      |     UA       |   LOAD   | WA(JAN)|"
1690 LPRINT "|     NAME       |  (FT^2)   |            |BTU/HR DEG F  |   (%)    |  (KW)  |"
1700  LPRINT "|~~~~~~~~~~~~~~~~|~~~~~~~~~~~|~~~~~~~~~~~~|~~~~~~~~~~~~~~|~~~~~~~~~~|~~~~~~~~|"
1710 FOR I=1 TO N
1720 LPRINT "|";
1730 LPRINT USING " \           \  ";S$(I);
1740 LPRINT USING "|#######.## ";A(I);R(I);
1750 LPRINT USING " | #######.##   |";UA(I);
1760 LPRINT USING "  ###.##  |";UA(I)/TL*100;
1770 LPRINT USING "  ##.###|";WA(I)
1780 NEXT I
1790 LPRINT "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
1800 LPRINT:LPRINT
1810 LPRINT TAB(15)" Ventilation Table"
1820 LPRINT TAB(15)" ~~~~~~~~~~~~~~~~~"
1830 LPRINT:LPRINT
1840 LPRINT "|~~~~~~~~~~~~~~~~|~~~~~~~|~~~~~~~~~~~~|~~~~~~~~~~~~~~~~|~~~~~~~~~|
1850 LPRINT "|     AIR        |AC RATE|  VENT RATE |  ENERGY LOAD   |  LOAD   |
1860 LPRINT "|   SOURCE       | AC/HR |  FT^3/HR   |  BTU/HR DEG F  |  (%)    |
1870 LPRINT "|~~~~~~~~~~~~~~~~|~~~~~~~|~~~~~~~~~~~~|~~~~~~~~~~~~~~~~|~~~~~~~~~|
1880 LPRINT "| Infiltration   |";
1890 LPRINT USING " ###.##|";AC;
1900 LPRINT USING " #######.## |";AC*V;
1910 LPRINT USING "    #####.###   |";IL;
1920 LPRINT USING "  ###.## |";IL/TL*100
1930 LPRINT "|  Ventilation   |";
1940 LPRINT USING " ###.##|";VI/V;
1950 LPRINT USING " #######.## |";VI;
1960 LPRINT USING "    #####.###   |";VL;
1970 LPRINT USING "  ###.## |";VL/TL*100
1980 LPRINT "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
1990 LPRINT:LPRINT
2000 LPRINT " Yearly heating requirements for ";DD(1);" Heating degree days"
2010 LPRINT USING " ###.## Million BTU ";HL
2020 LPRINT:LPRINT
2030 LPRINT " Installed heater capacity for "
2040 LPRINT USING " an outdoor design temperature of ### deg F";JI
2050 LPRINT USING " and indoor design temperature of ### deg F";JT
2060 LPRINT USING " neglecting infiltration should be ###.## KW";SW
2070 LPRINT:LPRINT
2080 LPRINT " Total installed heater capacity for "
2090 LPRINT USING " an outdoor design temperature of ### deg F";JI
2100 LPRINT USING " and indoor design temperature of ### deg F";JT
2110 LPRINT USING " including infiltration should be ###.## KW";SW+WI
2120 LPRINT :LPRINT
2130 LPRINT " Yearly cooling requirements for ";DD(2);" Cooling degree days"
2140 LPRINT USING " ###.## Million BTU ";CL
2150 KEY ON
2160 LPRINT CHR$(18)
2170 END
