{**********************************************************}
{**      Copyright 1991 Phil Mosier                      **}
{**********************************************************}

Unit ESPIMAGE;

{**********************************************************}
{**                                                      **}
{**      An  unit of images                              **}
{**                                                      **}
{**********************************************************}

Interface
Uses GRAPH, CRT;
Procedure IMAGE_1(LEFT_X_VAL:Integer;TOP_Y_VAL:Integer;SIZE_FACTOR:Real);
Procedure IMAGE_2(LEFT_X_VAL:Integer;TOP_Y_VAL:Integer;SIZE_FACTOR:Real);
Procedure IMAGE_3(LEFT_X_VAL:Integer;TOP_Y_VAL:Integer;SIZE_FACTOR:Real);
Procedure IMAGE_4(LEFT_X_VAL:Integer;TOP_Y_VAL:Integer;SIZE_FACTOR:Real);
Procedure IMAGE_5(LEFT_X_VAL:Integer;TOP_Y_VAL:Integer;SIZE_FACTOR:Real);
Procedure MAKE_MENU;
Procedure SONG;
Procedure PROGRAM_INFO;
Procedure BOXES;

Implementation
Procedure IMAGE_1(lEFT_X_VAL:Integer;TOP_Y_VAL:Integer;SIZE_FACTOR:Real);
{*********************************************************}
{**                                                     **}
{**     Declare Image 1's values    Cleft               **}
{**                                                     **}
{*********************************************************}
Var INDEX : integer;
    IMAGE_1_ARRAY : Array[1..28,1..2]  Of Byte;
    CENTER_X : Integer;
    CENTER_Y : Integer;
Begin
   IMAGE_1_ARRAY[1,1] := 24;
      IMAGE_1_ARRAY[1,2] := 32;
   IMAGE_1_ARRAY[2,1] := 21;
      IMAGE_1_ARRAY[2,2] := 29;
   IMAGE_1_ARRAY[3,1] := 21;
      IMAGE_1_ARRAY[3,2] := 26;
   IMAGE_1_ARRAY[4,1] := 24;
      IMAGE_1_ARRAY[4,2] := 24;
   IMAGE_1_ARRAY[5,1] := 28;
      IMAGE_1_ARRAY[5,2] := 23;
   IMAGE_1_ARRAY[6,1] := 32;
      IMAGE_1_ARRAY[6,2] := 24;
   IMAGE_1_ARRAY[7,1] := 34;
      IMAGE_1_ARRAY[7,2] := 28;
   IMAGE_1_ARRAY[8,1] := 32;
      IMAGE_1_ARRAY[8,2] := 34;
   IMAGE_1_ARRAY[9,1] := 24;
      IMAGE_1_ARRAY[9,2] := 36;
   IMAGE_1_ARRAY[10,1] := 18;
      IMAGE_1_ARRAY[10,2] := 34;
   IMAGE_1_ARRAY[11,1] := 14;
      IMAGE_1_ARRAY[11,2] := 29;
   IMAGE_1_ARRAY[12,1] := 14;
      IMAGE_1_ARRAY[12,2] := 25;
   IMAGE_1_ARRAY[13,1] := 18;
      IMAGE_1_ARRAY[13,2] := 20;
   IMAGE_1_ARRAY[14,1] := 24;
      IMAGE_1_ARRAY[14,2] := 16;
   IMAGE_1_ARRAY[15,1] := 29;
      IMAGE_1_ARRAY[15,2] := 12;
   IMAGE_1_ARRAY[16,1] := 29;
      IMAGE_1_ARRAY[16,2] := 8;
   IMAGE_1_ARRAY[17,1] := 26;
      IMAGE_1_ARRAY[17,2] := 2;
   IMAGE_1_ARRAY[18,1] := 22;
      IMAGE_1_ARRAY[18,2] := 8;
   IMAGE_1_ARRAY[19,1] := 30;
      IMAGE_1_ARRAY[19,2] := 42;
   IMAGE_1_ARRAY[20,1] := 28;
      IMAGE_1_ARRAY[20,2] := 46;
   IMAGE_1_ARRAY[21,1] := 24;
      IMAGE_1_ARRAY[21,2] := 48;
   IMAGE_1_ARRAY[22,1] := 20;
      IMAGE_1_ARRAY[22,2] := 46;
   IMAGE_1_ARRAY[23,1] := 18;
      IMAGE_1_ARRAY[23,2] := 42;
   IMAGE_1_ARRAY[24,1] := 20;
      IMAGE_1_ARRAY[24,2] := 40;
   IMAGE_1_ARRAY[25,1] := 24;
      IMAGE_1_ARRAY[25,2] := 41;
   IMAGE_1_ARRAY[26,1] := 23;
      IMAGE_1_ARRAY[26,2] := 44;
   IMAGE_1_ARRAY[27,1] := 20;
      IMAGE_1_ARRAY[27,2] := 44;
   For INDEX := 1 To 26 Do Begin
      Line((Round(LEFT_X_VAL + (IMAGE_1_ARRAY[INDEX,1] * SIZE_FACTOR))),
          (Round(TOP_y_VAL + (IMAGE_1_ARRAY[INDEX,2] * SIZE_FACTOR))),
          (Round(LEFT_X_VAL + (IMAGE_1_ARRAY[INDEX + 1,1] * SIZE_FACTOR))),
          (Round(TOP_Y_VAL + (IMAGE_1_ARRAY[INDEX + 1,2] * SIZE_FACTOR))));
   End;
   CENTER_X := LEFT_X_VAL + (Round( 20 * SIZE_FACTOR));
   CENTER_Y := TOP_Y_VAL + (Round (42 * SIZE_FACTOR));
   FloodFill(CENTER_X,CENTER_Y,GetMaxColor);

End;
Procedure IMAGE_2(lEFT_X_VAL:Integer;TOP_Y_VAL:Integer;SIZE_FACTOR:Real);
{*********************************************************}
{**                                                     **}
{**     Declare Image 2's values    Heart               **}
{**                                                     **}
{*********************************************************}
Var INDEX : Integer;
    IMAGE_2_ARRAY : Array[1..23,1..2]  Of Byte;
    CENTER_X : Integer;
    CENTER_Y : Integer;
Begin
   IMAGE_2_ARRAY[1,1] := 25;
      IMAGE_2_ARRAY[1,2] := 10;
   IMAGE_2_ARRAY[2,1] := 28;
      IMAGE_2_ARRAY[2,2] := 6;
   IMAGE_2_ARRAY[3,1] := 32;
      IMAGE_2_ARRAY[3,2] := 4;
   IMAGE_2_ARRAY[4,1] := 35;
      IMAGE_2_ARRAY[4,2] := 3;
   IMAGE_2_ARRAY[5,1] := 40;
      IMAGE_2_ARRAY[5,2] := 4;
   IMAGE_2_ARRAY[6,1] := 44;
      IMAGE_2_ARRAY[6,2] := 6;
   IMAGE_2_ARRAY[7,1] := 48;
      IMAGE_2_ARRAY[7,2] := 12;
   IMAGE_2_ARRAY[8,1] := 49;
      IMAGE_2_ARRAY[8,2] := 17;
   IMAGE_2_ARRAY[9,1] := 49;
      IMAGE_2_ARRAY[9,2] := 21;
   IMAGE_2_ARRAY[10,1] := 40;
      IMAGE_2_ARRAY[10,2] := 32;
   IMAGE_2_ARRAY[11,1] := 32;
      IMAGE_2_ARRAY[11,2] := 38;
   IMAGE_2_ARRAY[12,1] := 25;
      IMAGE_2_ARRAY[12,2] := 47;
   IMAGE_2_ARRAY[13,1] := 18;
      IMAGE_2_ARRAY[13,2] := 38;
   IMAGE_2_ARRAY[14,1] := 10;
      IMAGE_2_ARRAY[14,2] := 32;
   IMAGE_2_ARRAY[15,1] := 1;
      IMAGE_2_ARRAY[15,2] := 21;
   IMAGE_2_ARRAY[16,1] := 1;
      IMAGE_2_ARRAY[16,2] := 17;
   IMAGE_2_ARRAY[17,1] := 2;
      IMAGE_2_ARRAY[17,2] := 12;
   IMAGE_2_ARRAY[18,1] := 6;
      IMAGE_2_ARRAY[18,2] := 6;
   IMAGE_2_ARRAY[19,1] := 10;
      IMAGE_2_ARRAY[19,2] := 4;
   IMAGE_2_ARRAY[20,1] := 15;
      IMAGE_2_ARRAY[20,2] := 3;
   IMAGE_2_ARRAY[21,1] := 20;
      IMAGE_2_ARRAY[21,2] := 4;
   IMAGE_2_ARRAY[22,1] := 22;
      IMAGE_2_ARRAY[22,2] := 6;
   IMAGE_2_ARRAY[23,1] := 25;
      IMAGE_2_ARRAY[23,2] := 10;
   For INDEX := 1 To 22 Do Begin
      Line((Round(LEFT_X_VAL + (IMAGE_2_ARRAY[INDEX,1] * SIZE_FACTOR))),
          (Round(TOP_Y_VAL + (IMAGE_2_ARRAY[INDEX,2] * SIZE_FACTOR))),
          (Round(LEFT_X_VAL + (IMAGE_2_ARRAY[INDEX + 1,1] * SIZE_FACTOR))),
          (Round(TOP_Y_VAL + (IMAGE_2_ARRAY[INDEX + 1,2] * SIZE_FACTOR))));
   End;
   CENTER_X := LEFT_X_VAL + 1 + (Round ( 24 * SIZE_FACTOR));
   CENTER_Y := TOP_Y_VAL + (Round (24 * SIZE_FACTOR));
   FloodFill(CENTER_X,CENTER_Y,GetMaxColor);
End;
Procedure IMAGE_3(lEFT_X_VAL:Integer;TOP_Y_VAL:Integer;SIZE_FACTOR:Real);
{*********************************************************}
{**                                                     **}
{**     Declair image 3's values Ying-Yang              **}
{**                                                     **}
{*********************************************************}
Var CENTER_X : Integer;
    CENTER_Y : Integer;
    RADIUS : Integer;
    HOLE : Pointer;
    HOLE_SIZE: Word;
Begin
   CENTER_X := LEFT_X_VAL + 1 + (Round ( 24 * SIZE_FACTOR));
   CENTER_Y := TOP_Y_VAL + (Round (24 * SIZE_FACTOR));
   RADIUS := Round(24 * SIZE_FACTOR);
   Circle(CENTER_X,CENTER_Y,RADIUS);
   CENTER_X := LEFT_X_VAL + 1 + (Round( 24 * SIZE_FACTOR));
   CENTER_Y := TOP_Y_VAL + (Round(15 * SIZE_FACTOR));
   RADIUS := Round( 3 * SIZE_FACTOR);
   HOLE_SIZE := ImageSize(0,0,4,4);
   GetMem(HOLE,HOLE_SIZE);
   Circle(CENTER_X,CENTER_Y,RADIUS);
   RADIUS := Round( 12 * SIZE_FACTOR);
   Arc(CENTER_X,CENTER_Y,90,270,RADIUS);
   FloodFill(CENTER_X,CENTER_Y,GetMaxColor);  {***}
   GetImage((CENTER_X - 2 ),(CENTER_Y - 2 ),
            (CENTER_X + 2 ),(CENTER_Y + 2 ),HOLE^);
   CENTER_X := LEFT_X_VAL + 1 + (Round( 24 * SIZE_FACTOR));
   CENTER_Y := TOP_Y_VAL + (Round(33 * SIZE_FACTOR));
   RADIUS := Round( 12 * SIZE_FACTOR);
   Arc(CENTER_X,CENTER_Y,270,90,RADIUS);
   CENTER_X := LEFT_X_VAL + 1 + (Round( 24 * SIZE_FACTOR));
   CENTER_Y := TOP_Y_VAL + (Round(33 * SIZE_FACTOR));
   FloodFill(CENTER_X,CENTER_Y,GetMaxColor);
   PutImage((CENTER_X - 2 ),(CENTER_Y - 2 ),HOLE^,NotPut);
   FreeMem(HOLE,HOLE_SIZE);
End;

Procedure IMAGE_4(lEFT_X_VAL:Integer;TOP_Y_VAL:Integer;SIZE_FACTOR:Real);
{*********************************************************}
{**                                                     **}
{**     Declair Image 2's values    Four Leaf Clover    **}
{**                                                     **}
{*********************************************************}
Var INDEX : Integer;
    IMAGE_4_ARRAY : Array[1..49,1..2]  Of Byte;
    CENTER_X : Integer;
    CENTER_Y : Integer;
Begin
   IMAGE_4_ARRAY[1,1] := 26;
      IMAGE_4_ARRAY[1,2] := 20;
   IMAGE_4_ARRAY[2,1] := 28;
      IMAGE_4_ARRAY[2,2] := 4;
   IMAGE_4_ARRAY[3,1] := 32;
      IMAGE_4_ARRAY[3,2] := 1;
   IMAGE_4_ARRAY[4,1] := 37;
      IMAGE_4_ARRAY[4,2] := 1;
   IMAGE_4_ARRAY[5,1] := 40;
      IMAGE_4_ARRAY[5,2] := 4;
   IMAGE_4_ARRAY[6,1] := 40;
      IMAGE_4_ARRAY[6,2] := 6;
   IMAGE_4_ARRAY[7,1] := 42;
      IMAGE_4_ARRAY[7,2] := 6;
   IMAGE_4_ARRAY[8,1] := 45;
      IMAGE_4_ARRAY[8,2] := 9;
   IMAGE_4_ARRAY[9,1] := 45;
      IMAGE_4_ARRAY[9,2] := 14;
   IMAGE_4_ARRAY[10,1] := 42;
      IMAGE_4_ARRAY[10,2] := 18;
   IMAGE_4_ARRAY[11,1] := 26;
      IMAGE_4_ARRAY[11,2] := 20;
   IMAGE_4_ARRAY[12,1] := 28;
      IMAGE_4_ARRAY[12,2] := 22;
   IMAGE_4_ARRAY[13,1] := 42;
      IMAGE_4_ARRAY[13,2] := 24;
   IMAGE_4_ARRAY[14,1] := 45;
      IMAGE_4_ARRAY[14,2] := 28;
   IMAGE_4_ARRAY[15,1] := 45;
      IMAGE_4_ARRAY[15,2] := 33;
   IMAGE_4_ARRAY[16,1] := 42;
      IMAGE_4_ARRAY[16,2] := 36;
   IMAGE_4_ARRAY[17,1] := 40;
      IMAGE_4_ARRAY[17,2] := 36;
   IMAGE_4_ARRAY[18,1] := 40;
      IMAGE_4_ARRAY[18,2] := 38;
   IMAGE_4_ARRAY[19,1] := 37;
      IMAGE_4_ARRAY[19,2] := 41;
   IMAGE_4_ARRAY[20,1] := 32;
      IMAGE_4_ARRAY[20,2] := 41;
   IMAGE_4_ARRAY[21,1] := 30;
      IMAGE_4_ARRAY[21,2] := 38;
   IMAGE_4_ARRAY[22,1] := 28;
      IMAGE_4_ARRAY[22,2] := 22;
   IMAGE_4_ARRAY[23,1] := 24;
      IMAGE_4_ARRAY[23,2] := 22;
   IMAGE_4_ARRAY[24,1] := 22;
      IMAGE_4_ARRAY[24,2] := 36;
   IMAGE_4_ARRAY[25,1] := 18;
      IMAGE_4_ARRAY[25,2] := 41;
   IMAGE_4_ARRAY[26,1] := 13;
      IMAGE_4_ARRAY[26,2] := 41;
   IMAGE_4_ARRAY[27,1] := 10;
      IMAGE_4_ARRAY[27,2] := 38;
   IMAGE_4_ARRAY[28,1] := 10;
      IMAGE_4_ARRAY[28,2] := 36;
   IMAGE_4_ARRAY[29,1] := 8;
      IMAGE_4_ARRAY[29,2] := 36;
   IMAGE_4_ARRAY[30,1] := 5;
      IMAGE_4_ARRAY[30,2] := 33;
   IMAGE_4_ARRAY[31,1] := 5;
      IMAGE_4_ARRAY[31,2] := 28;
   IMAGE_4_ARRAY[32,1] := 8;
      IMAGE_4_ARRAY[32,2] := 24;
   IMAGE_4_ARRAY[33,1] := 24;
      IMAGE_4_ARRAY[33,2] := 22;
   IMAGE_4_ARRAY[34,1] := 24;
      IMAGE_4_ARRAY[34,2] := 20;
   IMAGE_4_ARRAY[35,1] := 8;
      IMAGE_4_ARRAY[35,2] := 18;
   IMAGE_4_ARRAY[36,1] := 5;
      IMAGE_4_ARRAY[36,2] := 14;
   IMAGE_4_ARRAY[37,1] := 5;
      IMAGE_4_ARRAY[37,2] := 9;
   IMAGE_4_ARRAY[38,1] := 8;
      IMAGE_4_ARRAY[38,2] := 6;
   IMAGE_4_ARRAY[39,1] := 10;
      IMAGE_4_ARRAY[39,2] := 6;
   IMAGE_4_ARRAY[40,1] := 10;
      IMAGE_4_ARRAY[40,2] := 4;
   IMAGE_4_ARRAY[41,1] := 13;
      IMAGE_4_ARRAY[41,2] := 1;
   IMAGE_4_ARRAY[42,1] := 18;
      IMAGE_4_ARRAY[42,2] := 1;
   IMAGE_4_ARRAY[43,1] := 22;
      IMAGE_4_ARRAY[43,2] := 4;
   IMAGE_4_ARRAY[44,1] := 25;
      IMAGE_4_ARRAY[44,2] := 20;
   IMAGE_4_ARRAY[45,1] := 26;
      IMAGE_4_ARRAY[45,2] := 34;
   IMAGE_4_ARRAY[46,1] := 28;
      IMAGE_4_ARRAY[46,2] := 42;
   IMAGE_4_ARRAY[47,1] := 30;
      IMAGE_4_ARRAY[47,2] := 44;
   IMAGE_4_ARRAY[48,1] := 36;
      IMAGE_4_ARRAY[48,2] := 46;
   IMAGE_4_ARRAY[49,1] := 42;
      IMAGE_4_ARRAY[49,2] := 47;
   For INDEX := 1 To 48 Do Begin
      Line((Round(LEFT_X_VAL + (IMAGE_4_ARRAY[INDEX,1] * SIZE_FACTOR))),
          (Round(TOP_y_VAL + (IMAGE_4_ARRAY[INDEX,2] * SIZE_FACTOR))),
          (Round(LEFT_X_VAL + (IMAGE_4_ARRAY[INDEX + 1,1] * SIZE_FACTOR))),
          (Round(TOP_Y_VAL + (IMAGE_4_ARRAY[INDEX + 1,2] * SIZE_FACTOR))));
   End;
   CENTER_X := LEFT_X_VAL + 1 + (Round ( 10 * SIZE_FACTOR));
   CENTER_Y := TOP_Y_VAL + (Round (10 * SIZE_FACTOR));
   FloodFill(CENTER_X,CENTER_Y,GetMaxColor);
   CENTER_X := LEFT_X_VAL + 1 + (Round ( 30 * SIZE_FACTOR));
   CENTER_Y := TOP_Y_VAL + (Round (10 * SIZE_FACTOR));
   FloodFill(CENTER_X,CENTER_Y,GetMaxColor);
   CENTER_X := LEFT_X_VAL + 1 + (Round ( 10 * SIZE_FACTOR));
   CENTER_Y := TOP_Y_VAL + (Round (30 * SIZE_FACTOR));
   FloodFill(CENTER_X,CENTER_Y,GetMaxColor);
   CENTER_X := LEFT_X_VAL + 1 + (Round ( 30 * SIZE_FACTOR));
   CENTER_Y := TOP_Y_VAL + (ROund (30 * SIZE_FACTOR));
   FloodFill(CENTER_X,CENTER_Y,GetMaxColor);
End;
Procedure IMAGE_5(lEFT_X_VAL:Integer;TOP_Y_VAL:Integer;SIZE_FACTOR:Real);
{*********************************************************}
{**                                                     **}
{**     Declare Image 2's values    Diamond             **}
{**                                                     **}
{*********************************************************}
Var INDEX : Integer;
    IMAGE_5_ARRAY : Array[1..34,1..4] Of Byte;
    CENTER_X : Integer;
    CENTER_Y : Integer;
Begin
   IMAGE_5_ARRAY[1,1] := 2;
      IMAGE_5_ARRAY[1,2] := 14;
         IMAGE_5_ARRAY[1,3] := 9;
            IMAGE_5_ARRAY[1,4] := 7;
   IMAGE_5_ARRAY[2,1] := 9;
      IMAGE_5_ARRAY[2,2] := 7;
         IMAGE_5_ARRAY[2,3] := 42;
            IMAGE_5_ARRAY[2,4] := 7;
   IMAGE_5_ARRAY[3,1] := 42;
      IMAGE_5_ARRAY[3,2] := 7;
         IMAGE_5_ARRAY[3,3] := 49;
            IMAGE_5_ARRAY[3,4] := 14;
   IMAGE_5_ARRAY[4,1] := 2;
      IMAGE_5_ARRAY[4,2] := 14;
         IMAGE_5_ARRAY[4,3] := 25;
            IMAGE_5_ARRAY[4,4] := 34;
   IMAGE_5_ARRAY[5,1] := 25;
      IMAGE_5_ARRAY[5,2] := 34;
         IMAGE_5_ARRAY[5,3] := 49;
            IMAGE_5_ARRAY[5,4] := 14;
   IMAGE_5_ARRAY[6,1] := 2;
      IMAGE_5_ARRAY[6,2] := 14;
         IMAGE_5_ARRAY[6,3] := 49;
            IMAGE_5_ARRAY[6,4] := 14;
   IMAGE_5_ARRAY[7,1] := 4;
      IMAGE_5_ARRAY[7,2] := 14;
         IMAGE_5_ARRAY[7,3] := 7;
            IMAGE_5_ARRAY[7,4] := 9;
   IMAGE_5_ARRAY[8,1] := 7;
      IMAGE_5_ARRAY[8,2] := 9;
         IMAGE_5_ARRAY[8,3] := 13;
            IMAGE_5_ARRAY[8,4] := 7;
   IMAGE_5_ARRAY[9,1] := 7;
      IMAGE_5_ARRAY[9,2] := 9;
         IMAGE_5_ARRAY[9,3] := 10;
            IMAGE_5_ARRAY[9,4] := 14;
   IMAGE_5_ARRAY[10,1] := 10;
      IMAGE_5_ARRAY[10,2] := 14;
         IMAGE_5_ARRAY[10,3] := 17;
            IMAGE_5_ARRAY[10,4] := 9;
   IMAGE_5_ARRAY[11,1] := 13;
      IMAGE_5_ARRAY[11,2] := 7;
         IMAGE_5_ARRAY[11,3] := 17;
            IMAGE_5_ARRAY[11,4] := 9;
   IMAGE_5_ARRAY[12,1] := 17;
      IMAGE_5_ARRAY[12,2] := 9;
         IMAGE_5_ARRAY[12,3] := 26;
            IMAGE_5_ARRAY[12,4] := 7;
   IMAGE_5_ARRAY[13,1] := 17;
      IMAGE_5_ARRAY[13,2] := 9;
         IMAGE_5_ARRAY[13,3] := 16;
            IMAGE_5_ARRAY[13,4] := 14;
   IMAGE_5_ARRAY[14,1] := 17;
      IMAGE_5_ARRAY[14,2] := 9;
         IMAGE_5_ARRAY[14,3] := 25;
            IMAGE_5_ARRAY[14,4] := 14;
   IMAGE_5_ARRAY[15,1] := 26;
      IMAGE_5_ARRAY[15,2] := 7;
         IMAGE_5_ARRAY[15,3] := 36;
            IMAGE_5_ARRAY[15,4] := 10;
   IMAGE_5_ARRAY[16,1] := 36;
      IMAGE_5_ARRAY[16,2] := 10;
         IMAGE_5_ARRAY[16,3] := 42;
            IMAGE_5_ARRAY[16,4] := 14;
   IMAGE_5_ARRAY[17,1] := 36;
      IMAGE_5_ARRAY[17,2] := 10;
         IMAGE_5_ARRAY[17,3] := 36;
            IMAGE_5_ARRAY[17,4] := 14;
   IMAGE_5_ARRAY[18,1] := 36;
      IMAGE_5_ARRAY[18,2] := 10;
         IMAGE_5_ARRAY[18,3] := 39;
            IMAGE_5_ARRAY[18,4] := 7;
   IMAGE_5_ARRAY[19,1] := 39;
      IMAGE_5_ARRAY[19,2] := 7;
         IMAGE_5_ARRAY[19,3] := 44;
            IMAGE_5_ARRAY[19,4] := 9;
   IMAGE_5_ARRAY[20,1] := 44;
      IMAGE_5_ARRAY[20,2] := 9;
         IMAGE_5_ARRAY[20,3] := 42;
            IMAGE_5_ARRAY[20,4] := 14;
   IMAGE_5_ARRAY[21,1] := 44;
      IMAGE_5_ARRAY[21,2] := 9;
         IMAGE_5_ARRAY[21,3] := 46;
            IMAGE_5_ARRAY[21,4] := 14;
   IMAGE_5_ARRAY[22,1] := 4;
      IMAGE_5_ARRAY[22,2] := 14;
         IMAGE_5_ARRAY[22,3] := 18;
            IMAGE_5_ARRAY[22,4] := 28;
   IMAGE_5_ARRAY[23,1] := 10;
      IMAGE_5_ARRAY[23,2] := 14;
         IMAGE_5_ARRAY[23,3] := 18;
            IMAGE_5_ARRAY[23,4] := 28;
   IMAGE_5_ARRAY[24,1] := 10;
      IMAGE_5_ARRAY[24,2] := 14;
         IMAGE_5_ARRAY[24,3] := 22;
            IMAGE_5_ARRAY[24,4] := 28;
   IMAGE_5_ARRAY[25,1] := 16;
      IMAGE_5_ARRAY[25,2] := 14;
         IMAGE_5_ARRAY[25,3] := 22;
            IMAGE_5_ARRAY[25,4] := 28;
   IMAGE_5_ARRAY[26,1] := 25;
      IMAGE_5_ARRAY[26,2] := 14;
         IMAGE_5_ARRAY[26,3] := 22;
            IMAGE_5_ARRAY[26,4] := 28;
   IMAGE_5_ARRAY[27,1] := 22;
      IMAGE_5_ARRAY[27,2] := 28;
         IMAGE_5_ARRAY[27,3] := 25;
            IMAGE_5_ARRAY[27,4] := 34;
   IMAGE_5_ARRAY[28,1] := 25;
      IMAGE_5_ARRAY[28,2] := 14;
         IMAGE_5_ARRAY[28,3] := 28;
            IMAGE_5_ARRAY[28,4] := 28;
   IMAGE_5_ARRAY[29,1] := 36;
      IMAGE_5_ARRAY[29,2] := 14;
         IMAGE_5_ARRAY[29,3] := 28;
            IMAGE_5_ARRAY[29,4] := 28;
   IMAGE_5_ARRAY[30,1] := 42;
      IMAGE_5_ARRAY[30,2] := 14;
         IMAGE_5_ARRAY[30,3] := 28;
            IMAGE_5_ARRAY[30,4] := 28;
   IMAGE_5_ARRAY[31,1] := 42;
      IMAGE_5_ARRAY[31,2] := 14;
         IMAGE_5_ARRAY[31,3] := 37;
            IMAGE_5_ARRAY[31,4] := 24;
   IMAGE_5_ARRAY[32,1] := 46;
      IMAGE_5_ARRAY[32,2] := 14;
         IMAGE_5_ARRAY[32,3] := 37;
            IMAGE_5_ARRAY[32,4] := 24;
   IMAGE_5_ARRAY[33,1] := 25;
      IMAGE_5_ARRAY[33,2] := 14;
         IMAGE_5_ARRAY[33,3] := 36;
            IMAGE_5_ARRAY[33,4] := 10;
   IMAGE_5_ARRAY[34,1] := 28;
      IMAGE_5_ARRAY[34,2] := 28;
         IMAGE_5_ARRAY[34,3] := 25;
            IMAGE_5_ARRAY[34,4] := 34;
   For INDEX := 1 To 34 Do Begin
      Line((Round(LEFT_X_VAL + (IMAGE_5_ARRAY[INDEX,1] * SIZE_FACTOR))),
          (Round(TOP_y_VAL + (IMAGE_5_ARRAY[INDEX,2] * SIZE_FACTOR))),
          (Round(LEFT_X_VAL + (IMAGE_5_ARRAY[INDEX,3] * SIZE_FACTOR))),
          (Round(TOP_Y_VAL + (IMAGE_5_ARRAY[INDEX,4] * SIZE_FACTOR))));
   End;
   CENTER_X := LEFT_X_VAL + (Round ( 12 * SIZE_FACTOR));
   CENTER_Y := TOP_Y_VAL + (Round (15 * SIZE_FACTOR));
   FloodFill(CENTER_X,CENTER_Y,GetMaxColor);
   CENTER_X := LEFT_X_VAL + (Round ( 40 * SIZE_FACTOR));
   CENTER_Y := TOP_Y_VAL + (Round (10 * SIZE_FACTOR));
   FloodFill(CENTER_X,CENTER_Y,GetMaxColor);
   CENTER_X := LEFT_X_VAL + 1 + (Round ( 36 * SIZE_FACTOR));
   CENTER_Y := TOP_Y_VAL + (Round (18 * SIZE_FACTOR));
   FloodFill(CENTER_X,CENTER_Y,GetMaxColor);
End;

Procedure MAKE_MENU;
{**********************************************************}
{**                                                      **}
{**                                                      **}
{**                                                      **}
{**********************************************************}
Begin
ClearDevice;
IMAGE_1(0,0,0.5);
IMAGE_2(49,0,0.5);
IMAGE_3(98,0,0.5);
IMAGE_4(148,0,0.5);
IMAGE_5(197,0,0.5);
IMAGE_1(246,0,0.5);
IMAGE_2(290,0,0.5);
IMAGE_3(290,45,0.5);
IMAGE_4(290,89,0.5);
IMAGE_5(290,134,0.5);
IMAGE_1(290,173,0.5);
IMAGE_2(246,173,0.5);
IMAGE_3(197,173,0.5);
IMAGE_4(148,173,0.5);
IMAGE_5(98,173,0.5);
IMAGE_1(49,173,0.5);
IMAGE_2(0,173,0.5);
IMAGE_3(0,134,0.5);
IMAGE_4(0,89,0.5);
IMAGE_5(0,45,0.5);

End;
Procedure SONG;
{************************************************************}
{**                                                        **}
{**    This procedure plays a few bars of On a Clear Day   **}
{**                                                        **}
{************************************************************}

 Var
    S,Q,H,T,W,AL,ASL,BL,DQ,ET,TE,
    C,CS,D,DS,E,F,FS,G,GS,A,AS,B,
    CH,CSH,DH,DSH,EH,FH,FSH,GH,GSH,AH,ASH,BH   :Integer;

Procedure PLAY (NOTE : Integer; TIME : Integer);
{*********************************************************}
{**       PLAY  Sub procedure in Song                   **}
{*********************************************************}
Begin
   Sound (NOTE);
   Delay (TIME);
   NoSound;
End;

Procedure MAIN_SOUND;
{*********************************************************}
{**       MAIN_SOUND  Sub procedure in Song             **}
{*********************************************************}
   Begin
     PLAY (G,Q);
     PLAY (B,Q);
     PLAY (EH,H);
     PLAY (B,H);
     PLAY (B,H);
     PLAY (A,Q);
     PLAY (B,Q);
     PLAY (CH,H);
     PLAY (B,H);
     PLAY (G,W);
     PLAY (A,W);
     PLAY (G,W);
 End;                           {MAIN_SOUND}
{*********************************************************}
{**  SONG                                               **}
{*********************************************************}
Begin
  W := 2160;          {times}
  Q := 540;
  H := 1080;
  T := 1620;
  DQ := 808;
  ET := 272;
  AL := 220;         {tones}
  ASL := 233;
  BL := 247;
  C := 262;
  CS := 277;
  D := 294;
  DS := 311;
  E := 330;
  F := 349;
  FS := 370;
  G := 392;
  GS := 415;
  A := 440;
  AS := 466;
  B := 494;
  CH := 523;
  CSH := 554;
  DH := 587;
  DSH := 622;
  EH := 659;
  FH := 699;
  FSH := 740;
  GH := 784;
  GSH := 831;
  AH := 880;
  ASH := 932;
  BH := 988;
  MAIN_SOUND;
End;                  {Song}

Procedure PROGRAM_INFO;
{**********************************************************}
{**                                                      **}
{**   PROGRAM_INFO                                       **}
{**                                                      **}
{**********************************************************}
Var ANSWER_CHAR : Char ;
Begin                                           {PROGRAM INFO}
   MoveTo(0,30);
   OutText('     ESPTEST is a copyright 1991 by Phil Mosier');
   MoveTo(0,40);
   OutText('     Each trial is saved in full detail to be used  ');
   MoveTo(0,50);
   OutText('latter for a full analysis.  Each ASCII record    ');
   MoveTo(0,60);
   OutText('saves: the time, date, color of the screen, type  ');
   MoveTo(0,70);
   OutText('of test, elapsed time in seconds, the image of the');
   MoveTo(0,80);
   OutText('target, the place of all the targets on the     ');
   MoveTo(0,90);
   OutText('screen, the current name of the record file.     ');
   MoveTo(0,100);
   OutText('     The analysis screen computes the probability,');
   MoveTo(0,110);
   OutText('the confidence level, and the next level      ');
   MoveTo(0,120);
   OutText('analysises the differences among proportions.');
   MoveTo(0,130);
   OutText('     For Registration send $35.oo plus $4.oo for');
   MoveTo(0,140);
   OutText('Postage and Handling to:');
   MoveTo(0,160);
   OutText('                  Phil Mosier     ');
   MoveTo(0,170);
   OutText('                  2728 Bridgeford Dr.');
   MoveTo(0,180);
   OutText('                  Sacramento,CA 95833');
   MoveTo(0,190);
   OutText('  Press any key');
   ANSWER_CHAR := ReadKey;
End;

Procedure BOXES;
{**********************************************************}
{**                                                      **}
{**   BOXES                                              **}
{**                                                      **}
{**********************************************************}
Begin                                  {BOXES}
   ClearDevice;
   Line(50,30,250,30);
   Line(50,50,250,50);
   Line(50,70,250,70);
   Line(50,30,50,70);
   Line(90,30,90,70);
   Line(130,30,130,70);
   Line(170,30,170,70);
   Line(210,30,210,70);
   Line(250,30,250,85);
   Line(250,85,315,85);

   Line(50,85,250,85);
   Line(50,105,250,105);
   Line(50,125,250,125);
   Line(50,85,50,125);
   Line(90,85,90,125);
   Line(130,85,130,125);
   Line(170,85,170,125);
   Line(210,85,210,125);
   Line(250,85,250,180);

   Line(50,145,130,145);
   Line(50,165,130,165);
   Line(50,185,130,185);
   Line(50,145,50,185);
   Line(90,145,90,185);
   Line(130,125,130,185);

   IMAGE_1(50,0,0.5);
   IMAGE_2(90,0,0.5);
   IMAGE_3(130,0,0.5);
   IMAGE_4(170,0,0.5);
   IMAGE_5(210,0,0.5);
   MoveTo(10,33);
   OutText('Hits');
   MoveTo(10,53);
   OutText('Misses');
   MoveTo(10,88);
   OutText('Hits');
   MoveTo(10,108);
   OutText('Misses');
   MoveTo(10,145);
   OutText('Hits');
   MoveTo(10,165);
   OutText('Misses');
   MoveTo(50,74);
   OutText('Place 1   2      3      4      5');
   MoveTo(45,126);
   OutText('Shorter Longer');
   MoveTo(45,135);
   OutText('Times   Times');
   MoveTo(0,190);
   OutText(' Enter Q to QUIT and return to MENU');
End;                                   {BOXES}

End.


