CODE_SEG segment
	assume		cs:CODE_SEG

	org	80h
	PARA_LEN	label byte

	org		100h

ENTRY:  jmp		START
	HANDLE1	dw	0
	HANDLE2	dw	0
	OUTFILE	db	64 dup (?)
	EXT	db 	'.C4V0'
	SPACE_FLAG	db	0
	HYPHEN_FLAG	db	0
	QUOTE_FLAG	db	0
	PAREN_FLAG	db	0
	LF_FLAG		db	0Ah
	WS_FLAG		db	0
	NEED_CR		db	0
	IN_BUF		db 128 dup (?)	;
	NUM_THERE db	0
	OUT_BUF		db 128 dup (?)	;
	FULL_BUF	label byte
	BAD_DOS		db 07h,'You need DOS 2.x or higher to use CLEAN4VP.$'
	ERR1    DB   07h,0DH,0AH,'No such file.',0DH,0AH,'$'
	ERR2    DB   07h,0DH,0AH,'Error reading file.  Aborting.',0DH,0AH,'$'
	ERR3    DB   07h,0DH,0AH,'Disk full.  Aborting.',0DH,0AH,'$'
	ERR4    DB   07h,0DH,0AH,'Error writing file.  Aborting.',0DH,0AH,'$'
	ERR5    DB   07h,0DH,0AH,'Error closing file.',0DH,0AH,'$'
	UNEVEN	db	07h,0Dh,0Ah,'Note:  This file has an uneven number of quotes in it.',0Dh,0Ah
		db	'       The substitutions of <169> and <170> are probably hosed up.',0Dh,0Ah,'$'
	MES1	db	0Dh,0Ah,'Processing file '
	DOT	db	'.$'
	MES2	db	' done.',0Dh,0Ah,'$'
	BANNER	db	07h
		db	'ͻ'
		db	'  CLEAN4VP.COM--by Dan Zoll, May 1988                                         '
		db	'                                                                              '
		db	'  Cleans up a text file for reading into WordPerfect then Ventura Publisher.  '
		db	'                                                                              '
		db	'  Syntax:  CLEAN4VP [/w] filename                                             '
		db	'                                                                              '
		db	'  Functions:                                                                  '
		db	'                                                                              '
		db	'     Changes two or more spaces to one, but strips spaces on left margin;     '
		db	'     Turns single hard CR to soft CR, double hard CR to one hard CR;          '
		db	'     With /w switch, resets characters',27h,' high-order bit (for WordStar files);  '
		db	'     Strips out all control characters except CR, LF, and tab;                '
		db	'     Replaces " with <169> or <170>, as appropriate; outputs message          '
		db	'       if there is an uneven number of quotes;                                '
		db	'     Replaces -- with <197>;                                                  '
		db	'     Doubles all occurrences of < and >, @ if it',27h,'s in the first column;       '
		db	'     Puts a space between ().                                                 '
		db	'                                                                              '
		db	'  Outputs file with same name as source file, but with .C4V extension.        '
		db	'                                                                              '
		db	'  Note:  Save WordPerfect files as DOS text files before processing them!     '
		db	'ͼ$'

;---------------------------------------------------------------------------
; Check for DOS 2.x and terminate if earlier verion
;---------------------------------------------------------------------------
START:	mov	ah,30h			;check DOS version
	int	21h			;
	cmp	al,2			;DOS 2.x or later?
	jge	OK_DOS			;if so, go on
	mov	dx,offset BAD_DOS	;else terminate with message
	jmp	SHOWERR
	int	20h

;---------------------------------------------------------------------------
; Check for presence of command-line parameter
;---------------------------------------------------------------------------
OK_DOS:	cmp	PARA_LEN,0		;is something there?
	jnz	THERE			;if so, go on
NEED_VAR: mov	dx,offset BANNER	;if nothing, exit with instructions
	jmp	SHOWERR			;

;---------------------------------------------------------------------------
; Find first character of filename, check for /W switch
;---------------------------------------------------------------------------
THERE:	mov	si,82h			;start from first char position
LOOP3:	lodsb				;move past any leading spaces
	cmp    al,' '			;
	jz	LOOP3			;
	cmp	al,9			;move past tabs, too
	jz	LOOP3			;
	cmp	al,'/'
	jnz	NO_SW
	mov	WS_FLAG,1
	inc	si
	jmp	LOOP3
NO_SW:	cmp	al,0Dh			;is there just CR?
	jnz	MOVE_NAME		;if character there, OK
	mov	dx,offset BANNER	;else nothing, so exit with info
	jmp	SHOWERR			;

;---------------------------------------------------------------------------
; Move input file name sans extension to output file name, add C4V ext
;---------------------------------------------------------------------------
MOVE_NAME: mov	di,offset OUTFILE	;point to output name buffer
	push	si			;save start add of file name+1
LOOP10:	stosb				;transfer character
	lodsb				;get next
	cmp	al,'.'			;reached extension?
	jz	AT_EXT			;if so, go on
	cmp	al,0Dh			;reached end of string?
	jnz	LOOP10			;if not, keep transferring
AT_EXT: mov	si,offset EXT		;point to extension
	mov	cx,5			;5 bytes long
	rep movsb			;move it

;---------------------------------------------------------------------------
; Zero out CR at end of file name
;---------------------------------------------------------------------------
	mov	si,81h			;point to start of parameter
	mov	al,PARA_LEN		;get length of file name
	cbw				;make it a word for adding
	add	si,ax			;figure offset of final CR
	mov	byte ptr [si],0		;zero it out

;---------------------------------------------------------------------------
; Open input file
;---------------------------------------------------------------------------
	pop	dx			;recover add of file name+1
	dec	dx			;point to start
	mov  ax,3D00h			;code to open file, read only access
	int  21h			;open it
	mov  HANDLE1,ax			;save handle
	jnc  OPEN_OUT			;if opened OK, open output file
	mov  dx,offset ERR1		;else show error
	jmp  SHOWERR

;---------------------------------------------------------------------------
; Create output file
;---------------------------------------------------------------------------
OPEN_OUT: mov	dx,offset OUTFILE	;point to output file name
	xor	cx,cx			;read/write attrib
	mov	ah,3Ch			;code to create file
	int	21h			;create it
	mov	HANDLE2,ax		;save handle	
	jnc	SET_OUT			;if created OK, begin processing
	mov	dx,offset ERR3		;else show error
	jmp	SHOWERR

;---------------------------------------------------------------------------
; Read 128 bytes of input file
;---------------------------------------------------------------------------
SET_OUT: mov	dx,offset MES1
	mov	ah,9
	int	21h
	mov	di,offset OUT_BUF	;DI points to output buffer
READ:	mov	dx,offset DOT
	mov	ah,9
	int	21h
	mov	bx,HANDLE1		;recover handle of input file
	mov	cx,128d			;will read 128 bytes
	mov	dx,offset IN_BUF	;into input buffer
	mov	ah,3Fh			;set read-file code
	int	21h			;read
	jnc	READ_OK			;if read OK, go on
	mov	dx,offset ERR2		;else show error
	jmp	SHOWERR
READ_OK: test	al,al			;chars read?
	jnz	CHAR_READ		;if so, go on
	jmp	AT_EOF			;else at EOF
CHAR_READ: mov	NUM_THERE,al		;save number of bytes in buffer

;---------------------------------------------------------------------------
; Begin processing
;---------------------------------------------------------------------------
	mov	si,offset IN_BUF	;SI points to start of input buffer
LOOP8:	cmp	NUM_THERE,0		;no more characters?
	jz	READ			;if not, read more
	lodsb				;else read next character
	dec	NUM_THERE		;one less there now
	cmp	WS_FLAG,0		;is this a WordStar file?
	jz	NOT_WS			;if not, go on
	and	al,07Fh			;else reset high bit

NOT_WS:	cmp	SPACE_FLAG,0		;was last char not a space?
	jz	NO_SPACE_FLAG		;if not, go on
	cmp	al,' '			;if was a space, is this space too?
	jz	LOOP8			;if so, ignore it
	cmp	al,0Dh			;is space at end of line?
	jz	ISIT_AT			;if so, don't add space
	cmp	al,0Ah			;again, space at end?
	jz	ISIT_AT			;if so, don't add
	cmp	LF_FLAG,0Ah		;did we just have CR/LF?
	jz	ISIT_AT			;if so, don't add space
JUMP8:	push	ax			;else save current char
	mov	al,' '			;add space
	call	ADD_CHAR		;
	pop	ax			;recover char
	jmp	ISIT_AT			;go on
NO_SPACE_FLAG: cmp al,' '		;is it a space?
	jnz	ISIT_AT			;if not, go on
	mov	SPACE_FLAG,al		;else set space flag
	jmp	LOOP8

ISIT_AT: cmp	al,'@'			;is this @?
	jnz	ISIT_LESS		;if not, go on
	call	ADD_CHAR		;else add @ to buffer
	cmp	LF_FLAG,0Ah		;is it in 1st column?
	jnz	LOOP8			;if not, get next char
	mov	LF_FLAG,0		;else reset LF flag
	call	ADD_CHAR		;output second @
	jmp	LOOP8			;get next char

ISIT_LESS: cmp	al,'<'			;is this LESS sign?
	jnz	ISIT_GREATER		;if not, go on
	call	ADD_CHAR		;else add this one
	call	ADD_CHAR		;add one more
	jmp	LOOP8			;get next character

ISIT_GREATER: cmp al,'>'		;is this GREATER?
	jnz	ISIT_HYPHEN		;if not, go on
	call	ADD_CHAR		;else add this one
	call	ADD_CHAR		;add one more
	jmp	LOOP8			;get next character

ISIT_HYPHEN: cmp HYPHEN_FLAG,'-'	;was last char a HYPHEN?
	jnz	NO_HYPHEN_FLAG		;if not, go on
	cmp	al,'-'			;if last was HYPHEN, is this too?
	jnz	ADD_HYPHEN		;if not, add second HYPHEN sign
	mov	al,'<'
	call	ADD_CHAR
	mov	al,'1'
	call	ADD_CHAR
	mov	al,'9'
	call	ADD_CHAR
	mov	al,'7'
	call	ADD_CHAR
	mov	al,'>'
	call	ADD_CHAR
	mov	HYPHEN_FLAG,0		;reset flag
	jmp	LOOP8			;get next character
ADD_HYPHEN:	push	ax			;save current character
	mov	al,'-'			;load HYPHEN in AL
	call	ADD_CHAR		;add HYPHEN to buffer
	pop	ax			;recover current character
	mov	HYPHEN_FLAG,0		;reset flag
	jmp	ISIT_PAREN		;go on
NO_HYPHEN_FLAG: cmp al,'-'		;do we have the HYPHEN sign?
	jnz	ISIT_PAREN		;if not, go on
	mov	HYPHEN_FLAG,al		;else raise HYPHEN flag
	jmp	LOOP8			;get next char

ISIT_PAREN: cmp	PAREN_FLAG,'('		;was last char a PAREN sign?
	jnz	NO_PAREN_FLAG		;if not, go on
	cmp	al,')'			;if last was PAREN, is this too?
	jz	ADD_SPACE		;if so, add space
	call	ADD_CHAR		;else add this one
	mov	PAREN_FLAG,0		;reset flag
	jmp	LOOP8			;get next character
ADD_SPACE: mov	al,' '			;load space in AL
	call	ADD_CHAR		;add PAREN to buffer
	mov	al,')'			;load close paren
	call	ADD_CHAR		;add it too
	mov	PAREN_FLAG,0		;reset flag
	jmp	LOOP8			;get next char
NO_PAREN_FLAG: cmp al,'('		;do we have the PAREN sign?
	jnz	ISIT_QUOTE		;if not, go on
	mov	PAREN_FLAG,al		;else raise PAREN flag
	call	ADD_CHAR		;add char to buffer
	jmp	LOOP8			;get next char

ISIT_QUOTE: cmp	al,'"'			;quote marks?
	jnz	ISIT_CR			;if not, go on
	mov	al,'<'			;else output <1
	call	ADD_CHAR		;
	mov	al,'1'			;
	call	ADD_CHAR		;
	cmp	QUOTE_FLAG,'9'		;do we have an opening quote already?
	jnz	OPEN_QUOTE		;if not, this is opening quote
	mov	al,'7'
	call	ADD_CHAR
	mov	al,'0'
	call	ADD_CHAR
	mov	QUOTE_FLAG,0		;reset flag
	jmp	FINISH
OPEN_QUOTE: mov	al,'6'
	call	ADD_CHAR
	mov	al,'9'
	mov	QUOTE_FLAG,al
	call	ADD_CHAR
FINISH:	mov	al,'>'
	call	ADD_CHAR
	jmp	LOOP8			;get next character

ISIT_CR: cmp	al,0Dh			;is it CR?
	jnz	ISIT_LF			;if not, go on
	jmp	LOOP8			;get next char

ISIT_LF: cmp	al,0Ah			;is it LF?
	jnz	ZAP_CTRL		;if not, go on
	cmp	LF_FLAG,0Ah		;was last char CR?
	jz	ADD_LF			;if so, add LF
	mov	LF_FLAG,al		;else set lf flag
	mov	NEED_CR,al		;set cr flag too
	jmp	LOOP8			;get next char
ADD_LF:	call	ADD_CHAR		;add LF
	mov	NEED_CR,0		;reset cr flag
	jmp	LOOP8			;get next char

ZAP_CTRL: mov	LF_FLAG,0		;reset LF flag
	cmp	NEED_CR,0		;do we need a CR?
	jz	NO_CR			;if not, go on
	mov	NEED_CR,0		;else reset CR flag
	push	ax			;save current char
	mov	al,0Dh			;add CR
	call	ADD_CHAR		;
	pop	ax			;recover current char
NO_CR:	cmp	al,9			;is it tab?
	jz	NOT_CTRL		;if so, OK
	cmp	al,' '			;is it control char?
	jc	CTRL			;if so, go on
	jg	NOT_CTRL		;else not ctrl
NOT_CTRL: call	ADD_CHAR		;else add char
CTRL:	mov	SPACE_FLAG,0
	jmp	LOOP8			;get next char
	
ADD_CHAR: cmp	di,offset FULL_BUF	;is buffer full?
	jl	BUF_OK			;if not, OK
	push	ax			;else save char to write
	call	WRITE_BUF		;write buffer to file
	pop	ax			;recover char
BUF_OK:	stosb				;add char to output buffer
	mov SPACE_FLAG,0
	ret				;return

WRITE_BUF: mov	bx,HANDLE2		;get handle of output file
        mov	dx,offset OUT_BUF	;point to output buffer
        mov	cx,di			;figure how many bytes to write
	sub	cx,dx			;
	mov	ah,40h			;code to write
	int	21h			;write
	jnc	WROTE_OK		;if wrote OK, cont
	mov	dx,offset ERR4		;else show error
	jmp	SHOWERR
WROTE_OK: mov	di,offset OUT_BUF	;reset pointer to start of buffer
	ret				;return

AT_EOF:	cmp	di,offset OUT_BUF	;
	jz	NO_CHARS		;if 0, no chars there
	call	WRITE_BUF		;else write them
NO_CHARS: mov	bx,handle1		;handle in bx
	mov	ah,3Eh			;code to close file
	int	21h			;close input file
	jnc	CLOSE_OUT		;if closed OK, go on
	mov	dx,offset ERR5		;else show error
	jmp	SHOWERR
CLOSE_OUT: mov	bx,HANDLE2		;get handle
	mov	ah,3Eh			;close code
	int	21h			;close
	jnc	ALL_DONE		;if closed OK, go on
	mov	dx,offset ERR5		;else show error
	jmp	SHOWERR

ALL_DONE: mov	dx,offset MES2
	mov	ah,9
	int	21h

CHECK_QUOTE: cmp QUOTE_FLAG,0
	jz	ENDING
	mov	dx,offset UNEVEN

SHOWERR: mov	ah,9
	int	21h
ENDING:	int	20h

CODE_SEG ends
end      ENTRY
