;ͻ
;  PROGRAM = PIC2IMG.ASM  
;ͼ
CSEG	       SEGMENT PUBLIC BYTE
	       ASSUME  CS:CSEG,DS:CSEG

CR	       EQU     0DH
LF	       EQU     0AH

FILENAME       DB      128 DUP(0)
GMI	       DB      'GMI',0
IMG	       DB      'IMG',0
HANDLE_IN      DW      0
HANDLE_OUT     DW      0
TYPE_FROM      DW      0
BUFF_SIZE      DW      0

LINES_PER_BUFF DW      0
NUMBER_READS   DW      0

DISK_BUFFER    DD      0

;44 BYTES
IMG_NAME       DB      'FILE GENERATED FROM PCPAINT   '
IMG_HEIGHT     DW      0
IMG_WIDTH      DW      0
IMG_WIDTH_BYTE DW      0
IMG_PIX_SIZE   DW      1
IMG_PIX_FMT    DW      0
IMG_COLOR      DW      0
IMG_COMPRESS   DW      0

FLAGS	       DW      0
GMI_FILE       EQU     1

TELL_HOW       DB      'Ŀ',cr,lf
	       DB      ' MIRROR filename.typ                          ',cr,lf
	       DB      'Ĵ',cr,lf
	       DB      ' filename = IMG or GMI format picture         ',cr,lf
	       DB      ' typ      = must end in IMG or GMI            ',cr,lf
	       DB      'Ĵ',cr,lf
	       DB      ' Converts GMI file to IMG file                ',cr,lf
	       DB      ' Converts IMG file to GMI file                ',cr,lf
	       DB      ' IMG file is CLR image format                 ',cr,lf
	       DB      ' GMI is IMG file with vertical scan lines     ',cr,lf
	       DB      '  reversed (mirror effect)                    ',cr,lf
	       DB      '',cr,lf
	       DB      7,'$'
OPEN_ERROR     DB      'file not found...must end in IMG or GMI',cr,lf,'$'
CREATE_ERROR   DB      'create error on output file',cr,lf,'$'
;ͻ
;  MAIN.ASM  
;ͼ
MAIN	       PROC    FAR
;Ŀ
;	       RETURN SETUP						       
;
	       CLI
	       MOV     AX,CS		       ;TEMP STACK
	       MOV     SS,AX		       ;
	       MOV     ES,AX		       ;
	       MOV     SP,OFFSET STACK	       ;
	       STI
	       PUSH    DS		       ;
	       XOR     AX,AX		       ;
	       PUSH    AX		       ;
	       CLD
;Ŀ
;	       GET FILENAME FROM COMMAND LINE				       
;
	       MOV     SI,82H		       ;START OF FILENAME
	       XOR     CH,CH		       ;
	       MOV     CL,DS:[SI-2]	       ;SIZE OF FILENAME
	       CMP     CX,0		       ;NO COMMANDS
	       JE      GFN800		       ;ERROR
	       MOV     DI,OFFSET FILENAME      ;STORE FILENAME HERE
GFN100:
	       LODSB			       ;GET CHARACTER
	       CMP     AL,20H		       ;END OF FILENAME?
	       JE      GFN900		       ;YES....BRANCH
	       CMP     AL,CR		       ;END OF COMMAND LINE?
	       JE      GFN900		       ;YES....ERROR
	       STOSB			       ;SAVE CHARACTER
	       CMP     AL,'.'                  ;START OF TYPE
	       JNE     GFN200		       ;
	       MOV     CS:TYPE_FROM,DI	       ;START OF TYPE
GFN200:
	       LOOP    GFN100		       ;GET ANOTHER CHARACTER
	       JMP     SHORT GFN800	       ;ERROR IF DONE ALREADY
GFN800:
	       MOV     DX,OFFSET TELL_HOW      ;
	       JMP     ERROR		       ;
GFN900:
	       MOV     AL,0		       ;PUT NULL AT END OF STRING
	       STOSB			       ;
	       CMP     WORD PTR CS:TYPE_FROM,0 ;
	       JNE     SET_BREAK
	       DEC     DI
	       MOV     CS:TYPE_FROM,DI
;Ŀ
;	       TURN BREAK KEY ON					       
;
SET_BREAK:
	       MOV     AX,CS		       ;SET DATA SEGMENT
	       MOV     DS,AX		       ;
	       MOV     ES,AX
	       CALL    BREAK_ON 	       ;SET UP CONTROL BREAK
;Ŀ
;	       FIND DISK MEMORY 					       
;
	       MOV     AX,OFFSET PROG_END      ;
	       MOV     BX,CS		       ;
	       SHR     AX,1		       ;
	       SHR     AX,1		       ;
	       SHR     AX,1		       ;
	       SHR     AX,1		       ;
	       ADD     BX,AX		       ;
	       ADD     BX,8		       ;
	       MOV     WORD PTR DISK_BUFFER+2,BX	  ;
;Ŀ
;	       CHECK  FILENAME						       
;
	       MOV     SI,OFFSET IMG	       ;
	       MOV     DI,TYPE_FROM	       ;
	       MOV     CX,3		       ;
	       AND     BYTE PTR [DI],0DFH		;MAKE CAPITOL LETTER
	       AND     BYTE PTR [DI+1],0DFH		;MAKE CAPITOL LETTER
	       AND     BYTE PTR [DI+2],0DFH		;MAKE CAPITOL LETTER
	       REP     CMPSB		       ;
	       JE      OIF000
;Ŀ
;	       CHECK  FILENAME						       
;
CF100:
	       MOV     SI,OFFSET GMI	       ;
	       MOV     DI,TYPE_FROM	       ;
	       MOV     CX,3		       ;
	       REP     CMPSB		       ;
	       JNE     OIF050
	       OR      FLAGS,GMI_FILE
;Ŀ
;	       OPEN INPUT FILE						       
;
OIF000:
	       MOV     AH,3DH		       ;OPEN FILE FOR READ
	       MOV     AL,0H		       ;
	       MOV     DX,OFFSET FILENAME      ;
	       INT     21H		       ;
	       JNC     OIF100
OIF050:
	       MOV     DX,OFFSET OPEN_ERROR    ;
	       JMP     ERROR
OIF100:
	       MOV     HANDLE_IN,AX
;Ŀ
;	       CHANGE FILENAME						       
;
	       TEST    FLAGS,GMI_FILE
	       JE      CF300
	       MOV     SI,OFFSET IMG	       ;CHANGE TYPE ON FILENAME
	       JMP     SHORT CF400
CF300:
	       MOV     SI,OFFSET GMI
CF400:
	       MOV     DI,TYPE_FROM	       ;
	       MOV     CX,3		       ;
	       REP     MOVSB		       ;
;Ŀ
;	       CREATE OUTPUT FILE					       
;
	       MOV     AH,3CH		       ;
	       MOV     CX,20H		       ;
	       MOV     DX,OFFSET FILENAME      ;
	       INT     21H		       ;
	       JNC     COF100
	       MOV     DX,OFFSET CREATE_ERROR  ;
	       JMP     ERROR
COF100:
	       MOV     HANDLE_OUT,AX
;Ŀ
;	       READ IMG HEADER						       
;
	       MOV     AH,3FH
	       MOV     BX,HANDLE_IN
	       MOV     CX,44
	       MOV     DX,OFFSET IMG_NAME
	       INT     21H
;Ŀ
;	       WRITE IMG HEADER 					       
;
	       MOV     AH,40H
	       MOV     BX,HANDLE_OUT
	       MOV     CX,44
	       MOV     DX,OFFSET IMG_NAME
	       INT     21H
;Ŀ
;	       MOVE PICTURE DATA BETWEEN FILES				       
;
READ_BLOCK:
;Ŀ
;	       CALCULATE NUMBER OF LINES PER 8K BUFFER			       
;
	       MOV     AX,8000H
	       MOV     CX,IMG_WIDTH_BYTE
	       XOR     DX,DX
	       DIV     CX		       ;AX = NUMBER OF LINES IN BUFFER
	       MOV     LINES_PER_BUFF,AX
	       MUL     CX		       ;GET BUFFER SIZE
	       MOV     BUFF_SIZE,AX	       ;
;Ŀ
;	       CALCULATE NUMBER OF FILE READS				       
;
	       MOV     CX,LINES_PER_BUFF       ;
	       MOV     AX,IMG_HEIGHT	       ;LINES/LINES PER BUFFER
	       XOR     DX,DX		       ;
	       DIV     CX		       ;AX = NUMBER OF READS
	       INC     AX
	       MOV     NUMBER_READS,AX	       ;SAVE
;Ŀ
;	       POSITION FILE POINTER .....FIRST READ			       
;
	       DEC     AX
	       MOV     CX,BUFF_SIZE
	       MUL     CX		       ;DX:AX = OFFSET

	       MOV     CX,DX		       ;OFFSETS
	       MOV     DX,AX		       ;
	       MOV     AH,42H		       ;MOVE FILE POINTER
	       MOV     AL,1		       ;FROM PRESENT LOCATION
	       MOV     BX,HANDLE_IN	       ;
	       INT     21H		       ;DX:AX = PRESENT LOCATION
PF100:
	       CALL    PROCESS_PAC	       ;
	       DEC     NUMBER_READS
	       JZ      CLOSE_FILE
	       JS      CLOSE_FILE
	       SUB     AX,BUFF_SIZE
	       JNc     PF200
	       DEC     DX
PF200:
	       MOV     CX,DX		       ;OFFSETS
	       MOV     DX,AX		       ;
	       MOV     AH,42H		       ;MOVE FILE POINTER
	       MOV     AL,0		       ;FROM BEGINNING OF FILE
	       MOV     BX,HANDLE_IN	       ;
	       INT     21H		       ;DX:AX = PRESENT LOCATION
	       JMP     SHORT PF100
;Ŀ
;	       CLOSE FILES						       
;
CLOSE_FILE:
	       MOV     BX,HANDLE_IN	       ;CLOSE FILE
	       MOV     AH,3EH		       ;
	       INT     21H		       ;
	       MOV     BX,HANDLE_OUT	       ;CLOSE FILE
	       MOV     AH,3EH		       ;
	       INT     21H		       ;
	       JMP     EXIT
ERROR:
	       MOV     AX,CS
	       MOV     DS,AX
	       MOV     AH,9
	       INT     21H
EXIT:
	       CALL    BREAK_OFF	       ;BREAK KEY RESET
	       RET			       ;
MAIN	       ENDP

;ͻ
;  PROCESS PACKET  
;ͼ
PROCESS_PAC    PROC    NEAR

	       PUSH    AX
	       CALL    IMG_READ
	       CALL    REVERSE_LINES
	       MOV     CX,AX		       ;SIZE OF BUFFER
	       CALL    IMG_WRITE
	       POP     AX
	       RET

PROCESS_PAC    ENDP
;ͻ
;  REVERSE LINES  
;ͼ
;Ŀ
;	       AX=NUMBER OF CHARACTERS IN BUFFER			       
;
REVERSE_LINES  PROC    NEAR

	       PUSH    AX		       ;SAVE REGISTERS
	       PUSH    BX		       ;
	       PUSH    CX		       ;
	       PUSH    DX		       ;
	       PUSH    DI		       ;
	       PUSH    SI		       ;
	       PUSH    DS		       ;
	       PUSH    ES		       ;

	       STD
	       LES     DI,DISK_BUFFER	       ;
	       ADD     DI,8000H 	       ;SECOND BUFFER
	       LDS     SI,DISK_BUFFER	       ;
	       ADD     SI,AX		       ;GO TO END OF BUFFER

	       MOV     CX,CS:IMG_WIDTH_BYTE	 ;GET BYTES PER LINE
	       XOR     DX,DX
	       DIV     CX		       ;GET NUMBER OF LINES
	       MOV     CX,AX		       ;NUMBER OF LOOPS
RL100:
	       PUSH    CX
	       ADD     DI,CS:IMG_WIDTH_BYTE
	       PUSH    DI
	       MOV     CX,CS:IMG_WIDTH_BYTE    ;NUMBER OF BYTES TO MOVE
	       REP     MOVSB		       ;MOVE LINE
	       POP     DI
	       POP     CX
	       LOOP    RL100
	       CLD

	       POP     ES		       ;RESTORE REGISTERS
	       POP     DS		       ;
	       POP     SI		       ;
	       POP     DI		       ;
	       POP     DX		       ;
	       POP     CX		       ;
	       POP     BX		       ;
	       POP     AX		       ;
	       RET
REVERSE_LINES  ENDP
;ͻ
;  IMAGE READ  
;ͼ
;Ŀ
;	       READ  IMAGE FILE 					       
;
IMG_READ       PROC    NEAR

	       PUSH    BX		       ;
	       PUSH    CX		       ;
	       PUSH    DX		       ;
	       PUSH    DS

	       MOV     AH,3FH		       ;
	       MOV     BX,HANDLE_IN	       ;
	       MOV     CX,BUFF_SIZE	       ;
	       LDS     DX,DISK_BUFFER	       ;
	       INT     21H		       ;

	       POP     DS
	       POP     DX		       ;RESTORE REGISTERS
	       POP     CX		       ;
	       POP     BX		       ;
	       RET

IMG_READ       ENDP
;ͻ
;  IMAGE WRITE  
;ͼ
;Ŀ
;	       WRITE IMAGE FILE 					       
;
IMG_WRITE      PROC    NEAR

	       PUSH    AX		       ;SAVE REGISTERS
	       PUSH    BX		       ;
	       PUSH    CX		       ;
	       PUSH    DX		       ;
	       PUSH    DS

	       MOV     AH,40H		       ;
	       MOV     BX,HANDLE_OUT	       ;
	       LDS     DX,DISK_BUFFER	       ;
	       ADD     DX,8000H
	       INT     21H		       ;

	       POP     DS
	       POP     DX		       ;RESTORE REGISTERS
	       POP     CX		       ;
	       POP     BX		       ;
	       POP     AX		       ;
	       RET

IMG_WRITE      ENDP
;Ŀ
;
EOI	      EQU      20H		      ;END OF INTERRUPT
BRKINT	      EQU      1BH		      ;BREAK INTERRUPT
SAV_BRK       DW       ?
;ͻ
;  BREAK_ON  
;ͼ
	      PUBLIC   BREAK_ON
BREAK_ON      PROC     NEAR
	      PUSH     AX
	      PUSH     BX		       ;SAVE REGISTERS
	      PUSH     CX		       ;
	      PUSH     DX		       ;
	      PUSH     SI		       ;
	      PUSH     ES		       ;

	      XOR      BX,BX		       ;SEGMENT 0
	      MOV      ES,BX		       ;
	      MOV      SI,BRKINT*4	       ;OFFSET OF INTERUPT VECTOR

	      MOV      CX,ES:WORD PTR[SI]      ;OFFSET OF CURRENT VECT
	      MOV      DX,ES:WORD PTR[SI+2]    ;SEGMENT OF CURRENT VECT
	      MOV      CS:SAV_BRK,CX	       ;SAVE OFFSET
	      MOV      CS:SAV_BRK+2,DX	       ;SAVE SEGMENT

	      MOV      AX,OFFSET BREAK	       ;
	      CLI			       ;NO INTERRUPTS
	      MOV      ES:WORD PTR[SI],AX      ;SET OFFSET
	      MOV      AX,CS		       ;SET THIS CODE SEGMENT
	      MOV      ES:WORD PTR[SI+2],AX    ;MOVE SEG ADDR TO INT.VECT
	      STI			       ;INTERRUPTS BACK ON

	      POP      ES		       ;RESTORE REGISTERS
	      POP      SI		       ;
	      POP      DX		       ;
	      POP      CX		       ;
	      POP      BX		       ;
	      POP      AX		       ;
	      RET			       ;
BREAK_ON      ENDP
;ͻ
;  BREAK_OFF  
;ͼ
	      PUBLIC   BREAK_OFF
BREAK_OFF     PROC     NEAR

	      PUSH     AX		       ;
	      PUSH     CX		       ;
	      PUSH     DX		       ;
	      PUSH     DI		       ;
	      PUSH     ES		       ;

	      XOR      AX,AX		       ;
	      MOV      ES,AX		       ;SEGMENT 0
	      MOV      CX,CS:SAV_BRK	       ;RESET VECTOR BACK TO OLD RTN
	      MOV      DX,CS:SAV_BRK+2	       ;
	      MOV      DI,BRKINT*4	       ;
	      CLI			       ;NO INTERRUPTS
	      MOV      ES:WORD PTR[DI],CX      ;
	      MOV      ES:WORD PTR[DI+2],DX    ;
	      STI			       ;INTERRUPTS BACK ON

	      POP      ES		       ;
	      POP      DI		       ;
	      POP      DX		       ;
	      POP      CX		       ;
	      POP      AX		       ;
	      RET			       ;
BREAK_OFF     ENDP
;ͻ
;  BREAK   J
;ͼ
	      PUBLIC   BREAK
BREAK	      PROC     FAR

	      MOV      AX,CS
	      MOV      DS,AX
	      MOV      AL,EOI		       ;
	      OUT      020H,AL		       ;
	      CALL     BREAK_OFF
	      MOV      SP,OFFSET STACK-4       ;
	      RET

BREAK	      ENDP
;Ŀ
;
	       DB      64 DUP('STACK')
STACK	       EQU     $
PROG_END       EQU     $
CSEG	       ENDS
	       END     MAIN
