/* argloop.h: @(#) Begining of argument loop, see argparse.h */
/* by Alexander B. Abacus */

  a0.keysTerminated = 0;
  a0.nextPositional = 1;
  a0.argIndex = 1;

  if ( ( a0.argVector[1][0] == a0.keyTrigger )
  &&   ( a0.argVector[1][1] == '!'           ) )
  {
    a0.textPointer = & a0.argVector[1][1];
#ifdef Debug
      /* if not followed by characters, debug all levels */
      if ( (* (a0.textPointer + 1)) == '\0' ) debug[0] = (char) 127;

      /* if followed by characters, select debugging levels */
      while ( (* ++a0.textPointer) != '\0' )
      { /* for all characters following -! */
	if ((* a0.textPointer) < 128) ++debug[* a0.textPointer];
      } /* for all characters following -! */
#else
      fprintf
      ( stderr
      , " Compiled without debugging code. Option -! ineffective.\n"
      );
#endif
    ++a0.argIndex;
  }

  for ( (a0.argIndex); (a0.argIndex < a0.argc); (++a0.argIndex) )
  { /* for all arguments */
#ifdef DriverH
    fprintf ( stderr, "Word %d \"%s\".\n", a0.argIndex, a0.argVector[a0.argIndex] );
#endif

    if ( ( a0.argVector[a0.argIndex][0] != a0.keyTrigger )
    ||	 ( a0.keysTerminated != 0			 )
    ||	 ( a0.argVector[a0.argIndex][1] == '\0'          ) )
    { /* not a key: bubble up positional arguments */
      if
      (  ( a0.maxPositionals  >= 0 )
      && ( a0.nextPositional > a0.maxPositionals )
      )
      { /* if(too many positionals) */
	fprintf
	( stderr
	, " Stop. Maximum %d positional arguments, excess at \"%s\".\n"
	, a0.maxPositionals
	, a0.argVector[a0.argIndex]
	);
	ArgTutor( a0.tutorial );
      } /* if(too many positionals) */
      a0.keysTerminated |= a0.keysLeading;
      a0.argVector[a0.nextPositional] = a0.argVector[a0.argIndex];
      /* (void) */ (*a0.ptrFunction) ( '\0', a0.argVector[a0.nextPositional] );
      ++a0.nextPositional;
    }
    else /* it is a key */
    {
      a0.charIndex = 0;
      a0.keyPointer = & a0.argVector[a0.argIndex][0];
      do
      { /* for all characters in an argument */
	++a0.charIndex;
	++a0.keyPointer;
	if ( (*a0.keyPointer) == '\0' ) { break; } /* from do ... while */
#ifdef DriverH
	fprintf( stderr, "Remaining argument: \"%s\".\n", a0.keyPointer );
#endif

	if ( a0.keyPointer[0] == a0.keyTrigger )
	{
	  if ( a0.charIndex != 1 )
	  {
	    fprintf
	    ( stderr
	    , " Stop. Terminator of keys must be alone: \"%s\".\n"
	    , a0.argVector[a0.argIndex]
	    );
	    ArgTutor( a0.tutorial );
	  }
	  if ( a0.keyPointer[1] != '\0' )
	  {
	    fprintf
	    ( stderr
	    , " Stop. Terminator of keys followed by: \"%s\".\n"
	    , a0.argVector[a0.argIndex]
	    );
	    ArgTutor( a0.tutorial );
	  }
	  a0.keysTerminated = 1;
	}
	else
	{
	  switch ( a0.keyPointer[0] )
	  {
	  case '?':
	    ArgTutor( a0.tutorial );
	    exit( a0.argc != 2);

/* argloop.h: End of file. */
