/* argparse.h: @(#) macros for parsing command arguments. */
/* by Alexander B. Abacus */
/* Computer Language BBS file name ARGPARSE.H */
/* This and related files make a more portable version of ARGPAR.H */
/* related files: argparse.use, argbegin.h, argloop.h, argend.h */

#ifdef Hargsmall
   /* #endfile			-- this file already included */
#else				/* first inclusion */

#define Hargsmall
				/* and really include this file */
/*[ A.1 ] Required include. */

#ifndef FILE
#include <stdio.h>
#endif

/*[ A.2 ] Output tutorial information. */

/* void */ ArgTutor(line)
char ** line;
{
  for ( (line); ((*line) != (char *) 0); (++line) )
  {
    fprintf
    ( stderr
    , " %s"
    , *line
    );
  }
  exit(1);
}

/*[ A.3 ] Dummy function for processing positional arguments. */

static
char * argPos( a_keyChar, a_argString )
char   a_keyChar;
char * a_argString;
{
#ifdef DriverH
  fprintf ( stderr, "Argument" );
  if ( a_keyChar != '\0' )
  {
    fprintf ( stderr, " key-letter \'%c\'", a_keyChar );
  }
  if ( a_argString != (char *) 0 )
  {
    fprintf ( stderr, " text \"%s\"", a_argString );
  }
  fprintf ( stderr, ".\n" );
#endif
  return ( (char *) 0 );
}

/*[ B.1 ] Standard heading for main(). */

#define MAIN() main(argc, argv) int argc; char *argv[];

/*[ B.2 ] Optional macros to override defaults. */

#define ArgMin(A_Min)	       a0.minPositionals = (A_Min);
#define ArgMax(A_Max)	       a0.maxPositionals = (A_Max);
#define ArgPosCall(A_Function) a0.ptrFunction = (A_Function);
#define ArgKeyLeading	       a0.keysLeading = 1;
#define ArgTrigger(A_Trigger)  a0.keyTrigger = (A_Trigger);
#define ArgDescription(A_Text) a0.tutorial = (A_Text);

/*[ C.1 ] Key-letter flag argument, deferred processing. */

#define ArgFlagSet(A_KeyLetter, A_FlagCounter) case A_KeyLetter: ++A_FlagCounter; break;

/*[ C.2 ] Key-letter flag argument, immediate processing. */

#define ArgFlagCall(A_KeyLetter, A_FlagFunction) case A_KeyLetter: if (A_FlagFunction ( *a0.keyPointer, (char *) 0 ) != (char *) 0 ) { ArgTutor( a0.tutorial ); } break;


/*[ C.3 ] Key-letter text argument, deferred processing. */

#define ArgTextSet(A_KeyLetter, A_TextPointer) case A_KeyLetter: argText ( & A_TextPointer, & a0.keyPointer, & a0.argIndex,a0.charIndex, a0.keyTrigger, a0.argc, a0.argVector,a0.tutorial, A_KeyLetter, 0); break;

/*[ C.4 ] Key-letter text argument, immediate processing. */

#define ArgTextCall(A_KeyLetter, A_TextFunction) case A_KeyLetter: argText ( & a0.textPointer, & a0.keyPointer, & a0.argIndex, a0.charIndex, a0.keyTrigger, a0.argc, a0.argVector, a0.tutorial, A_KeyLetter, A_TextFunction); break;

/*[ D.2 ] Function common for key-letter text arguments. */

static /* void */ argText
( a_textPointer
, a_keyPointer
, a_argIndex
, a_charIndex
, a_keyTrigger
, a_argc
, a_argv
, a_tutorial
, a_keyLetter
, a_textFunction
)
char ** a_textPointer;
char ** a_keyPointer;
int *	a_argIndex;
int	a_charIndex;
char	a_keyTrigger;
int	a_argc;
char *	a_argv[];
char *	a_tutorial[];
char	a_keyLetter;
char *	(*a_textFunction) ();
{ /* argText() */
  if ( a_textFunction == 0 )
  { /* ArgTextSet */
    if ( (* a_textPointer) != (char *) 0 )
    { /* second occurance of this key letter */
      fprintf
      ( stderr
      , " Stop. Repeated key-letter '%c' with text.\n"
      , a_keyLetter
      );
      ArgTutor( a_tutorial );
    } /* second occurance of this key letter */
  } /* ArgTextSet */

  if ( a_charIndex != 1 )
  {
    fprintf
    ( stderr
    , " Stop. Key letter with text must stand alone: \"%s\".\n"
    , a_argv[*a_argIndex]
    );
    ArgTutor( & a_tutorial[0] );
  }
  else if ( ( (*a_keyPointer)[1]) != '\0' )
  { /* text following key letter without a separating white space */
    (*a_textPointer) = (char *) & (*a_keyPointer)[1];
  }
  else /* text must be in the following argument */
  {
    ++(*a_argIndex);
    if ( ((*a_argIndex) >= a_argc)
    ||	 (a_keyTrigger == *a_argv[*a_argIndex]) )
    { /* text is missing */
      fprintf
      ( stderr
      , " Stop. Text not found after key letter \"%s\".\n"
      , *a_keyPointer
      );
      --(*a_argIndex);
      ArgTutor( & a_tutorial[0] );
    }
    else
    {
      (*a_textPointer) = (char *) a_argv[*a_argIndex];
    } /* endif */
  } /* endif */

  if ( a_textFunction != 0 )
  { /* ArgTextCall */
    if((*a_textFunction) ( a_keyLetter, (* a_textPointer) ) != (char *) 0 )
    {
      ArgTutor( a_tutorial );
    }
  } /* ArgTextCall */

  (*a_keyPointer) = (char *) 0;       /* to skip to next element of argv */

  return;
} /* argText() */

/* --------------------------------------------------------------- */

#ifdef DriverH

/* T.1: Test driver for this include. */

static char * tutorial[] =
{
"Expected arguments are: file1 file2 \n",
"   file1 is the source, \n",
"   file2 is the target. \n",
0
};

main(argCount, argVector)
int    argCount;
char * argVector[];
{
  int	 f_flag = 0;
  char	*t_text = (char *) 0;

#define ArgCount  argCount
#define ArgVector argVector
#include <argbegin.h>
  ArgMin	(1)
  ArgMax	(2)
  ArgDescription(tutorial)
#include <argloop.h>
  ArgFlagSet  ('f', f_flag)
  ArgFlagCall ('F', argPos)
  ArgTextSet  ('t', t_text)
  ArgTextCall ('T', argPos)
#include <argend.h>

  fprintf ( stderr, "Flag counter: %d.\n", f_flag );
  if ( t_text != (char *) 0 )
  {
    fprintf ( stderr, "Text: \"%s\".\n", t_text );
  }

  exit (0);
} /* main */

#endif

#endif

/* argparse.h: End of file. */
