/*****************************************************************************

   PROGRAM:    TLTEST - MDI Test Application for TLCLASS.DLL
               (C) Copyright 1992, Lindley Enterprises

   SOURCE:     TLTEST.H

   PURPOSE:    

   COMMENTS:

*****************************************************************************/

#ifndef TLTEST_H
#define TLTEST_H

#ifndef RC_INVOKED
#include <bchkbox.h>
#include <bgrpbox.h>
#include <edit.h>

#include "tlclass.h"
#endif

#define  IDS_BASE        (0x100)

#define  IDS_VERSION     (IDS_BASE)

#define  IDM_SHOWBAR     (IDS_BASE+0x10)
#define  IDM_SWITCH      (IDS_BASE+0x11)
#define  IDM_STATUS      (IDS_BASE+0x12)
#define  IDM_BTNTGL      (IDS_BASE+0x13)

#define  ID_STATTEXT     (IDS_BASE+0x20)
#define  ID_TIMED        (IDS_BASE+0x21)
#define  ID_GRPBOX       (IDS_BASE+0x22)
#define  ID_CARBUTTON    (IDS_BASE+0x23)

#define  ID_TOOLBAR1     (IDS_BASE+0x31)
#define  ID_TOOLBAR2     (IDS_BASE+0x32)
#define  ID_TOOLBAR3     (IDS_BASE+0x33)

#define  WM_SHOWBAR      (WM_USER+1)
#define  WM_SWITCH       (WM_USER+2)

typedef BI_IArrayAsVector<TCellText>  lTextWnd;
typedef lTextWnd far                 *PlTextWnd;

class TMDIApp : public TApplication
{
   public:
      TMDIApp( LPSTR name,  HINSTANCE hInstance, HINSTANCE hPrevInstance,
               LPSTR lpCmd, int       nCmdShow)
         :TApplication( name, hInstance, hPrevInstance, lpCmd, nCmdShow )
         {};
      virtual void InitMainWindow();
};

_CLASSDEF( TMyMDIFrame )
class TMyMDIFrame : public TMDIFrame
{
   public:
      TMyMDIFrame( LPSTR ATitle, LPSTR MenuName );
      ~TMyMDIFrame();
      virtual PTWindowsObject InitChild();
      virtual void            WMSize( RTMessage Msg );
      void                    DemoBar( RTMessage Msg ) = [CM_FIRST+IDM_SHOWBAR];
      void                    DemoSwitch( RTMessage Msg ) = [CM_FIRST+IDM_SWITCH];
      void                    ChangeStatus( RTMessage Msg ) = [CM_FIRST+IDM_STATUS];
      void                    SetStatus( LPSTR lpText, BOOL bDelete );
      void                    ToolBar1( RTMessage Msg ) = [ID_FIRST+ID_TOOLBAR1];
      void                    ToolBar2( RTMessage Msg ) = [ID_FIRST+ID_TOOLBAR2];
      void                    ToolBar3( RTMessage Msg ) = [ID_FIRST+ID_TOOLBAR3];

   private:
      UINT          ChildNum;
      PTStatusLine  pStatus;
      PTToolBar     pToolBar;
};

class  TMyWindow : public TBWindow
{
   public:
      TMyWindow( PTMyMDIFrame AParent, LPSTR ATitle );
      ~TMyWindow();
      virtual void  SetupWindow();
      virtual void  Paint( HDC, PAINTSTRUCT& );
      virtual void  WMLButtonDown( RTMessage Msg );
      virtual void  WMLButtonUp( RTMessage Msg )  = [WM_FIRST+WM_LBUTTONUP];
      virtual void  WMMouseMove( RTMessage Msg )  = [WM_FIRST+WM_MOUSEMOVE];
      void          ShowBar( RTMessage Msg )      = [WM_FIRST+WM_SHOWBAR];
      void          ShowSwitch( RTMessage Msg )   = [WM_FIRST+WM_SWITCH];
      void          ToggleButton( RTMessage Msg ) = [CM_FIRST+IDM_BTNTGL];
      void          CarButton( RTMessage Msg )    = [CM_FIRST+ID_CARBUTTON];

   private:
      PTMyMDIFrame   pParent;
      PlTextWnd      pActive;
      lTextWnd       lScreen1;
      lTextWnd       lScreen2;
      PTSlideBar     pSBar;
      PTCellButton   pCarButton;
      PTLButton      pNrmButton;
};

_CLASSDEF( TMyDialog )
class TMyDialog : public TDialog
{
   public:
      TMyDialog( PTWindowsObject AParent, PTMyMDIFrame pMyParent );
      ~TMyDialog();
      virtual void  SetupWindow();
      virtual void  Ok( RTMessage Msg );

   private:
      PTMyMDIFrame  pParent;
      PTEdit        pEditText;
      PTBCheckBox   pCheckBox;
      PTBGroupBox   pGroup;
};

#endif
