/*****************************************************************************

   PROGRAM:    TLCLASS - Header File
               (C) Copyright 1992, Lindley Enterprises

   SOURCE:     TCLASS.H

   PURPOSE:    

   COMMENTS:

*****************************************************************************/

#ifndef TLCLASS_H
#define TLCLASS_H

#ifndef RC_INVOKED
#include <ldate.h>
#include <strng.h>
#include <string.h>
#include <bwindow.h>
#include <bbutton.h>
#endif

#define  STAT_TIMER          (0x1234)
#define  STAT_TIMERINT       (7)
#define  STAT_ONESECOND      (1000)

#define  SH_LEFT             (0x0000)
#define  SH_CENTER           (0x0001)
#define  SH_RIGHT            (0x0002)
#define  SH_INDENT           (0x0004)
#define  SH_RAISE            (0x0008)
#define  SH_NORMAL           (0x0010)

#define  TB_LEFT             (0x0001)
#define  TB_TOP              (0x0010)
#define  TB_RIGHT            (0x0100)
#define  TB_BASERESOURCE     (1775)
#define  TB_NUMBUTTONS       (20)

#define  WM_STATINIT         (WM_USER+10)

#define  MAX_COLORS          (16)
#define  VGA_BLACK           RGB(  0,  0,  0)
#define  VGA_DKRED           RGB(128,  0,  0)
#define  VGA_DKGREEN         RGB(  0,128,  0)
#define  VGA_TAN             RGB(128,128,  0)
#define  VGA_DKBLUE          RGB(  0,  0,128)
#define  VGA_DKPURPLE        RGB(128,  0,128)
#define  VGA_BLUEGREY        RGB(  0,128,128)
#define  VGA_DKGREY          RGB(128,128,128)
#define  VGA_LTGREY          RGB(192,192,192)
#define  VGA_RED             RGB(255,  0,  0)
#define  VGA_GREEN           RGB(  0,255,  0)
#define  VGA_YELLOW          RGB(255,255,  0)
#define  VGA_BLUE            RGB(  0,  0,255)
#define  VGA_MAGENTA         RGB(255,  0,255)
#define  VGA_CYAN            RGB(  0,255,255)
#define  VGA_WHITE           RGB(255,255,255)

#define  IDS_BASE            (0x100)

#define  IDS_VERSION         (IDS_BASE)

#define  IDS_DAY_SUN         (IDS_BASE+0x10)  /* %^Sun^ */
#define  IDS_DAY_MON         (IDS_BASE+0x11)  /* %^Mon^ */
#define  IDS_DAY_TUE         (IDS_BASE+0x12)  /* %^Tue^ */
#define  IDS_DAY_WED         (IDS_BASE+0x13)  /* %^Wed^ */
#define  IDS_DAY_THU         (IDS_BASE+0x14)  /* %^Thu^ */
#define  IDS_DAY_FRI         (IDS_BASE+0x15)  /* %^Fri^ */
#define  IDS_DAY_SAT         (IDS_BASE+0x16)  /* %^Sat^ */

#define  IDS_SUNDAY          (IDS_BASE+0x20)  /* %^Sunday^    */
#define  IDS_MONDAY          (IDS_BASE+0x21)  /* %^Monday^    */
#define  IDS_TUESDAY         (IDS_BASE+0x22)  /* %^Tuesday^   */
#define  IDS_WEDNESDAY       (IDS_BASE+0x23)  /* %^Wednesday^ */
#define  IDS_THURSDAY        (IDS_BASE+0x24)  /* %^Thursday^  */
#define  IDS_FRIDAY          (IDS_BASE+0x25)  /* %^Friday^    */
#define  IDS_SATURDAY        (IDS_BASE+0x26)  /* %^Saturday^  */

#define  IDS_JANUARY         (IDS_BASE+0x30)  /* %^January^   */
#define  IDS_FEBRUARY        (IDS_BASE+0x31)  /* %^February^  */
#define  IDS_MARCH           (IDS_BASE+0x32)  /* %^March^     */
#define  IDS_APRIL           (IDS_BASE+0x33)  /* %^April^     */
#define  IDS_MAY             (IDS_BASE+0x34)  /* %^May^       */
#define  IDS_JUNE            (IDS_BASE+0x35)  /* %^June^      */
#define  IDS_JULY            (IDS_BASE+0x36)  /* %^July^      */
#define  IDS_AUGUST          (IDS_BASE+0x37)  /* %^August^    */
#define  IDS_SEPTEMBER       (IDS_BASE+0x38)  /* %^September^ */
#define  IDS_OCTOBER         (IDS_BASE+0x39)  /* %^October^   */
#define  IDS_NOVEMBER        (IDS_BASE+0x3A)  /* %^November^  */
#define  IDS_DECEMBER        (IDS_BASE+0x3B)  /* %^December^  */

#define  IDS_READY           (IDS_BASE+0x40)  /* %^Ready^ */

int far _export  GetTLClassVersion( LPSTR lpVersion, WORD wMax );

_CLASSDEF( TJulianDate )
class _EXPORT  TJulianDate : public Date
{
   public:
      TJulianDate();
      TJulianDate( BYTE Month, BYTE Day, UINT Year );
      TJulianDate( const Date& BD );
      TJulianDate( LPSTR lpCurDay );
      long    GetJulianDate();
      void    SetJulianDate( LONG lDate );
      UINT    GetMonthName( LPSTR szMonthName, UINT uMax );
      UINT    GetDayName( LPSTR szDayName, UINT uMax );
      UINT    GetDayOfWeek();
      UINT    GetDateString( LPSTR szDateStr, UINT uMax );
};

_CLASSDEF( TCellWnd )
class _EXPORT  TCellWnd
{
   public:
      TCellWnd( UINT uXPos, UINT uYPos, UINT uWidth, UINT uHeight, UINT uType = SH_INDENT );
      virtual void    Paint( HDC hDC );
      virtual void    ForcePaint( HWND hWnd );
      void            Indent( HDC hDC );
      void            Raise( HDC hDC );
      BOOL            NeedsPaint( LPRECT pRect );
      BOOL            HitTest( UINT uXPos, UINT uYPos );
      void            GetRect( LPRECT lpRect );
      void            SetRect( LPRECT lpRect, HWND hWnd );
      UINT            GetXStart() const                { return( uXStart ); };
      UINT            GetYStart() const                { return( uYStart ); };
      UINT            GetXEnd() const                    { return( uXEnd ); };
      UINT            GetYEnd() const                    { return( uYEnd ); };
      UINT            GetWidth()                 { return( uXEnd-uXStart ); };
      UINT            GetHeight()                { return( uYEnd-uYStart ); };
      void            SetWidth( UINT uNWidth ) { uXEnd = uXStart+uNWidth+1; };
      void            SetHeight( UINT uNHght )  { uYEnd = uYStart+uNHght+1; };
      void            SetType( UINT uType )               { uState = uType; };
      COLORREF        GetBackColor()                { return( cBackColor ); };
      BOOL            IsSortable()                         { return(FALSE); };
      int operator == ( const TCellWnd& sWnd ) const
        { return( (sWnd.uYStart == uYStart) && (sWnd.uXStart == uXStart) ); };

   private:
      BOOL            IsXBetween( UINT uBegin, UINT uEnd );
      BOOL            IsYBetween( UINT uBegin, UINT uEnd );
      UINT            uXStart;
      UINT            uYStart;
      UINT            uXEnd;
      UINT            uYEnd;
      UINT            uState;
      COLORREF        cBackColor;
};

_CLASSDEF( TCellText )
class _EXPORT  TCellText : public TCellWnd
{
   public:
      TCellText( UINT uXPos, UINT uYPos, UINT uWidth, UINT uHeight, LPSTR lpTitle = NULL );
      TCellText( UINT uXPos, UINT uYPos, UINT uWidth, UINT uHeight, int iNewNum = 0 );
      TCellText( UINT uXPos, UINT uYPos, UINT uWidth, UINT uHeight, float fNewNum = 0.0 );
      ~TCellText();
      virtual void  Paint( HDC hDC );
      void          SetText( LPSTR lpNewText );
      void          SetMask( LPSTR lpNewMask );
      void          SetInt( int iNewNum );
      void          SetFloat( float fNewNum );
      void          SetColor( COLORREF cColor )      { cTextColor = cColor; };
      void          SetAlignment( UINT uAlign )      { uAlignment = uAlign; };
      void          SetFont( HFONT hNewFont )       { hCharFont = hNewFont; };
      int           GetInt()                           { return( iNumber ); };
      float         GetFloat()                         { return( fNumber ); };
      void          GetText( LPSTR lpData, UINT uMax )
                                         { strncpy( lpData, *pText, uMax ); };
      BOOL          IsSortable()                           { return(FALSE); };
      int operator == ( const TCellText& sText ) const
{return((sText.GetYStart()==GetYStart())&&(sText.GetXStart()==GetXStart()));};

   private:
      char          szMask[21];
      int           iNumber;
      float         fNumber;
      BOOL          bInteger;
      PString       pText;
      HFONT         hCharFont;
      UINT          uAlignment;
      COLORREF      cTextColor;
};

_CLASSDEF( TCellButton )
class _EXPORT  TCellButton : public TCellWnd
{
   public:
      TCellButton( UINT uXPos, UINT uYPos, UINT uRID, LPSTR lpNormal, LPSTR lpDisabled );
      TCellButton( UINT uXPos, UINT uYPos, UINT uRID, HBITMAP hNrm, HBITMAP hDis );
      ~TCellButton();
      virtual void  Paint( HDC hDC );
      void          Disable( HWND hParent );
      void          Enable( HWND hParent );
      BOOL          MouseMove( HWND hParent, UINT uXPos, UINT uYPos );
      BOOL          MouseDown( HWND hParent, UINT uXPos, UINT uYPos );
      BOOL          MouseUp( HWND hParent, UINT uXPos, UINT uYPos );
      BOOL          IsDown()                             { return( bDown ); };
      BOOL          IsDisabled()                     { return( bDisabled ); };
      BOOL          IsSortable()                           { return(FALSE); };
      int operator == ( const TCellButton& sText ) const
{return((sText.GetYStart()==GetYStart())&&(sText.GetXStart()==GetXStart()));};

   private:
      HBITMAP   hNormal;
      HBITMAP   hDisabled;
      BOOL      bDown;
      BOOL      bDisabled;
      BOOL      bDrawUp;
      BOOL      bCaptured;
      UINT      uResourceID;
      int       iWidth;
      int       iHeight;
};

_CLASSDEF( TStatusLine )
class _EXPORT  TStatusLine : public TBWindow
{
   public:
      TStatusLine( PTMDIFrame AFrame );
      TStatusLine( PTWindow AParent );
      ~TStatusLine();
      virtual void    Paint( HDC hDC, PAINTSTRUCT& sPaint );
      virtual void    SetupWindow();
      void            ResizeStatus();
      void            MoveChildren();
      void            SetText( LPSTR lpText, BOOL bEraseText );
      void            TimerMsg( RTMessage Msg ) =         [WM_FIRST+WM_TIMER];
      void            SetTextColor( COLORREF cNewColor );
      void            SetDateColor( COLORREF cNewColor );
      void            SetTimeColor( COLORREF cNewColor );
      void            GetDate( LPSTR lpDate, UINT uMax )
                                    { pDateWindow->GetText( lpDate, uMax ); };
      void            GetTime( LPSTR lpTime, UINT uMax )
                                    { pTimeWindow->GetText( lpTime, uMax ); };
      void            GetText( LPSTR lpData, UINT uMax )
                                 { pMessageWindow->GetText( lpData, uMax ); };
      WORD            GetHeight()                { return( uCharHeight+5 ); };

   private:
      BOOL            bIsMDIStatus;
      HWND            hParent;
      PTMDIFrame      pMDIParent;
      PTMDIClient     pMDIClient;
      PTWindow        pParent;
      HFONT           hTextFont;
      UINT            uCharHeight;
      UINT            uCharWidth;
      BOOL            bErase;
      UINT            uCount;
      UINT            uTimer;
      PTCellText      pTimeWindow;
      PTCellText      pDateWindow;
      PTCellText      pMessageWindow;
};

_CLASSDEF( TToolBar )
class _EXPORT  TToolBar : public TBWindow
{
   public:
      TToolBar( PTMDIFrame AFrame, UINT uW, UINT uBW, UINT uBH, UINT uBS, UINT uTS, PTStatusLine pStat=NULL );
      TToolBar( PTWindow AParent, UINT uW, UINT uBW, UINT uBH, UINT uBS, UINT uTS, PTStatusLine pStat=NULL );
      ~TToolBar();
      virtual void    Paint( HDC hDC, PAINTSTRUCT& sPaint );
      virtual void    SetupWindow();
      virtual void    WMCommand( RTMessage Msg );
      virtual void    WMLButtonDown( RTMessage Msg );
      void            WMLButtonUp( RTMessage Msg )  = [WM_FIRST+WM_LBUTTONUP];
      void            WMMouseMove( RTMessage Msg )  = [WM_FIRST+WM_MOUSEMOVE];
      void            ResizeToolBar();
      UINT            GetWidth()     { return( uTSpace*2+uBWidth+uYFrame ); };
      UINT            GetHeight()   { return( uTSpace*2+uBHeight+uXFrame ); };
      void            SetButton( UINT uIndex, LPSTR lpNormal, LPSTR lpDisabled, UINT uRID );
      void            SetButton( UINT uIndex, HBITMAP hNormal, HBITMAP hDisabled, UINT uRID );

   private:
      PTMDIFrame      pMDIParent;
      HWND            hParent;
      BOOL            bIsMDIToolBar;
      PTMDIClient     pMDIClient;
      PTWindow        pParent;
      PTStatusLine    pStatus;
      UINT            uWhere;
      UINT            uBWidth;
      UINT            uBHeight;
      UINT            uBSpace;
      UINT            uTSpace;
      UINT            uXFrame;
      UINT            uYFrame;
      PTCellButton    pButtons[TB_NUMBUTTONS];
      UINT            uRIDs[TB_NUMBUTTONS];
};

_CLASSDEF( TSlideBar )
class _EXPORT  TSlideBar : public TBWindow
{
   public:
      TSlideBar( PTWindowsObject AParent, UINT uXPos, UINT uYPos, UINT uWidth, UINT uHeight, UINT uRng = 100 );
      void          ShowWnd();
      void          HideWnd();
      void          SetPos( UINT uPos );
      void          SetRange( UINT uRng = 100 );
      UINT          GetRange()                          { return( uRange ); };
      UINT          GetPos()                           { return( uCurPos ); };
      void          IncPos( UINT uInc = 1 );
      virtual void  Paint( HDC hDC, PAINTSTRUCT& pStruct );

   private:
      UINT          uRange;
      UINT          uCurPos;
};

_CLASSDEF( TShadeWnd )
class _EXPORT  TShadeWnd : public TBWindow
{
   public:
      TShadeWnd( PTWindowsObject AParent, LPSTR ATitle, UINT uXPos, UINT uYPos, UINT uWidth, UINT uHeight, UINT uStyle );
      ~TShadeWnd();
      virtual void  Paint( HDC hDC, PAINTSTRUCT& pStruct );
      virtual void  SetCaption( LPSTR szCaption );
      void          SetColor( COLORREF cColor );
      void          Indent( HDC hDC );
      void          Raise( HDC hDC );
      BOOL          IsSortable()                           { return(FALSE); };
      int operator == ( const TShadeWnd& sSWnd ) const
                                      { return( sSWnd.HWindow == HWindow ); };
   private:
      UINT          uStatStyle;
      COLORREF      cTextColor;
      PString       pText;
};

_CLASSDEF( TLButton )
class _EXPORT TLButton : public TButton
{
   public:
      TLButton( PTWindowsObject AParent, int iResourceID,
                int X, int Y, int W, int H, BOOL IsDefault,
                LPSTR AUpButton, LPSTR ADownButton );
     ~TLButton();

   protected:
      virtual void ODADrawEntire( DRAWITEMSTRUCT _FAR & DrawInfo );
      virtual void ODASelect( DRAWITEMSTRUCT _FAR & DrawInfo );

   private:
      HBITMAP  hBtnUp;
      HBITMAP  hBtnDown;
      int      iWidth;
      int      iHeight;
};

#endif
