/**************************************************************
 * newpaper.c                                                 *
 *  7/28/90 by Jim Button                                     *
 * 12/10/92 by Michael Caldwell                               *
 *------------------------------------------------------------*
 * Updates WIN.INI Wallpaper specification to point to the    *
 *   to the next BMP file in the windows subdirectory.        *
 *                                                            *
 *                                                            *
 * This hardly looks like a Windows program. The traditional  *
 *   message loop is not even needed, since it does no input, *
 *   has no output, and terminates almost before it starts!   *
 **************************************************************/
#include <windows.h>
#include <dir.h>
#include <string.h>

#define MaxFName 13


int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdLine,
                   int nCmdShow) {
  
char oldbmp[MaxFName],
     firstbmp[MaxFName],
     newbmp[MaxFName],
     tiled[2];
int  done = 0;
struct ffblk dta;

  GetProfileString("Desktop", "WallPaper", "", oldbmp, MaxFName);
  strcpy(newbmp, "");                     /* in case no BMP files exist */
  strcpy(tiled, "1");

  /* Get the list of .BMP files */
  if (!findfirst("*.BMP", &dta, 0)) {     /* find first BMP */
    strcpy(firstbmp, dta.ff_name);

    while (!done) {                       /* look for the next BMP */
      if (findnext(&dta))
        break;                            /* if no more BMPs quit */
      done = (stricmp(dta.ff_name, oldbmp) > 0);
    }
    /* if no more BMPs then use first else use next */
    strcpy(newbmp, (!done) ? firstbmp : dta.ff_name);
    strlwr(newbmp);

    /* if filesize < 100K, use "tiled" */
    if (!(dta.ff_fsize < 100000))
      strcpy(tiled, "0");
  }

  /* update WIN.INI */
  WriteProfileString("Desktop", "WallPaper", newbmp);
  WriteProfileString("Desktop", "TileWallPaper", tiled);

  return(FALSE);
}
