//FILE:: logo.cpp
/* 
   Diplays a bitmap as a SplashScreen.
   This example posts a message to itself and uses Windows API,
   GetTickCount, to turn off splash screen. The main Window is
   initially hidden and then shown when splashcreen is destroyed.
*/
  

#define STRICT
#define WIN31

#include <owl.h>
#include <static.h>
#include <bwcc.h>
#include <windowsx.h>


_CLASSDEF( TApp )
_CLASSDEF( TMainWindow )
_CLASSDEF( TStatusDlg  )


#define WM_SHOWSTATDLG  ( WM_USER + 100 )

// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
class TApp : public TApplication
{
    public:
        TApp( LPSTR AName, HINSTANCE hInstance, HINSTANCE hPrevInstance,
              LPSTR lpCmdLine, int nCmdShow) :
        TApplication(AName, hInstance, hPrevInstance,
                     lpCmdLine, nCmdShow)
        {};
        virtual void InitMainWindow();
        virtual void Yield( void );
};



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
class TMainWindow : public TWindow
{
        PTStatusDlg dlgPtr;
        static char szClassName[];
    public:
        TMainWindow( PTWindowsObject AParent, LPSTR ATitle,
                     PTModule AModule = NULL );
        virtual void GetWindowClass( WNDCLASS &AWndClass );

	virtual void SetupWindow();
        virtual void ShowCountDown( int );

        LPSTR  GetClassName()
        {   return( szClassName );   }

        virtual void ShowStatusDlg( RTMessage ) = [WM_FIRST+WM_SHOWSTATDLG];
};
char TMainWindow::szClassName[] = "!App!ClassName";



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
class TStatusDlg : public TDialog
{
	    PTStatic pStat;
    public:
        TStatusDlg( PTWindowsObject AParent, LPSTR AName ):
        TDialog( AParent, AName )
	    {  pStat = new TStatic( this, 200, 0 );  }

        void ShowMsg( char *str )
	    {  pStat ->SetText( str );  }

        virtual void SetupWindow( void );
        virtual void WMDestroy( RTMessage ) = [WM_FIRST+WM_DESTROY];
};



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
void TStatusDlg::SetupWindow()
{
    TDialog::SetupWindow();
    EnableWindow( Parent->HWindow, FALSE );

    RECT rect;
    GetWindowRect( HWindow, &rect );
    OffsetRect( &rect, -rect.left, -rect.top );
    MoveWindow( HWindow,
                (( GetSystemMetrics( SM_CXSCREEN ) -
                   rect.right ) / 2 + 4 ) & ~7,
                 ( GetSystemMetrics( SM_CYSCREEN ) -
                   rect.bottom ) / 2,
                   rect.right, rect.bottom, 0 );
}



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
void TStatusDlg::WMDestroy( RTMessage msg )
{
    BringWindowToTop( Parent->HWindow );
    EnableWindow( Parent->HWindow, TRUE );
    // show our Parent, the main Window...
    ShowWindow( Parent->HWindow, SW_SHOW );
    TDialog::WMDestroy( msg );
}



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
void TApp::InitMainWindow()
{
    MainWindow = new TMainWindow( NULL, "Sample App" );
}



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
void TApp::Yield()
{
    MSG msg;
    while( PeekMessage( &msg, NULL, 0, 0, PM_REMOVE ) )
    {
        if ( !ProcessAppMsg( &msg ) )
        {
            TranslateMessage( &msg );
            DispatchMessage( &msg );
        }
    }
}



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
TMainWindow::TMainWindow( PTWindowsObject AParent, LPSTR ATitle,
                          PTModule AModule ):
TWindow( AParent, ATitle, AModule )
{
}



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
void TMainWindow::GetWindowClass( WNDCLASS _FAR & AWndClass )
{
    TWindow::GetWindowClass( AWndClass );
    AWndClass.lpszClassName = szClassName;
}



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
void TMainWindow::SetupWindow()
{
    TWindow::SetupWindow();
    PostMessage( HWindow, WM_SHOWSTATDLG, 0, 0 );
}



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
void TMainWindow::ShowStatusDlg( RTMessage )
{
    dlgPtr = new TStatusDlg( this, "STATUSDIALOG" );

    if ( GetApplication()->MakeWindow( dlgPtr ) )
    {
        dlgPtr->Show( SW_SHOWNORMAL );
        EnableWindow( HWindow, FALSE );
        PTApp( GetApplication() )->Yield();

        //
        // Insert any calls to processing routines here.
        // If the processes are time-consuming, the cursor should 
        // probably be changed to an hourglass and/or the processes 
        // must intemittently call 'PTApp( GetApplication() )->Yield()'.
        //

        ShowCountDown( 5 );     // Our *Initialization* routine //

        //
        // The following closes the status dialog which will reenable
        // the main window.  Note, that the dialog could have been closed
        // already though!
        //
        if ( IsWindow( dlgPtr->HWindow ) )
            PostMessage( dlgPtr->HWindow, WM_CLOSE, 0, 0 );
        else
        {
        //
        // Dialog was closed prematurely - i.e. User closed the dialog
        // to abort the process.  We'll beep to indicate this scenario.
        //
            MessageBeep( -1 );
        }
    }
}



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
void TMainWindow::ShowCountDown( int cnt )
{
    char buffer[20];
    DWORD dwTicks = GetTickCount();
    do {
        wsprintf( buffer, "Take Off in %d secs", cnt );
        dlgPtr->ShowMsg( buffer );
        if ( cnt )
            while ( GetTickCount() < dwTicks+1000 );
                PTApp( GetApplication() )->Yield();
        dwTicks += 1000;
    } while( cnt-- && IsWindow( dlgPtr->HWindow ) );
}



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpCmdLine, int nCmdShow)
{
    // change the ShowWindow style to initially Hide the main Window...
    nCmdShow = SW_HIDE;
    TApp App ( "Sample App", hInstance, hPrevInstance,
               lpCmdLine, nCmdShow);
    App.Run();
    BWCCGetVersion();
    return( App.Status );
}


