//  RT_DIAL.CPP  - Program to Test Creation of a Dialog Box at RunTime


#include <owl.h>
#include "ind_dial.h"
#include <button.h>
#include <checkbox.h>
#include <radiobut.h>
#include <groupbox.h>

const WORD ID_DOBUTTON = 101;
const WORD ID_DODIALOG = 102;
const WORD ID_DOEXIT   = 103;
const WORD ID_DIALBOX  = 200;
const WORD ID_GROUPBOX = 210;
const WORD ID_RBUTTONP = 211;
const WORD ID_RBUTTONW = 212;

int OutputDevice = 1;    // 1 is Window, 2 is Printer

class TTestApp : public TApplication
{
public:
  TTestApp(LPSTR AName, HINSTANCE hInstance, HINSTANCE hPrevInstance,
    LPSTR lpCmdLine, int nCmdShow)
    : TApplication(AName, hInstance, hPrevInstance, lpCmdLine, nCmdShow) {};
  virtual void InitMainWindow();
};

class TTestWindow : public TWindow
{
public:
  TButton *DoButton, *DoDialog, *DoExit;
  TTestWindow(PTWindowsObject AParent, LPSTR ATitle);
  virtual void HandleDoButtonMsg(RTMessage Msg)
    = [ID_FIRST + ID_DOBUTTON];
  virtual void HandleDoDialogMsg(RTMessage Msg)
    = [ID_FIRST + ID_DODIALOG];
  virtual void HandleDoExitMsg(RTMessage Msg)
    = [ID_FIRST + ID_DOEXIT];
};

class TTestDialog : public TIndDialog
{
public:
  TGroupBox *GroupBox;
  TRadioButton *RTButtonW, *RTButtonP;
  TTestDialog(PTWindowsObject AParent, HANDLE DialTemp, WORD iSize);
  virtual void HandleGroupBoxMsg(RTMessage Msg)
    = [ID_FIRST + ID_GROUPBOX];
  virtual void HandleRButtonWMsg(RTMessage Msg)
    = [ID_FIRST + ID_RBUTTONW];
  virtual void HandleRButtonPMsg(RTMessage Msg)
    = [ID_FIRST + ID_RBUTTONP];
};

TTestWindow::TTestWindow(PTWindowsObject AParent, LPSTR ATitle) :
  TWindow(AParent, ATitle)
{
  DoDialog = new TButton(this, ID_DODIALOG, "Select Device",
   100, 48, 100, 24, FALSE);
  DoButton = new TButton(this, ID_DOBUTTON, "Print Report",
   220, 48, 100, 24, FALSE);
  DoExit = new TButton(this, ID_DOEXIT, "Exit",
   340, 48, 40, 24, FALSE);
}

TTestDialog::TTestDialog(PTWindowsObject AParent, HANDLE hDTemplate, WORD iSize ) :
  TIndDialog(AParent, hDTemplate, iSize )
{
  GroupBox = new TGroupBox(this, ID_GROUPBOX, "Output Device",
    20, 10, 176, 90);
  RTButtonW = new TRadioButton(this, ID_RBUTTONW, "Print to Window",
    30, 30, 138, 24, GroupBox);
  RTButtonP = new TRadioButton(this, ID_RBUTTONP, "Print to Printer",
    30, 70, 138, 24, GroupBox);
  new TButton(this, IDOK, "OK", 70, 130, 60, 30, FALSE);
}

void TTestWindow::HandleDoExitMsg(RTMessage)
{
   SendMessage( HWindow, WM_CLOSE, 0, 0L );
}

void TTestWindow::HandleDoButtonMsg(RTMessage)
{

  DoButton->Show( SW_HIDE );
  DoDialog->Show( SW_HIDE );
  DoExit->Show( SW_HIDE );

  if( OutputDevice == 1 )
     MessageBox(HWindow, "Report Sent to Window", "Report", MB_OK);
  else
     MessageBox(HWindow, "Report Sent to Printer", "Report", MB_OK);

  DoButton->Show( SW_SHOWNORMAL );
  DoDialog->Show( SW_SHOWNORMAL );
  DoExit->Show( SW_SHOWNORMAL );

  return;
}

void TTestDialog::HandleGroupBoxMsg(RTMessage)
{
  if ( RTButtonP->GetCheck() == BF_CHECKED )
    OutputDevice = 2;
  else
    OutputDevice = 1;
}

void TTestDialog::HandleRButtonPMsg(RTMessage)
{
    return;
}

void TTestDialog::HandleRButtonWMsg(RTMessage)
{
    return;
}

void TTestWindow::HandleDoDialogMsg(RTMessage)
{
  HANDLE dtHeader;
  LPSTR dptr;
  DWORD baseUnits;
  WORD widthUnits, heightUnits, s;

  baseUnits = GetDialogBaseUnits();
  widthUnits = LOWORD( baseUnits );
  heightUnits = HIWORD( baseUnits );
  widthUnits /= 4;
  heightUnits /= 8;

  s = sizeof( DTHeader );
  dtHeader = GlobalAlloc( GMEM_MOVEABLE, (DWORD)s );
  dptr = (LPSTR)GlobalLock( dtHeader );

  (long)(((DTHeader *)dptr)->lStyle)     = WS_POPUP | WS_DLGFRAME;
  (BYTE)(((DTHeader *)dptr)->bItemCount) = 0;
  (WORD)(((DTHeader *)dptr)->X)          = 200 / widthUnits;
  (WORD)(((DTHeader *)dptr)->Y)          = 140 / heightUnits;
  (WORD)(((DTHeader *)dptr)->CX)         = 210 / widthUnits;
  (WORD)(((DTHeader *)dptr)->CY)         = 180 / heightUnits;
  (char)(((DTHeader *)dptr)->lpszMenuName) =  0x00;    // No Menu
  (char)(((DTHeader *)dptr)->lpszClassName) =  0x00;   // Default Class
  (char)(((DTHeader *)dptr)->lpszCaptionText) =  0x00; // No Caption

  GlobalUnlock( dtHeader );

  GetApplication()->ExecDialog(new TTestDialog(this, dtHeader, s ));

  GlobalFree( dtHeader );
}

void TTestApp::InitMainWindow()
{
  MainWindow = new TTestWindow(NULL, Name);
}


int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
  LPSTR lpCmdLine, int nCmdShow)
{

  nCmdShow = SW_SHOWMAXIMIZED;
  TTestApp TestApp("Indirect Dialog Tester", hInstance, hPrevInstance,
    lpCmdLine, nCmdShow);
  TestApp.Run();
  return TestApp.Status;
}
