// ObjectWindows - (C) Copyright 1992 by Borland International

/* --------------------------------------------------------
  IND_DIAL.CPP
  Defines type TIndDialog.  This defines the basic
  behavior of all dialogs created by Indirect Call
  -------------------------------------------------------- */

#include "ind_dial.h"
#include <string.h>

extern PTWindowsObject DlgCreationWindow;

/* Constructor for a TIndDialog. Uses the contents of the memory pointed to
   by the Global Handle hDTemplate as the memory template for the Indirect
   Dialog Box generation.  A local copy of the template is made so that
   the programmer may free the external copy immediately after the object
   is instantiated.  iSize contains the size in bytes of the Template.  See
   IND_DIAL.H for the Template Structure Information.  */
TIndDialog::TIndDialog(PTWindowsObject AParent, HANDLE hDTemplate, WORD iSize,
		       PTModule AModule) : TDialog(AParent, -1, AModule)
{
   void far *gp, *gpp;

   hDialogTemplate = GlobalAlloc( GMEM_MOVEABLE, (DWORD)iSize );
   gp = GlobalLock( hDialogTemplate );
   gpp = GlobalLock( hDTemplate );

   _fmemcpy( gp, gpp, iSize );

   GlobalUnlock( hDialogTemplate );
   GlobalUnlock( hDTemplate );
}

/* Destructor for a TIndDialog. ~TWindowsObject frees the instance
   thunk. */
TIndDialog::~TIndDialog()
{
  if ( hDialogTemplate ) 
    hDialogTemplate = GlobalFree( hDialogTemplate );
}

static BOOL RegisterFails(void *AWindowsObject, void *)
{
  return !((PTWindowsObject)AWindowsObject)->Register();
}

/* Creates an MS-Windows modal dialog.  Associates the modal dialog
  interface element with the TDialog.  Creation and association is not
  attempted if the Status data member is non-zero. */
int TIndDialog::Execute()
{
  HWND HParent;
  int ReturnValue = -1;
  PTWindowsObject OldKBHandler;

  IsModal = TRUE;
  if ( Status == 0  && Register() )
  {
    DisableAutoCreate();

    /* Enable the keyboard handler. Although modal dialogs do
        their own keyboard handling, we use the WB_KBHANDLER
        flag for WM_COMMAND processing. */
    EnableKBHandler();
    if ( GetApplication() )
      OldKBHandler = GetApplication()->KBHandlerWnd;

    if ( !Parent )
      HParent = 0;
    else
      HParent = Parent->HWindow;
    DlgCreationWindow = this;
    /* Register all the dialog's child objects (for custom control
       support) */
    if ( FirstThat(RegisterFails, NULL) == NULL )
    {
      ReturnValue = DialogBoxIndirectParam(GetModule()->hInstance, hDialogTemplate,
                                HParent, (DLGPROC)GetInstance(), Attr.Param);
      // -1 if the function cannot create the dialog box
      if ( ReturnValue == -1)
        Status = EM_INVALIDWINDOW;
    }
    else
      Status = EM_INVALIDCHILD;
    DlgCreationWindow = NULL;
    if ( GetApplication() )
      GetApplication()->SetKBHandler(OldKBHandler);
  }
  if ( Status == 0 )
    delete this;
  else
      if (ReturnValue != -1)
          ReturnValue = BAD_DIALOG_STATUS;  // dialog ran, but status != 0
  return ReturnValue;
}

TStreamable *TIndDialog::build()
{
  return new TIndDialog(streamableInit);
}

TStreamableClass RegIndDialog("TIndDialog", TIndDialog::build,
					    __DELTA(TIndDialog));
