//****************************************************************************
// File: about.c
//
// Purpose : Called by DoCommands() when want About dialog box.
//
// Functions:
//    AboutDlg() - dialog function for about box
//
// Development Team:
//
//
// Written by Microsoft Product Support Services, Windows Developer Support
// COPYRIGHT:
//
//   (C) Copyright Microsoft Corp. 1993.  All rights reserved.
//
//   You have a royalty-free right to use, modify, reproduce and
//   distribute the Sample Files (and/or any modified version) in
//   any way you find useful, provided that you agree that
//   Microsoft has no warranty obligations or liability for any
//   Sample Application Files which are modified.
//
//****************************************************************************

#include <windows.h>
#include "about.h"

//****************************************************************************
// Function: AboutDlg
//
// Purpose: Called by DoCommands() when want About dialog box.
//
// Parameters:
//    hDlg    == Handle to _this_ window.
//    message == Message to process.
//    wParam  == WORD parameter -- depends on message
//    lParam  == LONG parameter -- depends on message
//
// Returns: Depends on message.
//
// Comments:
//
// History:  Date       Author        Reason
//           1/27/92                  Created
//****************************************************************************

BOOL FAR PASCAL AboutDlg (HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
   switch (msg)
   {
      case WM_INITDIALOG:
         return (TRUE);

      case WM_COMMAND:
         if ((wParam == IDOK) ||       // "OK" box selected?        
             (wParam == IDCANCEL))     // System menu close command?
         {
            EndDialog(hDlg, TRUE);     // Exits the dialog box 
            return (TRUE);
         }
         break;
   }

   return (FALSE); // Didn't process a message
}
