/*
   DIFFER :
   This program was written to help with differentiation. It accepts
   algebraic expressions with support for a number of functions and will
   differentiate the expression with respect to x. A documentation file
   is included, as is an example of how to set the program up with a list
   of expressions and run it from a batch file.

   This program was written by Paul Young, using Turbo C++.
   I accept no responsibility for use or misuse of this program in any way.
   This program is Public Domain.
   It may be copied freely provided this notice is included.
   This program may be used as a base or included in other programs
   however these programs must also be Public Domain and no monetary gain
   should be made from these. Help support Public Domain programming.
   P Young, 101716.3323@compuserve.com
*/

#include "differ.h"

#define BACKSPACE 8
#define ENTER 13

struct expression *topexpress;

typedef enum{QUIT,SIMPLIFY,PRINT,DIFF,INPUT,EXPR,GO,AGAIN,BATCH,ERRORINP} symbol;

/*
  Here is our list of commands.
*/

struct sorders
{ char *name;
  symbol command;
} orders[] =
{  {"quit",QUIT},
   {"simplify",SIMPLIFY},
   {"print",PRINT},
   {"diff",DIFF},
   {"input",INPUT},
   {"expr",EXPR},
   {"go",GO},
   {"again",AGAIN},
   {"batch",BATCH},
   {NULL,ERRORINP}
};

char buffer[MAXINPLINELEN*2];

/*
  puts a prompt to the screen
*/

void doprompt(void)
{ textcolor(CYAN);
  cprintf("Command> ");
  textcolor(LIGHTGRAY);
}

/*
  a useful routine to return an unwanted expression to the heap.
  recursive, as are a lot of the routines
*/

void freetree(struct expression *expr)
{ if(expr==NULL) return;
  if(expr->lval!=NULL) freetree(expr->lval);
  if(expr->rval!=NULL) freetree(expr->rval);
  if(expr!=NULL) free(expr);
}

/*
  this is just the input routine. nothing fancy.
*/

char *getinput(void)
{ int buffpt=0;
  logical inputdone=FALSE;
  char inpchar;
  buffer[0]=0;
  _setcursortype(_NORMALCURSOR);
  while(!inputdone)
  { inpchar=getch();
    if((inpchar==BACKSPACE)&&(buffpt))
    { buffer[--buffpt]=0;
	cprintf("\b \b");
    }
    else if((inpchar==ENTER)&&(buffpt))
    { inputdone=TRUE;
	cprintf("\n\r");
    }
    else if((isprint(inpchar))&&(buffpt<(MAXINPLINELEN-1)))
    { buffer[buffpt++]=inpchar;
	buffer[buffpt]=0;
	cprintf("%c",inpchar);
    }
  }
  _setcursortype(_NOCURSOR);
  return buffer;
}

/*
   This searches for the command entered and calls the appropriate routine.
   returns true when quit is entered
*/

logical parseinput(char *inpline)
{ int buffpt=0,
	optnum=0;
  logical found=FALSE;
  while(inpline[buffpt]==' ')buffpt++;
  while((orders[optnum].name!=NULL)&&(!found))
  { if(!strnicmp(orders[optnum].name,&inpline[buffpt],strlen(orders[optnum].name)))
	found=TRUE;
    else optnum++;
  }
  if(!found)
  { cprintf("Command unknown\n\r");
    return FALSE;
  }
  else
  { switch(orders[optnum].command)
    { case QUIT:    return TRUE;
	case SIMPLIFY:topexpress=simplify(topexpress);
			  break;
	case PRINT:   printout(topexpress);
			  printf("\n\r");
			  break;
	case DIFF:    topexpress=differentiate(topexpress);
			  break;
	case EXPR:
	case INPUT:   freetree(topexpress);
			  topexpress=parser(&inpline[buffpt+strlen(orders[optnum].name)]);
			  break;
	case GO:      freetree(topexpress);
			  topexpress=parser(&inpline[buffpt+strlen(orders[optnum].name)]);
			  topexpress=differentiate(topexpress);
			  topexpress=simplify(topexpress);
			  printout(topexpress);
			  printf("\n\r");
			  break;
	case AGAIN:   topexpress=differentiate(topexpress);
			  topexpress=simplify(topexpress);
			  printout(topexpress);
			  printf("\n\r");
			  break;
	case BATCH:   freetree(topexpress);
			  topexpress=parser(&inpline[buffpt+strlen(orders[optnum].name)]);
			  printf("Input expression:\n\r");
			  printout(topexpress);
			  printf("\n\r");
			  printf("Output expression:\n\r");
			  topexpress=differentiate(topexpress);
			  topexpress=simplify(topexpress);
			  printout(topexpress);
			  printf("\n\r\n\r");
			  break;
	case ERRORINP:cprintf("Unknown Command\n\r");
			  break;
	default:      cprintf("Internal Error 1\n\rType 'quit' to quit\n\r");
			  break;
    }
  }
  return FALSE;
}

/*
   prompt,get input and parse it.
*/

logical command(void)
{ char *inpline;
  doprompt();
  inpline=getinput();
  return parseinput(inpline);
}

/*
   the main function - a repeated loop until quit is entered.
*/

int main(void)
{ topexpress=NULL;
  clrscr();
  textcolor(RED);
  cprintf("Algebraic Differentiator Program v1.0\n\r");
  cprintf("By Paul Young\n\r");
  cprintf("Public Domain\n\r\n\r");
  textcolor(LIGHTGRAY);
  do
  {} while (!command());
  cprintf("Thanks for using the algebraic differentiator.\n\r");
  _setcursortype(_NORMALCURSOR);
  return(0);
}
