  { File Name:       GUEST.PAS
    Description:     a program to maintain a guest list
    Date:            16 December 1985
    Pascal compiler: Turbo Pascal (ver 3.0)
    Written by:      Bro Charles Jackson, SJ
                     Bellarmine College Preparatory
                     850 Elm Street
                     San Jose, California  95126
                     (408) 294-9224

program Guest(input,output);

  { This Guest List program was written for the Jesuit Novitiate in Santa
    Barbara. It utilizes two external files: GUEST.FIL (a file of records
    containing the data for each guest) and GUESTRMS.FIL (a file containing
    the names of rooms that are available for guests). A third file, GUEST-
    SCR.FIL, contains a saved screen image (the rectangle that frames the
    screen). All three files are designed to be memory resident throughout
    the execution of the program (they are automatically loaded at the start
    up of the program and automatically saved upon its termination). Further
    (and more complete) program documentation is available in the separate
    program description/documentation/usage paper. This documentation con-
    sists of 10 xeroxed pages and is available at cost. }

  type
    month_size_list_type = array[1..12] of integer;
    month_name_type = string[9];
    month_name_list_type = array[1..12] of month_name_type;
  const
    room_limit = 100;
    guest_limit = 100;
    guest_file_name = 'GUEST.FIL';
    room_file_name = 'GUESTRMS.FIL';
    screen_file_name = 'GUESTSCR.FIL';
    name_size = 20;
    address_size = 15;
    date_size = 8;
    room_size = 4;
    month_size_list : month_size_list_type
      = (0,31,59,90,120,151,181,212,243,273,304,334);
    month_name_list : month_name_list_type
      = ('January  ','February ','March    ','April    ','May      ',
         'June     ','July     ','August   ','September','October  ',
         'November ','December ');
    deleted_room = '####';
    first_line = 5;
    first_column = 5;
    column_increment = 10;
    final_line = 19;
    total_lines = 15;
  type
    name_type = string[name_size];
    address_type = string[address_size];
    date_type = string[date_size];
    stay_type = integer;
    room_type = string[room_size];
    guest_type = record
                   name : name_type;
                   address : address_type;
                   arrive, depart : date_type;
                   stay : stay_type;
                   room : room_type;
                 end;
    room_list_type = array[1..room_limit] of room_type;
    guest_list_type = array[1..guest_limit] of guest_type;
    screen_type = array[1..4096] of char;
    valid_type = set of char;
    x_list_type = array[1..5] of byte;
    c_list_type = string[5];
    str = string[80];
    str_2 = string[2];
  var
    video_segment : integer;
    color_screen : screen_type absolute $B800 : $0000;
    mono_screen : screen_type absolute $B000 : $0000;
    screen_buffer : screen_type;
    guest_file : file of guest_type;
    room_file : file of room_type;
    screen_file : file;
    guest_list : guest_list_type;
    room_list : room_list_type;
    guest_count, room_count : integer;

{********************** Ultility Routines *************************}

  procedure Print(x, y : byte; message : str);
    begin
      GotoXY(x,y);
      write(message);
    end; {Print}

  function Stir(integer_var : integer) : str;
    var
      null_string : str;
    begin
      Str(integer_var,null_string);
      Stir := null_string;
    end; {Stir}

  procedure Clear_Command_Line;
    begin
      GotoXY(2,23);
      write(' ':78);
    end; {Clear_Command_Line}

  procedure Center_Command(message : str);
    begin
      Clear_Command_Line;
      Print((80-length(message)) div 2,23,message);
    end; {Center_Command}

  procedure Print_Command_Line(message : str;
                               x_list : x_list_type;
                               c_list : c_list_type);
    var
      index : byte;
    begin
      Clear_Command_Line;
      LowVideo;
      Print((71-length(message)) div 2,23,message);
      HighVideo;
      write(' Command:');
      for index := 1 to 5 do
        if x_list[index] <> 0
          then Print(x_list[index],23,c_list[index]);
    end; {Print_Command_Line}

  procedure Signal_And_Pause(message : str);
    var
      ch : char;
    begin
      Center_Command(chr(7) + message + ' <To continue, press any key>');
      read(kbd,ch);
      Clear_Command_Line;
    end; {Print_Error_Message}

  procedure Get_Valid_Command(x, y : byte;
                              valid_options : valid_type;
                              var option : char);
    var
      byte_save : byte;
    begin
      GotoXY(x,y);
      byte_save := Mem[$0000:$0417];
      Mem[$0000:$0417] := Mem[$0000:$0417] or $20; { toggle NUM LOCK numeric }
      repeat
        read(kbd,option);
      until option in valid_options;
      Mem[$0000:$0417] := byte_save;  { restore NUM LOCK }
      if ord(option) > ord('Z')
        then option := chr(ord(option)-32);
      if (option >= 'A') and (option <= 'Z')
        then write(option);
    end; {Get_Valid_Command}

  procedure Print_Line(x, y, size : byte);
    var
      count : byte;
    begin
      GotoXY(x,y);
      for count := 1 to size do
        write('_');
    end; {Print_LIne}

  procedure Print_Rectangle;
    begin
      if (Mem[$0000:$0410] and $30) = $30
        then Move(screen_buffer,mono_screen,4096)
        else Move(screen_buffer,color_screen,4096);
      GotoXY(65,2);
      write(guest_count:2);
      GotoXY(77,2);
      write(room_count:2);
    end; {Print_Rectangle}

  procedure Get_Files;
    var
      file_OK : boolean;
    begin
      room_count := 0;
      guest_count := 0;
      assign(screen_file,screen_file_name);
      reset(screen_file);
      BlockRead(screen_file,screen_buffer,32);
      close(screen_file);
      Print_Rectangle;
      assign(room_file,room_file_name);
      {$I-}
      reset(room_file);
      {$I+}
      file_OK := (IOresult = 0);
      if file_OK
        then while not eof(room_file) do
          begin
            room_count := room_count + 1;
            read(room_file,room_list[room_count]);
          end;
      close(room_file);
      assign(guest_file,guest_file_name);
      {$I-}
      reset(guest_file);
      {$I+}
      file_OK := (IOresult = 0);
      if file_OK
        then while not eof(guest_file) do
          begin
            guest_count := guest_count + 1;
            read(guest_file,guest_list[guest_count]);
          end;
      close(guest_file);
    end; {Get_Files}

  procedure Put_Files;
    var
      count : byte;
    begin
      assign(room_file,room_file_name);
      rewrite(room_file);
      for count := 1 to room_count do
        if room_list[count] <> deleted_room
          then write(room_file,room_list[count]);
      close(room_file);
      assign(guest_file,guest_file_name);
      rewrite(guest_file);
      for count := 1 to guest_count do
        if guest_list[count].room <> deleted_room
          then write(guest_file,guest_list[count]);
      close(guest_file);
    end; {Put_Files}

  procedure Display_Room_List_All;
    var
      x, y, count : byte;
    begin
      x := first_column;
      y := first_line;
      for count := 1 to room_count do
        begin
          GotoXY(x,y);
          write(count:2,'. ');
          if room_list[count] <> deleted_room
            then write(room_list[count]);
          y := y + 1;
          if y > final_line then
            begin
              y := first_line;
              x := x + column_increment;
            end;
        end;
    end; {Display_Room_List_All}

  procedure Display_Guest_List_Page_Abbreviated(index : byte);
    var
      line : byte;
    begin
      Print_Rectangle;
      line := first_line;
      LowVideo;
      while (line <= final_line) and (index <= guest_count) do
        begin
          GotoXY(8,line);
          with guest_list[index] do
            begin
              write(index:2,'. ');
              if room <> deleted_room then
                begin
                  write(name,' ':(25-length(name)),address);
                  write(' ':(20-length(address)),arrive,' - ',depart);
                end;
            end;
          index := index + 1;
          line := line + 1;
        end;
      HighVideo;
    end; {Display_Guest_List_Page_Abbreviated}

  procedure Get_Number(var number : integer;
                       x, y : byte;
                       delete_ch : char;
                       maximum_value : integer;
                       var quit : boolean);
    const
      backspace = #8;
      return = #13;
      escape = #27;
    var
      ch : char;
      index, code : integer;
      store : str_2;
      error : boolean;
    begin
      error := false;
      repeat
        index := 0;
        store := '';
        GotoXY(x,y);
        write(delete_ch,delete_ch);
        GotoXY(x,y);
        repeat
          read(kbd,ch);
          if (ch = backspace) and (index > 0) then
            begin
              Delete(store,index,1);
              write(backspace,delete_ch,backspace);
              index := index - 1;
            end;
          if (ch in ['0'..'9']) and (index < 2) then
            begin
              index := index + 1;
              write(ch);
              store := Concat(store,ch);
            end;
        until (ch = return) or (ch = escape);
        quit := (ch = escape);
        if not quit then
          begin
            Val(store,number,code);
            error := (code <> 0) or (store = '')
                       or (number > maximum_value) or (number < 1);
            if error
              then Signal_And_Pause('ERROR! Number not in Range. Re-enter.');
          end;
      until not error;
    end; {Get_Number}

  procedure Get_String(var in_string : str;
                       x, y : byte;
                       delete_ch : char;
                       maximum_length : byte;
                       var quit : boolean);
    const
      backspace = #8;
      return = #13;
      escape = #27;
    var
      ch : char;
      index : integer;
    begin
      index := 0;
      in_string := '';
      GotoXY(x,y);
      repeat
        read(kbd,ch);
        if (ch = backspace) and (index > 0) then
          begin
            Delete(in_string,index,1);
            write(backspace,delete_ch,backspace);
            index := index - 1;
          end;
        if (ch in [' '..'~']) and (index < maximum_length) then
          begin
            index := index + 1;
            write(ch);
            in_string := Concat(in_string,ch);
          end;
      until (ch = return) or (ch = escape);
      quit := (ch = escape);
    end; {Get_String}

  procedure Clear_Room(number : integer);
    const
      blank = '    ';
    var
      x, y : byte;
    begin
      x := column_increment * ((number - 1) div total_lines)
           + first_column + 4;
      y := (number - 1) mod total_lines + first_line;
      Print(x,y,blank);
    end; {Clear_Room}

  procedure Delete_Occupied_Rooms(in_date, out_date : date_type);
    var
      g_ptr, r_ptr : byte;
      found : boolean;
    begin
      for g_ptr := 1 to guest_count do
        with guest_list[g_ptr] do
          if (in_date >= arrive) and (in_date <= depart)
            or (out_date >= arrive) and (out_date <= depart)
            or (in_date <= arrive) and (out_date >= depart) then
              begin
                r_ptr := 0;
                found := false;
                while (r_ptr < room_count) and (not found) do
                  begin
                    r_ptr := r_ptr + 1;
                    found := (room_list[r_ptr] = room);
                    if found
                      then Clear_Room(r_ptr);
                  end;
              end;
    end; {Delete_Occupied_Rooms}

  procedure Get_Room(var room : room_type;
                     arrive, depart : date_type;
                     delete_room : boolean);
    var
      number_str : str_2;
      room_number : integer;
      quit : boolean;
    begin
      Print_Rectangle;
      Display_Room_List_All;
      if delete_room
        then Delete_Occupied_Rooms(arrive,depart);
      Clear_Command_Line;
      Print(20,23,'Enter index number of room <[1..100]>: ');
      Get_Number(room_number,59,23,' ',100,quit);
      room := room_list[room_number];
    end; {Get_Room}

{*********************** Edit Room List Routines ***********************}

  procedure Add_Room_To_List;
    const
      escape = #27;
      blank = '    ';
    var
      x, y : byte;
      command : char;
      room_name : room_type;
      quit : boolean;
      message : str;
    begin
      LowVideo;
      Print(6,23,'After each entry, press (      ); ');
      write('to terminate entries, press (   ).');
      HighVideo;
      Print(31,23,'RETURN');
      Print(69,23,'ESC');
      repeat
        x := column_increment * (room_count div total_lines) + first_column;
        y := room_count mod total_lines + first_line;
        GotoXY(x,y);
        write((room_count+1):2,'. ');
        Get_String(message,x+4,y,' ',4,quit);
        room_name := message;
        if not quit then
          begin
            room_count := room_count + 1;
            room_list[room_count] := room_name;
          end;
      until quit;
    end; {Add_Room_To_List}

  procedure Delete_Room_From_List;
    var
      number : integer;
      quit : boolean;
    begin
      repeat
        Clear_Command_Line;
        LowVideo;
        Print(4,23,'To delete an entry, enter the <            >:      ');
        write('To exit, press (   ).');
        HighVideo;
        Print(35,23,'index number');
        Print(71,23,'ESC');
        Get_Number(number,50,23,' ',100,quit);
        if not quit then
          begin
            room_list[number] := deleted_room;
            Clear_Room(number);
          end;
      until quit;
    end; {Delete_Room_From_List}

  procedure Get_Edit_Room_List_Command(var option : char);
    const
      x_list : x_list_type = (16,31,50,0,0);
    begin
      Print_Command_Line('( )dd a room.  ( )elete a room.  E( )it.',
        x_list,'ADX  ');
      Get_Valid_Command(66,23,['A','a','D','d','X','x'],option);
    end; {Get_Edit_Room_List_Command}

  procedure Edit_Room_List;
    const
      exit_command = 'X';
    var
      command : char;
    begin
      Print_Rectangle;
      Display_Room_List_All;
      repeat
        Get_Edit_Room_List_Command(command);
        if command <> exit_command then
          case command of
            'A' : Add_Room_To_List;
            'D' : Delete_Room_From_List
          end; {case}
      until command = exit_command;
    end; {Edit_Room_List}

{********************** Display Room List Routines *********************}

  procedure Display_Dates_Booked_By_Room(main_room : room_type);
    const
      column_increment = 25;
    var
      x, y, index, count : byte;
    begin
      x := first_column;
      y := first_line;
      count := 0;
      for index := 1 to guest_count do
        with guest_list[index] do
          if room = main_room then
            begin
              count := count + 1;
              GotoXY(x,y);
              write(count:2,'. ',arrive,' - ',depart);
              y := y + 1;
              if y > final_line then
                begin
                  y := first_line;
                  x := x + column_increment;
                end;
            end;
    end; {Display_Dates_Booked_By_Room}

  procedure Get_Display_Dates_Booked_By_Room_Command(var option : char;
                                                     room : room_type);
    const
      x_list : x_list_type = (34,47,0,0,0);
    begin
      Print_Command_Line('Room:          ( )ontinue. E( )it.',x_list,'CX    ');
      Print(24,23,room);
      Get_Valid_Command(62,23,['C','c','X','x'],option);
    end; {Get_Display_Dates_Booked_By_Room_Command}

  procedure Display_Dates_Booked_By_Room_Main;
    const
      exit_option = 'X';
    var
      room : room_type;
      option : char;
    begin
      repeat
        Get_Room(room,'        ','        ',false);
        Print_Rectangle;
        Display_Dates_Booked_By_Room(room);
        Get_Display_Dates_Booked_By_Room_Command(option,room);
      until option = exit_option;
    end; {Display_Dates_Booked_By_Room_Main}

  procedure Get_Single_Date(var date : date_type);
    var
      month, day, year : integer;
      month_str, day_str : str_2;
      quit : boolean;
    begin
      Center_Command('Enter MONTH [1..12].');
      Print_Line(52,23,2);
      Get_Number(month,51,23,'_',12,quit);
      Center_Command('Enter DAY [1..31].');
      Print_Line(50,23,2);
      Get_Number(day,50,23,'_',31,quit);
      Center_Command('Enter YEAR [00..99].');
      Print_Line(52,23,2);
      Get_Number(year,51,23,'_',99,quit);
      if month < 10
        then month_str := '0' + Stir(month)
        else month_str := Stir(month);
      if day < 10
        then day_str := '0' + Stir(day)
        else day_str := Stir(day);
      date := month_str + '/' + day_str + '/' + Stir(year);
    end; {Get_Single_Date}

  procedure Locate_Room_And_Mark(room : room_type;
                                 var temp_room_list : room_list_type);
    var
      count : byte;
      found : boolean;
    begin
      count := 0;
      found := false;
      repeat
        count := count + 1;
        found := (room = temp_room_list[count]);
        if found
          then temp_room_list[count] := deleted_room;
      until (count = room_count) or found;
    end; {Locate_Room_And_Mark}

  procedure Display_Rooms_Available_By_Date(main_date : date_type);
    var
      x, y, index : byte;
      temp_room_list : room_list_type;
    begin
      x := first_column;
      y := first_line;
      temp_room_list := room_list;
      for index := 1 to guest_count do
        with guest_list[index] do
          if (main_date >= arrive) and (main_date <= depart)
            then Locate_Room_And_Mark(room,temp_room_list);
      for index := 1 to room_count do
        if temp_room_list[index] <> deleted_room then
          begin
            GotoXY(x,y);
            write(index:2,'. ',temp_room_list[index]);
            y := y + 1;
            if y > final_line then
              begin
                y := first_line;
                x := x + column_increment;
              end;
          end;
    end; {Display_Rooms_Available_By_Date}

  procedure Get_Display_Rooms_Available_By_Date_Command(var option : char;
                                                        date : date_type);
    const
      x_list : x_list_type = (34,47,0,0,0);
    begin
      Print_Command_Line('Date:          ( )ontinue. E( )it.',x_list,'CX    ');
      Print(24,23,date);
      Get_Valid_Command(62,23,['C','c','X','x'],option);
    end; {Get_Display_Dates_Booked_By_Room_Command}

  procedure Display_Rooms_Available_By_Date_Main;
    const
      exit_option = 'X';
    var
      date : date_type;
      option : char;
    begin
      repeat
        Get_Single_Date(date);
        Print_Rectangle;
        Display_Rooms_Available_By_Date(date);
        Get_Display_Rooms_Available_By_Date_Command(option,date);
      until option = exit_option;
    end; {Display_Rooms_Available_By_Date_Main}

  procedure Print_Display_Room_List_Menu(var option : char);
    const
      x_list : x_list_type = (7,31,59,0,0);
    begin
      Print_Rectangle;
      Print_Command_Line('(D)ates booked by room. '
        + '(R)ooms available by date. E(X)it.',x_list,'DRX  ');
      Get_Valid_Command(74,23,['D','d','R','r','X','x'],option);
    end; {Print_Display_Room_List_Menu}

  procedure Display_Room_List_Main;
    const
      exit_option = 'X';
    var
      option : char;
    begin
      repeat
        Print_Display_Room_List_Menu(option);
        if option <> exit_option
          then
            case option of
              'D' : Display_Dates_Booked_By_Room_Main;
              'R' : Display_Rooms_Available_By_Date_Main;
            end; {case}
      until option = exit_option;
    end; {Display_Room_List_Main}

{********************** Edit Guest List Routines ***********************}

  procedure Print_Form;
    begin
      LowVideo;
      Print(24,6,'Name:');
      Print(21,8,'Address:');
      Print(10,10,'Arrival Date:');
      Print(15,11,'Month [1..12]:');
      Print(17,12,'Day [1..31]:');
      Print(15,13,'Year [00..99]:');
      Print(10,15,'Departure Date:');
      Print(15,16,'Month [1..12]:');
      Print(17,17,'Day [1..31]:');
      Print(15,18,'Year [00..99]:');
      HighVideo;
    end; {Print_Form}

  procedure Get_Name(var name : name_type);
    var
      quit : boolean;
      message : str;
    begin
      Center_Command('Enter guest''s NAME <maximum 20 characters>.');
      Print_Line(30,6,name_size);
      Get_String(message,30,6,'_',name_size,quit);
      name := message;
    end; {Get_Name}

  procedure Get_Address(var address : address_type);
    var
      quit : boolean;
      message : str;
    begin
      Center_Command('Enter guest''s ADDRESS <maximum 15 characters>.');
      Print_Line(30,8,address_size);
      Get_String(message,30,8,'_',address_size,quit);
      address := message;
    end; {Get_Address}

  procedure Get_Date(var date : date_type;
                     message : str;
                     line : byte;
                     var total_days : integer);
    var
      month, day, year : integer;
      month_str, day_str : str_2;
      quit : boolean;
    begin
      Center_Command(message + ' Enter MONTH [1..12].');
      Print_Line(30,line+1,2);
      Get_Number(month,30,line+1,'_',12,quit);
      Center_Command(message + ' Enter DAY [1..31].');
      Print_Line(30,line+2,2);
      Get_Number(day,30,line+2,'_',31,quit);
      Center_Command(message + ' Enter YEAR [00..99].');
      Print_Line(30,line+3,2);
      Get_Number(year,30,line+3,'_',99,quit);
      if month < 10
        then month_str := '0' + Stir(month)
        else month_str := Stir(month);
      if day < 10
        then day_str := '0' + Stir(day)
        else day_str := Stir(day);
      date := month_str + '/' + day_str + '/' + Stir(year);
      total_days := month_size_list[month] + day;
    end; {Get_Date}

  procedure Get_Guest(var guest : guest_type);
    var
      arrive_days, depart_days : integer;
    begin
      Print_Form;
      with guest do
        begin
          Get_Name(name);
          Get_Address(address);
          Get_Date(arrive,'Arrival Date:',10,arrive_days);
          Get_Date(depart,'Departure Date:',15,depart_days);
          if depart_days < arrive_days
            then depart_days := depart_days + 365;
          stay := depart_days - arrive_days;
          Get_Room(room,arrive,depart,true);
        end;
    end; {Get_Guest}

  procedure Get_Add_Guest_Command(var option : char);
    const
      x_list : x_list_type = (27,40,0,0,0);
    begin
      Print_Command_Line('( )ontinue. E( )it.',x_list,'CX    ');
      Get_Valid_Command(56,23,['C','c','X','x'],option);
    end; {Get_Add_Guest_Command}

  procedure Add_Entry;
    const
      exit_option = 'X';
    var
      guest : guest_type;
      option : char;
    begin
      repeat
        Print_Rectangle;
        Get_Guest(guest);
        guest_count := guest_count + 1;
        guest_list[guest_count] := guest;
        Get_Add_Guest_Command(option);
      until option = exit_option;
    end; {Add_Entry}

  procedure Print_Delete_Entry_Menu;
    const
      x_list : x_list_type = (40,57,0,0,0);
    begin
      Print_Command_Line('(xx xxxx xxxx) to move arrow. ( )elete entry. '
        + 'E( )it.',x_list,'DX   ');
      Print(10,23,chr(24) + chr(25) + ' PgUp PgDn');
    end; {Print_Delete_Entry_Menu}

  procedure Print_Edit_Entry_Menu;
    const
      x_list : x_list_type = (41,56,0,0,0);
    begin
      Print_Command_Line('(xx xxxx xxxx) to move arrow. ( )dit entry. '
        + 'E( )it.',x_list,'EX   ');
      Print(11,23,chr(24) + chr(25) + ' PgUp PgDn');
    end; {Print_Edit_Entry_Menu}

  procedure Print_Edit_One_Entry_Menu;
    const
      x_list : x_list_type = (36,51,0,0,0);
    begin
      Print_Command_Line('(  ) to move arrow. ( )dit entry. E( )it.',
        x_list,'EX   ');
      Print(16,23,chr(24) + chr(25));
    end; {Print_Edit_One_Entry_Menu}

  procedure Display_One_Entry(index : byte);
    begin
      Print(30,6,guest_list[index].name);
      Print(30,8,guest_list[index].address);
      Print(30,11,copy(guest_list[index].arrive,1,2));
      Print(30,12,copy(guest_list[index].arrive,4,2));
      Print(30,13,copy(guest_list[index].arrive,7,2));
      Print(30,16,copy(guest_list[index].depart,1,2));
      Print(30,17,copy(guest_list[index].depart,4,2));
      Print(30,18,copy(guest_list[index].depart,7,2));
    end; {Display_One_Entry}

  procedure Move_Arrow(var arrow_line : byte; increment : byte);
    begin
      Print(4,arrow_line,'    ');
      arrow_line := arrow_line + increment;
      Print(4,arrow_line,'' + chr(16));
    end; {Move_Arrow}

  procedure Edit_One_Entry(index, line : byte);
    const
      top_form_line = 6;
      bottom_form_line = 15;
      exit_option = 'X';
    var
      arrow_line : byte;
      option : char;
      arrive_days, depart_days, month_value, day_value, code : integer;
      new_date : boolean;
    begin
      Print_Rectangle;
      Print_Form;
      Display_One_Entry(index);
      Print_Edit_One_Entry_Menu;
      arrow_line := 6;
      new_date := false;
      Print(4,arrow_line,'' + chr(16));   { print arrow }
      with guest_list[index] do
        repeat
          Get_Valid_Command(67,23,['2','8','E','e','X','x'],option);
          if option <> exit_option then
            case option of
              '2' : case arrow_line of
                      6, 8 : Move_Arrow(arrow_line,2);
                      10   : Move_Arrow(arrow_line,5);
                      15   : ;
                    end;
              '8' : case arrow_line of
                      8, 10 : Move_Arrow(arrow_line,-2);
                      15    : Move_Arrow(arrow_line,-5);
                      6     : ;
                    end;
              'E' : case arrow_line of
                      6  : Get_Name(name);
                      8  : Get_Address(address);
                      10 : begin
                             Get_Date(arrive,'Arrival Date:',10,arrive_days);
                             new_date := true;
                           end;
                      15 : begin
                             Get_Date(depart,'Departure Date:',15,depart_days);
                             new_date := true;
                           end;
                    end; {case}
            end; {case}
          if option = 'E'
            then Print_Edit_One_Entry_Menu;
        until option = exit_option;
        if new_date
          then with guest_list[index] do
            begin
              Val(copy(arrive,1,2),month_value,code);
              Val(copy(arrive,4,2),day_value,code);
              arrive_days := month_size_list[month_value] + day_value;
              Val(copy(depart,1,2),month_value,code);
              Val(copy(depart,4,2),day_value,code);
              depart_days := month_size_list[month_value] + day_value;
              if depart_days < arrive_days
                then depart_days := depart_days + 365;
              stay := depart_days - arrive_days;
              Get_Room(room,arrive,depart,true);
            end;
    end; {Edit_One_Entry}

  procedure Delete_Or_Edit_Guest_Entry(mode : char);
    const
      exit_option = 'X';
    var
      index, arrow_line : byte;
      option : char;
      new_page : boolean;
    begin
      index := 1;
      repeat
        Display_Guest_List_Page_Abbreviated(index);
        if mode = 'D'
          then Print_Delete_Entry_Menu
          else Print_Edit_Entry_Menu;
        arrow_line := first_line;
        Print(4,arrow_line,'' + chr(16));   { print arrow }
        new_page := false;
        repeat
          if mode = 'D'
            then Get_Valid_Command(72,23,['2','3','8','9','D','d','X','x'],
                   option)
            else Get_Valid_Command(72,23,['2','3','8','9','E','e','X','x'],
                   option);
          if option <> exit_option then
            case option of
               'D' : begin
                       GotoXY(11,arrow_line);
                       write(' ':65);
                       guest_list[index].room := deleted_room;
                     end;
               'E' : begin
                       Edit_One_Entry(index,arrow_line);
                       Display_Guest_List_Page_Abbreviated(index
                         - arrow_line + first_line);
                       Print_Edit_Entry_Menu;
                       Print(4,arrow_line,'' + chr(16)); { print arrow }
                     end;
               '2' : if (index < guest_count)
                     and (arrow_line < final_line) then
                       begin
                         index := index + 1;
                         Move_Arrow(arrow_line,1);
                       end;
               '3' : if index + (final_line - arrow_line) < guest_count then
                       begin
                         index := index - arrow_line + first_line
                                  + total_lines;
                         new_page := true;
                       end;
               '8' : if (arrow_line > first_line) then
                       begin
                         index := index - 1;
                         Move_Arrow(arrow_line,-1);
                       end;
               '9' : if index - arrow_line + first_line > 1 then
                       begin
                         index := index - arrow_line + first_line
                                  - total_lines;
                         if index < 1
                           then index := 1;
                         new_page := true;
                       end;
             end; {case}
        until (option = exit_option) or new_page;
      until option = exit_option;
    end; {Delete_Or_Edit_Guest_Entry}

  procedure Print_Edit_Guest_List_Menu(var option : char);
    const
      x_list : x_list_type = (5,20,38,61,0);
    begin
      Print_Rectangle;
      Print_Command_Line('( )dd a Guest. ( )elete a Guest. ( )dit a Guest '
        + 'Entry. E( )it.',x_list,'ADEX ');
      Get_Valid_Command(76,23,['A','a','D','d','E','e','X','x'],option);
    end; {Print_Edit_Guest_List_Menu}

  procedure Edit_Guest_List;
    const
      exit_option = 'X';
    var
      option : char;
    begin
      repeat
        Print_Edit_Guest_List_Menu(option);
        if option <> exit_option
          then
            case option of
              'A' : Add_Entry;
              'D' : Delete_Or_Edit_Guest_Entry('D');
              'E' : Delete_Or_Edit_Guest_Entry('E');
            end; {case}
      until option = exit_option;
    end; {Add_Guest_List}

{********************* Display Guest List Routines *********************}

  procedure Swap(var a, b : guest_type);
    var
      t : guest_type;
    begin
      t := a;
      a := b;
      b := t;
    end; {Swap}

  procedure Sort_List;
    var
      left, right, pointer : byte;
    begin
      for left := 1 to (guest_count - 1) do
        begin
          pointer := left;
          for right := (left + 1) to guest_count do
            if guest_list[right].arrive < guest_list[left].arrive
              then pointer := right;
          if pointer <> left
            then Swap(guest_list[pointer],guest_list[left]);
        end;
    end; {Sort_List}

  procedure Screen_Guest_List_Page(var index : byte;
                                   start_line, month : integer);
    var
      line : byte;
      guest_month_in, guest_month_out, code : integer;
      line_OK : boolean;
    begin
      line := start_line;
      LowVideo;
      while (line <= final_line) and (index <= guest_count) do
        begin
          GotoXY(3,line);
          with guest_list[index] do
            begin
              Val(copy(arrive,1,2),guest_month_in,code);
              Val(copy(depart,1,2),guest_month_out,code);
              line_OK := (room <> deleted_room) and ((month = 0)
                or ((month >= guest_month_in) and (month <= guest_month_out)));
              if line_OK then
                begin
                  write(arrive,'  ',depart,'   ',name);
                  write(' ':(23-length(name)),address);
                  write(' ':(18-length(address)),room);
                  write(' ':(6-length(room)),stay:4);
                  line := line + 1;
                end;
            end;
          index := index + 1;
        end;
      HighVideo;
    end; {Screen_Guest_List_Page}

  procedure Screen_Guest_List_Page_By_Date(var index : byte;
                                           start_line : integer;
                                           date : date_type);
    var
      line : byte;
      guest_month, code : integer;
      line_OK : boolean;
    begin
      line := start_line;
      LowVideo;
      while (line <= final_line) and (index <= guest_count) do
        begin
          GotoXY(3,line);
          with guest_list[index] do
            begin
              line_OK := (room <> deleted_room) and (date >= arrive)
                and (date <= depart);
              if line_OK then
                begin
                  write(arrive,'  ',depart,'   ',name);
                  write(' ':(23-length(name)),address);
                  write(' ':(18-length(address)),room);
                  write(' ':(6-length(room)),stay:4);
                  line := line + 1;
                end;
            end;
          index := index + 1;
        end;
      HighVideo;
    end; {Screen_Guest_List_Page_By_Date}

  procedure Print_Screen_Guest_List_Menu(var option : char);
    begin
      Clear_Command_Line;
      LowVideo;
      Print(18,23,'(    ) moves down in list. E( )it.');
      HighVideo;
      Print(19,23,'PgDn');
      Print(47,23,'X');
      Print(53,23,'Command: ');
      Get_Valid_Command(62,23,['3','X','x'],option);
    end; {Print_Screen_Guest_List_Menu}

  procedure Print_Display_Heading(to_screen : boolean; line : byte);
    begin
      if to_screen then
        begin
          Print(3,line,'Arrive:');
          Print(13,line,'Depart:');
          Print(28,line,'Name:');
          Print(49,line,'Address:');
          Print(65,line,'Room:');
          Print(73,line,'Days:');
        end
      else
        begin
          write(lst,'Arrive:   Depart:        Name:                Address:');
          writeln(lst,'        Room:   Days:');
          writeln(lst);
        end;
    end; {Print_Display_Heading}

  procedure Screen_Guest_List(month : integer; date : date_type);
    const
      exit_option = 'X';
    var
      index, start_line : byte;
      option : char;
      new_page : boolean;
    begin
      Print_Rectangle;
      index := 1;
      case month of
        -1    : begin
                  Print(31,5,'Date:  ' + date);
                  Print_Display_Heading(true,7);
                  start_line := 9;
                end;
        0     : begin
                  Print_Display_Heading(true,5);
                  start_line := 7;
                end;
        1..12 : begin
                  Print(31,5,'Month:  ' + month_name_list[month]);
                  Print_Display_Heading(true,7);
                  start_line := 9;
                end;
      end; {case}
      if month <> -1
        then Screen_Guest_List_Page(index,start_line,month)
        else Screen_Guest_List_Page_By_Date(index,start_line,date);
      repeat
        Print_Screen_Guest_List_Menu(option);
        if option = '3' then
          if index <= guest_count then
            begin
              start_line := 5;
              Print_Rectangle;
             if month <> -1
               then Screen_Guest_List_Page(index,start_line,month)
               else Screen_Guest_List_Page_By_Date(index,start_line,date);
            end;
      until option = exit_option;
    end; {Screen_Guest_List}

  procedure Print_Display_Print_Space_Option_Menu(var double_space : boolean);
    const
      x_list : x_list_type = (28,37,0,0,0);
    var
      option : char;
    begin
      Print_Command_Line('Print: ( )ingle/( )ouble space.',x_list,'SD   ');
      Get_Valid_Command(61,23,['S','s','D','d','X','x'],option);
      double_space := option in ['D','d'];
    end; {Print_Display_Print_Space_Option_Menu}

  procedure Print_Guest_List(month : integer; date : date_type);
    var
      index, line : byte;
      guest_month_in, guest_month_out, code : integer;
      line_OK, double_space : boolean;
    begin
      Print_Display_Print_Space_Option_Menu(double_space);
      index := 1;
      line := 5;
      writeln(lst,' ':32,'Guest List:');
      writeln(lst);
      if month <> 0 then
        case month of
          -1    : begin
                    writeln(lst,' ':30,'Date: ',date);
                    line := line + 2;
                  end;
          1..12 : begin
                    writeln(lst,' ':31,'Month:  ',month_name_list[month]);
                    line := line + 2;
                  end;
        end;
      Print_Display_Heading(false,0);
      while index <= guest_count do
        begin
          with guest_list[index] do
            begin
              Val(copy(arrive,1,2),guest_month_in,code);
              Val(copy(depart,1,2),guest_month_out,code);
              if month <> -1
                then line_OK := (room <> deleted_room) and ((month = 0)
                                 or ((month >= guest_month_in) and
                                    (month <= guest_month_out)))
                else line_OK := (room <> deleted_room) and (date >= arrive)
                                and (date <= depart);
              if line_OK then
                begin
                  write(lst,arrive,'  ',depart,'   ',name);
                  write(lst,' ':(23-length(name)),address);
                  write(lst,' ':(18-length(address)),room);
                  writeln(lst,' ':(6-length(room)),stay:4);
                  if double_space then
                    begin
                      writeln(lst);
                      line := line + 1;
                    end;
                  line := line + 1;
                  if line = 60 then
                    begin
                      write(lst,chr(12)); {form feed}
                      line := 0;
                    end;
                end;
            end;
          index := index + 1;
        end;
    end; {Print_Guest_List}

  procedure Get_Month(var month : integer);
    var
      count : byte;
      quit : boolean;
    begin
      Print_Rectangle;
      Print(24,5,'Months:');
      LowVideo;
      for count := 1 to 12 do
        begin
          GotoXY(20,count+6);
          write(count:2,'. ',month_name_list[count]);
        end;
      HighVideo;
      Print(20,20,'Enter the month to be listed: ');
      Get_Number(month,50,20,' ',12,quit);
    end; {Get_Month}

  procedure Ready_Printer(var printer_OK : boolean);
    var
      option : char;
    begin
      Clear_Command_Line;
      LowVideo;
      Print(32,23,'Printer ( )eady. E( )it.');
      HighVideo;
      Print(14,23,'Turn on Printer.');
      Print(41,23,'R');
      Print(51,23,'X');
      Print(57,23,'Command: ');
      Get_Valid_Command(66,23,['R','r','X','x'],option);
      printer_OK := (option = 'R');
    end; {Ready_Printer}

  procedure Print_Display_Device_Menu(var device_option : char);
    const
      x_list : x_list_type = (34,43,55,0,0);
    begin
      Print_Command_Line('List Guest Entries on: ( )creen/( )rinter. E( )it.',
        x_list,'SPX  ');
      Get_Valid_Command(70,23,['S','s','P','p','X','x'],device_option);
    end; {Print_Display_Device_Menu}

  procedure Print_Display_Option_Menu(var display_option : char);
    const
      x_list : x_list_type = (25,31,39,47,61);
    begin
      Print_Command_Line('List Guest Entries: ( )ll/( )onth/( )ate. '
        + '( )ort List. E( )it.',x_list,'AMDSX');
      Get_Valid_Command(75,23,['A','a','M','m','D','d','S','s','X','x'],
        display_option);
    end; {Print_Display_Option_Menu}

  procedure Display_Guest_List;
    const
      exit_option = 'X';
    var
      display_option, device_option : char;
      printer_OK, display_all, display_on_screen : boolean;
      month : integer;
      date : date_type;
    begin
      Print_Rectangle;
      repeat
        Print_Display_Device_Menu(device_option);
        printer_OK := true;
        if device_option = 'P'
          then Ready_Printer(printer_OK);
        if (device_option <> exit_option) and printer_OK then
          repeat
            Print_Display_Option_Menu(display_option);
            if display_option <> exit_option then
              case display_option of
                'A' : begin
                        if device_option = 'S'
                          then Screen_Guest_List(0,'        ')
                          else Print_Guest_List(0,'        ');
                      end;
                'M' : begin
                        Get_Month(month);
                        if device_option = 'S'
                          then Screen_Guest_List(month,'        ')
                          else Print_Guest_List(month,'        ');
                      end;
                'D' : begin
                        Get_Single_Date(date);
                        if device_option = 'S'
                          then Screen_Guest_List(-1,date)
                          else Print_Guest_List(-1,date);
                      end;
                'S' : Sort_List;
              end;
          until display_option = exit_option;
      until device_option = exit_option;
    end; {Display_Guest_List}

{************************ Introduction Routines ************************}

  procedure Print_Main_Menu(var option : char);
    { Prints the main menu }
    begin
      Print_Rectangle;
      LowVideo;
      Print(10,6,'The guest list program offers the following options:');
      Print(15,8,'1. Create or modify the available room list.');
      Print(15,10,'2. Display the available room list.');
      Print(15,12,'3. Add / delete / modify a guest list entry.');
      Print(15,14,'4. Display / print the guest list.');
      Print(15,16,'5. Terminate the program.');
      HighVideo;
      Print(10,19,'Enter the number corresponding to your choice: ');
      Get_Valid_Command(57,19,['1'..'5'],option);
      write(option);
    end; {Print_Main_Menu}

  procedure Main;
    var
      option : char;
    const
      exit_option = '5';
    begin
      ClrScr;
      Get_Files;
      repeat
        Print_Main_Menu(option);
        if option <> exit_option
          then case option of
            '1' : Edit_Room_List;
            '2' : Display_Room_List_Main;
            '3' : Edit_Guest_List;
            '4' : Display_Guest_List;
          end; {case}
      until option = exit_option;
      Put_Files;
      GotoXY(1,23);
    end; {Main}

  begin
    Main;
  end. {Guest}