@echo off
echo off
rem (C) Copyright 1993, Ad Infinitum Programs, all rights reserved

rem U2_EXZIP.BAT accepts a single parameter: an archive file. It
rem decompresses all files (including hidden ones, etc.) of this archive
rem completely into the current directory. If nothing goes wrong, the files
rem U$~CHK1 and U$~CHK2 are created by this batch file. UC tests for the
rem presence of those files.

rem 1. PK(UN)ZIP 2.0
rem 2. PK(UN)ZIP 1.x
rem 3. (INFO)ZIP

rem ***  PK(UN)ZIP 2.0  ***

   rem If PKUNZIP 2.04ceg fails, (InfoZIP) UNZIP 5.x is often able to do
   rem the job instead.

      echo check > u$~chk1

   rem Add file to archive. 'echo x' is to skip the help screen which is
   rem given in case of unknown options (errorlevel 16).

      echo x | PKZIP -3 -+ -- -) %1 u$~chk1
      if errorlevel 16 goto zip110
      del u$~chk1

   rem Expand archive

      PKUNZIP -3 -+ -- -) -Jrhs -o -d %1

   rem Test for correct expansion

      if not exist u$~chk1 goto retry1
      if errorlevel 1 goto retry1
      goto ok


:zip110
rem ***  PK(UN)ZIP 1.x  ***

   rem Add file to archive

      echo check > u$~chk1
      PKZIP %1 u$~chk1
      del u$~chk1

   rem Expand archive

      PKUNZIP -Jrhs -o -d %1

   rem Test for correct expansion

      if not exist u$~chk1 goto retry1
      if errorlevel 1 goto retry1
      goto ok

:retry1

   rem handle the case where PKZIP is present and PKUNZIP isn't

      echo x | pkzip -3 -+ -- -) -d %1 u$~chk1
      if not errorlevel 16 goto cont
      pkzip -d %1 u$~chk1


:cont
rem ***  ZIP  ***

   rem Add file to archive

      echo check > u$~chk1
      ZIP %1 u$~chk1
      del u$~chk1

   rem Expand archive

      UNZIP -o %1

   rem Test for correct expansion

      if errorlevel 1 goto error
      if not exist u$~chk1 goto error
      goto ok


:error
rem *** Error handling ***

   if exist u$~chk1 del u$~chk1
   if exist u$~chk2 del u$~chk2
   goto end


:ok
rem *** Expansion was successfull ***

   rem Call 'extra' file, allowing e.g. addition of banners

      command /cu2_xtra

   rem Create second check file to notify complete success to UC

      echo check > u$~chk2


:end
rem *** End of batchfile ***
