               page     65,132

               ;Copyright 1986, Arnold B. Krueger
               ;All rights reserved. Contact "ARNY KRUEGER"
               ;at the EXEC-PC BBS (414-964-5160) for permission 
               ;to use commercially.

               ;SETDIR places the current directory into the
               ;environment variable CURDIR. Usage is:
               ;              SETDIR  [name]
               ;            
               ;              name is the optional name of the
               ;              environment variable set, default: CURDIR.
               ;
               ;You can then reset the current directory using: CD %CURDIR%
               ;This is a faster and more reliable technique than
               ;others involving program pairs (PUSHDIR and POPDIR)
               ;or I/O redirection. (CD >dir.sav).

               ;errorlevels are:
               ;               0  if all goes well
               ;               0  if the environment is out of space
               ;                  (an error message will be typed by DOS)
               ;               1 or 2 for SETDIR detected errors:
               ;                    1 - not at DOS 2.0 or above
               ;                    2 - directory string too long
               ;                        (an error message will be typed)

code_seg       segment para public
               assume cs:code_seg,ds:code_seg,ss:code_seg,es:code_seg
               extrn   env_set:near

               org     80h
psp_parml      db      ?                    ;length of parms
psp_parm       db      ?                    ;actual parms

               org     100h                 ; .COM file format
begin:         jmp     main                 ; Skip around data declarations
copyright      db      'Copyright 1986, Arnold B. Krueger GPW, MI 48236'

cr             equ     13
lf             equ     10
set_string     db      'CURDIR'
set_length     equ     $-set_string

release_error    db    1,'Need at least DOS 2.0 to run SETDIR',cr,lf,'$'
directory_error  db    2,'Directory name too long',cr,lf,'$'

main:
        mov      ah,30h              ; get dos release number
        int      21h               
        cmp      al,1                ; above release 1.x
        ja       get_parm            ; if not, don't ask for current directry

        mov      si,offset release_error
        jmp      error_exit

get_parm:
        cld
        xor      cx,cx
        mov      cl,psp_parml        ;get length of parm
        jcxz     no_parm             ;if none, set default

        mov      di,offset psp_parm  ;look at passed parms
        mov      al,' '              ;scan for non-blank
        repz     scasb               ;chop off leading blanks
        jcxz     no_parm

        mov      si,di               ;where to send from
        dec      si                  ;back up over non-blank

        repnz    scasb               ;scan for blank
                                     ;di points to end of string
        jcxz     got_parm            ;if none found, add '='

        dec      di                  ;back up over blank
        jmp      got_parm            ;and add '='


no_parm:
        mov      cx,set_length       ;how much to move
        mov      di,offset psp_parm  ;where to put stuff
        mov      si,offset set_string;get  CURDIR=
        rep      movsb               ;into my PSP
        mov      si,offset psp_parm  ;where to put stuff
got_parm:
        mov      al,'='
        stosb
        mov      cx,offset main      ;get end of parm string
        sub      cx,di               ;subtract to get avail. length

        mov      ah,19h              ; ask for current drive
        int      21h
        add      al,'A'              ; turn into character
        stosb                        ; store into heading area
        dec      cx                  ; cut available length
        mov      al,':'              ; store colon into heading
        stosb                        ; store out colon
        dec      cx                  ; cut available length

        mov      al,'\'              ; set root indicator
        stosb                        ; store into heading area
        dec      cx                  ; cut available length

        mov      si,di               ; use directory work area
        mov      dl,0                ; specify current drive
        mov      ah,47h              ; ask for current directory
        int      21h                 ; si will point to directory asciiz

        xor      al,al
        repnz    scasb               ;look for a zero

        jcxz     ld_error            ;if none found, error

        mov      ax,di               ;get location of zero
        sub      ax,offset psp_parm  ;get length of parms
        dec      al                  ;knock off length of zero

        mov      byte ptr psp_parml,al ;store out length
        mov      si,offset psp_parml

        call   env_set

        jc     env_error

exit:
        mov    ah,4ch                ;terminate program, set errorlevel from al
        int    21h

env_error:
        mov    al,2
        jmp    exit

ld_error:
        mov    si,offset directory_error

error_exit:
        lodsb                        ;reset al with errorlevel
        push   ax                    ;save it
        mov    dx,si                 ;get start of message
        mov    ah,9h                 ;type it out
        int    21h
        pop    ax                    ;reset al with errorlevel
        jmp    exit

code_seg ends
         end    begin



















































































































egin






 ends
        end    begin







        end    begin






nds
        end    begin
















ds
        end    begin












 ends
        end    begin






  end    begin







     BEGIN













