program test;

const
   copyright = 'COPYRIGHT (C) 1985, MPM ENTERPRISES, INC.    ';
   address   = '                    306 Park Avenue          ';
   city_state= '                    Wilmette, Illinois  60091';
   esc = #27;
   nul = #0;
   one = #1;

   fx_control: set of byte =          {control characters for the FX printers}
      [7,8,9,
       10,11,12,13,14,15,17,18,19,
       20,24];

   mx_control: set of byte =          {control characters for the MX printers}
      [7,8,9,
       10,11,12,13,14,15,18,
       20];

   rx_control: set of byte =          {control characters for the RX printers}
      [7,8,9,
       10,11,12,13,14,15,18,
       20];

   fx_escape: set of byte =          {escape codes for the FX printers}
     [14,15,
      33,38,
      42,45,48,49,
      51,52,
      65,66,67,68,69,
      71,74,75,76,77,
      81,82,83,85,87,89,
      90,94,98,
      106,108,
      112,115];

   mx_escape: set of byte =          {escape codes for the MX printers}
     [45,48,49,
      51,52,
      65,67,68,69,
      71,74,75,76,
      81,83,85,87];

   rx_escape: set of byte =          {escape codes for the RX printers}
     [42,45,48,49,
      51,52,
      65,67,69,
      71,74,75,76,77,
      81,82,83,85,87,89,
      90,
      101,102,108,
      115];

var
   i,j,k,l:integer;
   ii,tt  : char;
   test_escape,test_control: set of byte;

procedure print_chars;   {prints the 240 characters that can be printed}
var i:integer;           {by MPM-print}
begin
   for i:=1 to 255 do
      if (i in [1..6,16,21..23,25,26,28..255]) then
          write(lst,char(i));
   writeln(lst);
   writeln(lst);
end;

procedure do_control_codes(i:integer);   {test the single-byte control codes}
begin
   gotoxy(1,15);
   clreol;
   write('testing control code ',i);

   case i of
     7: writeln(lst,'BELL (chr$(7))',char(7));
     8: begin
           write(lst,'BACKSPACE (chr$(8))');
           for j:=1 to 19 do write(lst,char(8));
           writeln(lst,'/\/\/\/\/');
        end;
     9: begin
           for j:=1 to 5 do write(lst,'TAB (chr$(9))',char(9));
           writeln(lst);
        end;
     10: for j:=1 to 5 do write(lst,'LINE FEED (chr$(10))',char(10));
     11: for j:=1 to 5 do write(lst,'VERTICAL TAB (chr$(11))',char(11));
     13: begin
           for j:=1 to 5 do write(lst,'CARRIAGE RETURN (chr$(13))',char(13));
           writeln(lst);
         end;
     14: begin
            writeln(lst,char(14),'ONE LINE EXPANDED MODE ON (chr$(14))');
            writeln(lst);
            print_chars;
            writeln(lst,'ONE LINE EXPANDED MODE OFF (chr$(20))',char(20));
         end;
     15: begin
            writeln(lst,'SHIFT IN (COMPRESSED MODE ON) (chr$(15))',char(15));
            writeln(lst);
            print_chars;
            writeln(lst,'COMPRESSED MODE OFF',char(18),'(chr$(18))');
         end;
   end;  {case statement}

   if (i in [7,8,9,10,11,13,14,15]) then    {filter inadvertent control codes}
   begin
      writeln(lst);
      writeln(lst);
   end;

end;   {do_control_codes}

procedure clear_escape_codes(e_code:integer);    {reset the printer from}
begin                                            {whatever mode was set}
   tt:=char(e_code);                             {by do_escape_codes}

   case e_code of
      14: writeln(lst,char(20));
      15: writeln(lst,'COMPRESSED MODE OFF ',char(18),'(CHR$(18))');
      33: begin
             writeln(lst,'MASTER PRINT MODE SELECT');
             writeln(lst,'(choosing Pica, (ESC 33 0)',
                           esc,tt,nul);
          end;
      38: writeln(lst,'SELECTING the ROM character set (ESC 37 0 0)',
                  esc,char(37),nul,nul);
      45: writeln(lst,esc,tt,nul,'NON-UNDERLINE MODE (ESC 45 0)');
      48: writeln(lst,'RESET LINE SPACING TO DEFAULT 1/6 INCH (12 DOTS)',
                      ' (ESC 50)',esc,char(50));
      49: writeln(lst,'RESET LINE SPACING TO DEFAULT 1/6 INCH (12 DOTS)',
                      ' (ESC 50)',esc,char(50));
      51: writeln(lst,'RESET LINE SPACING TO DEFAULT 1/6 INCH (12 DOTS)',
                      ' (ESC 50)',esc,char(50));
      52: writeln(lst,esc,char(53),'TURN THE ITALIC CHARACTER SET OFF',
                                   ' (ESC 53)');
      65: writeln(lst,'RESET LINE SPACING TO DEFAULT 1/6 INCH (12 DOTS)',
                      ' (ESC 50)',esc,char(50));
      69: writeln(lst,'TURN EMPHASIZED MODE OFF (ESC 70)',esc,char(70));
      71: writeln(lst,'TURN DOUBLE STRIKE MODE OFF (ESC 72)',esc,char(72));
      77: writeln(lst,'TURN ELITE MODE OFF (ESC 80)',esc,char(80));
      81: writeln(lst,esc,tt,char(80),
                  'RESET THE COLUMN WIDTH TO 80 (ESC 81 80)');
      82: begin
             writeln(lst,'RESET THE INTERNATIONAL CHARACTER SET');
             writeln(lst,'to the USA set (ESC 82 0)',esc,tt,nul);
             writeln(lst);
             print_chars;
             writeln(lst);
          end;
      85: writeln(lst,'TURN UNIDIRECTIONAL MODE OFF (ESC 85 0)',
                  esc,tt,nul);
      87: writeln(lst,'TURN EXPANDED MODE OFF (ESC 87 0)',
                  esc,tt,nul);
     108: begin
             writeln(lst,'RESET LEFT MARGIN TO 0 CHARACTERS (ESC 108 10)');
             writeln(lst,esc,tt,nul);
             writeln(lst);
          end;
     112: writeln(lst,'TURN PROPORTIONAL MODE OFF (ESC 112 0)',
                  esc,tt,nul);
     115: writeln(lst,'HALF-SPEED MODE OFF (ESC 115 0)',
                  esc,tt,nul);
   end;   {case statement}

   if (e_code in [15,33,38,45,48,49,51,52,65,69,71,77,81,85,87,112,115]) then
   begin                       {filter inadvertent escape codes}
      writeln(lst);
      writeln(lst);
   end;

end;   {clear_escape_codes}

procedure do_escape_codes(e_code:integer);
begin
   gotoxy(1,15);
   clreol;
   write('testing escape code ',e_code);
   tt:=char(e_code);

   case e_code of
      14: writeln(lst,esc,tt,'ONE LINE EXPANDED MODE ON (ESC 14)');
      15: writeln(lst,'SHIFT IN (COMPRESSED MODE ON) (ESC 15)',esc,tt);
      33: begin
             writeln(lst,'MASTER PRINT MODE SELECT');
             writeln(lst,'(choosing Expanded Compressed, (ESC 33 36)',
                           esc,tt,char(36));
          end;
      38: begin
             writeln(lst,'USING THE DOWNLOAD CHARACTER SET');
             writeln(lst,'*** NOTE ***');
             writeln(lst,'switch 1-5 on the FX printer must be',
                         ' set to OFF for the download set to work');
             writeln(lst);
             writeln(lst,'COPYING CHARACTER SET FROM ROM TO THE DOWNLOAD RAM',
                         ' (ESC 58 0 0 0)',esc,char(58),nul,nul,nul);
             writeln(lst);
             writeln(lst,'REPLACING THE "A" WITH A MODIFIED CHARACTER',
                         ' (ESC 38 0 65 65 +12 character bytes) ',
                         esc,char(38),nul,char(65),char(65),char(139),
                         char(7),char(8),char(16),char(36),char(64),
                         char(36),char(16),char(8),char(7),nul,nul);
             writeln(lst);
             writeln(lst,'SELECTING the download character set (ESC 37 1 0)',
                     esc,char(37),one,nul);
          end;
      42: begin
             writeln(lst,'MASTER GRAPHICS MODE SELECTION');
             writeln(lst,'printing a graphics bar using quad density',
                     ' (ESC 42 3 120 0 +120 character bytes)');
             write(lst,esc,tt,char(3),char(120),nul);
             for j:=1 to 60 do write(lst,char(127),char(42));
             writeln(lst);
             writeln(lst);
          end;
      45: writeln(lst,'UNDERLINE MODE (ESC 45 1)',esc,tt,one);
      48: writeln(lst,'SET LINE SPACING TO 1/8 INCH (9 DOTS) (ESC 48)',
                  esc,tt);
      49: writeln(lst,'SET LINE SPACING TO 7/72 INCH (7 DOTS) (ESC 49)',
                  esc,tt);
      51: begin
             writeln(lst,'SET LINE SPACING TO N/216 INCH');
             writeln(lst,'using n=63 (ESC 51 63)',esc,tt,char(63));
          end;
      52: writeln(lst,'TURN THE ITALIC CHARACTER SET ON (ESC 52)',
                  esc,tt);
      65: begin
             writeln(lst,'SET LINE SPACING TO n/72 INCH (n DOTS)');
             writeln(lst,'using 36 dots (ESC 65 36)',esc,tt,char(36));
          end;
      66: begin
             writeln(lst,'SET UP TO 16 VERTICAL TABS');
             writeln(lst,'using 4 tab settings at 5,11,18, and 26 ',
                     '(ESC 66 5 11 18 26 0)',esc,tt,char(5),char(11),
                     char(18),char(26),nul);
             writeln(lst);
             writeln(lst,'SETTING TOP OF FORM');
             write(lst,char(12));
             do_control_codes(11);
          end;
      67: begin
             write(lst,'GO TO TOP OF FORM',char(12),esc,tt,char(30));
             writeln(lst,'SET FORM LENGTH IN LINES');
             writeln(lst,'set to 30 lines (ESC 67 30)');
             writeln(lst,'go to "top of form"');
             write(lst,char(12),esc,tt,nul,char(6));
             writeln(lst,'SET FORM LENGTH IN INCHES');
             writeln(lst,'set to 6 lines (ESC 67 6)');
             writeln(lst);
             write(lst,'go to "top of form" and reset form length to 66 lines',
                   char(12),esc,tt,char(66));
          end;
      68: begin
             writeln(lst,'SET UP TO 32 HORIZONTAL TABS');
             writeln(lst,'using 6 tab settings at 18,34,48,60, and 70 ',
                     '(ESC 68 18 34 48 60 70 0)',esc,tt,char(18),char(34),
                     char(48),char(60),char(70),nul);
             writeln(lst);
             do_control_codes(9);
             writeln(lst);
          end;
      69: writeln(lst,'TURN EMPHASIZED ON MODE (ESC 69)',esc,tt);
      71: writeln(lst,'TURN DOUBLE STRIKE MODE ON (ESC 71)',esc,tt);
      74: begin
             writeln(lst,'FORCE AN IMMEDIATE LINE FEED OF n/216 INCHES');
             write(lst,'use n=188 (ESC 74 188)',esc,tt,char(188));
             write(lst,'188/216 inch linefeed complete');
             writeln(lst);
          end;
      75: begin
             writeln(lst,'NORMAL GRAPHICS MODE');
             writeln(lst,'printing a graphics bar',
                     ' (ESC 75 120 0 +120 character bytes)');
             write(lst,esc,tt,char(120),nul);
             for j:=1 to 60 do write(lst,char(127),char(42));
             writeln(lst);
             writeln(lst);
          end;
      76: begin
             writeln(lst,'LOW-SPEED DOUBLE-DENSITY GRAPHIC MODE');
             writeln(lst,'printing a graphics bar',
                     ' (ESC 76 120 0 +120 character bytes)');
             write(lst,esc,tt,char(120),nul);
             for j:=1 to 60 do write(lst,char(127),char(42));
             writeln(lst);
             writeln(lst);
          end;
      77: writeln(lst,'TURN ELITE MODE ON (ESC 77)',esc,tt);
      81: begin
             writeln(lst,'SET THE COLUMN WIDTH  (RIGHT MARGIN)');
             writeln(lst,esc,tt,char(60),'set to 60 columns (ESC 81 60)');
          end;
      82: begin
             writeln(lst,'SELECT AN INTERNATIONAL CHARACTER SET');
             writeln(lst,'use the Swedish set (ESC 82 5)',esc,tt,char(5));
          end;
      83: begin
             writeln(lst,'TURN SCRIPT MODE ON (TO SUPER- OR SUBSCRIPT)');
             writeln(lst);
             write(lst,esc,tt,nul,'SUPERSCRIPT (ESC 83 0)',esc,char(84),
                  ' NORMAL ',esc,tt,one,'SUBSCRIPT (ESC 83 1)',
                  esc,char(84));
             writeln(lst);
             writeln(lst);
          end;
      85: writeln(lst,'TURN UNIDIRECTIONAL MODE ON (ESC 85 1)',
                  esc,tt,one);
      87: writeln(lst,'TURN EXPANDED MODE ON (ESC 87 1)',esc,tt,one);
      89: begin
             writeln(lst,'HIGH-SPEED DOUBLE-DENSITY GRAPHICS');
             writeln(lst,'printing a graphics bar',
                     ' (ESC 89 120 0 +120 character bytes)');
             write(lst,esc,tt,char(120),nul);
             for j:=1 to 60 do write(lst,char(127),char(42));
             writeln(lst);
             writeln(lst);
          end;
      90: begin
             writeln(lst,'QUADRUPLE DENSITY GRAPHICS MODE');
             writeln(lst,'printing a graphics bar',
                     ' (ESC 90 120 0 +120 character bytes)');
             write(lst,esc,tt,char(120),nul);
             for j:=1 to 60 do write(lst,char(127),char(42));
             writeln(lst);
             writeln(lst);
          end;
      94: begin
             writeln(lst,'9-PIN GRAPHICS MODE');
             writeln(lst,'printing a single density graphics bar',
                     ' (ESC 94 0 120 0 +120 character bytes)');
             write(lst,esc,tt,nul,char(120),nul);
             for j:=1 to 60 do write(lst,char(127),char(255),
                                     char(42),char(255));
             writeln(lst);
             writeln(lst);
          end;
      98: begin
             writeln(lst,'SET VERTICAL TAB FOR CHANNEL n');
             writeln(lst,'setting channel 3,');
             writeln(lst,'using 4 tab settings at 7,14,28, and 56 ',
                     '(ESC 98 3 7 14 28 56 0)',esc,tt,char(3),char(7),char(14),
                     char(28),char(56),nul);
             writeln(lst);
             writeln(lst,'CHOOSING CHANNEL 3 (ESC 47 3)',esc,char(47),char(3));
             writeln(lst);
             writeln(lst,'SETTING TOP OF FORM');
             write(lst,char(12));
             do_control_codes(11);
             writeln(lst,'CHOOSING CHANNEL 0 (ESC 47 0)',esc,char(47),nul);
             writeln(lst);
          end;
     101: begin
             writeln(lst,'SET HORIZONTAL AND VERTICAL TAB INCREMENTS');
             writeln(lst,'set horizontal tabs to 13 spaces (ESC 101 0 13)',
                     esc,tt,nul,char(13));
             writeln(lst);
             do_control_codes(9);
             writeln(lst,'set vertical tabs to 11 lines (ESC 101 1 11)',
                     esc,tt,one,char(11));
             do_control_codes(11);
          end;
     102: begin
             writeln(lst,'PRINT SPACES OR LINE FEEDS W/O CARRIAGE RETURNS');
             writeln(lst,'print 5 spaces',esc,tt,nul,char(5),'(ESC 102 0 5)');
             writeln(lst,'print 13 line feeds',esc,tt,one,char(13),
                     '(ESC 102 1 13)');
             writeln(lst);
          end;
     106: begin
             writeln(lst,'CAUSE IMMEDIATE REVERSE LINE FEED OF n/216 INCH');
             writeln(lst,'use n=18 (1/2 line',esc,tt,char(18),' ESC 106 18)');
             writeln(lst);
             writeln(lst);
          end;
     108: begin
             writeln(lst,'SET LEFT MARGIN TO n CHARACTERS');
             writeln(lst,'use 10 characters (ESC 108 10)');
             writeln(lst,esc,tt,char(10));
          end;
     112: writeln(lst,'TURN PROPORTIONAL MODE ON (ESC 112 1)',
                  esc,tt,one);
     115: writeln(lst,'HALF-SPEED MODE ON (ESC 115 1)',
                  esc,tt,one);
   end;   {case statement}

   if (e_code in [14,15,33,38,42,45,48,49,51,52,65,68,69,71,74,75,76,77,81,
                  82,83,85,87,89,90,94,98,102,106,112,115]) then writeln(lst);
   {filter inadvertent escape codes}

end;

begin                    {main program}
   clrscr;
   writeln('What printer do you have?');
   writeln;
   writeln('   1. Epson FX-80 or FX-100');
   writeln('   2. Epson MX-80 or MX-100 or IBM Graphics');
   writeln('   3. Epson RX-80 or RX-100');
   writeln;
   writeln('(Enter the number corresponding to your printer,');
   write(' anything else to quit) ..............................');
   read(kbd,ii);
   write(ii);

   if (ii in ['1'..'3']) then
   begin
      case ii of
         '1': begin                               {FX}
               test_escape:=fx_escape;
               test_control:=fx_control;
            end;
         '2': begin                               {MX}
               test_escape:=mx_escape;
               test_control:=mx_control;
            end;
         '3': begin                               {RX}
               test_escape:=rx_escape;
               test_control:=rx_control;
            end;
      end;   {case ii}

      for i:=7 to 31 do if (i in test_control) then
         do_control_codes(i);

      for i:=14 to 115 do if (i in test_escape) then
      begin
         do_escape_codes(i);
         if (not (i in [42,66..68,74..76,83,84,89,90,94,98,101,102,106]))
            then print_chars;
         clear_escape_codes(i);
      end;

      writeln(lst);
      writeln(lst);
      writeln(lst);
      write(lst,'PERFORMING FORM FEED AND MASTER RESET (CHR$(12) ESC 64)',
            char(12),esc,char(64));
      if (ii in ['2','3']) then write(lst,char(12));  {formfeed again for}
                                                      {non FX printers}
   end;

end.
