# Makefile for GNU DIFF
# Copyright (C) 1988, 1989 Free Software Foundation, Inc.

# This file is part of GNU DIFF.

# GNU DIFF is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 1, or (at your option)
# any later version.
# 
# GNU DIFF is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with GNU DIFF; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

# Build function prototypes
#
# Ignore the error messages generated during this phase

diffdcl.h:	diff.c util.c regex.c missing.c dir.c msdir.c analyze.c ed.c context.c normal.c io.c
	cl/Zg diff.c > diffdcl.h
	cl/Zg util.c >> diffdcl.h
	cl/Zg regex.c >> diffdcl.h
	cl/Zg missing.c >> diffdcl.h
	cl/Zg dir.c >> diffdcl.h
	cl/Zg msdir.c >> diffdcl.h
	cl/Zg analyze.c >> diffdcl.h
	cl/Zg ed.c >> diffdcl.h
	cl/Zg context.c >> diffdcl.h
	cl/Zg normal.c >> diffdcl.h
	cl/Zg io.c >> diffdcl.h


# strictly speaking we should include diffdcl.h in each test below
# but that would force everything to compile every time we made
# any change.  So if you change or add a function definition
# just 'touch' 'diff.h' and it will cause everything to recompile

# pay attention to any error message generated from here on

diff.obj:	diff.c diff.h regex.h
	cl /AL /Zp /Zi /c diff.c

util.obj:	util.c diff.h regex.h 
	cl /AL /Zp /Zi /c util.c      

regex.obj:	regex.c diff.h regex.h
	cl /AL /Zp /Zi /c regex.c

missing.obj:	missing.c diff.h regex.h
	cl /AL /Zp /Zi /c missing.c

dir.obj:	dir.c diff.h regex.h
	cl /AL /Zp /Zi /c dir.c

msdir.obj:	msdir.c diff.h regex.h
	cl /AL /Zp /Zi /c msdir.c

analyze.obj:	analyze.c diff.h regex.h
	cl /AL /Zp /Zi /c analyze.c

ed.obj:	ed.c diff.h regex.h
	cl /AL /Zp /Zi /c ed.c

context.obj:	context.c diff.h regex.h
	cl /AL /Zp /Zi /c context.c

normal.obj:	normal.c diff.h regex.h
	cl /AL /Zp /Zi /c normal.c

io.obj:	io.c diff.h regex.h
	cl /AL /Zp /Zi /c io.c

# If you want to use codeview on the executable produced by the
# following link -- just insert '/co' immediately following the word
# 'link' below.

diff.exe:	diff.obj util.obj regex.obj missing.obj dir.obj	msdir.obj analyze.obj ed.obj context.obj normal.obj io.obj
	link/MAP/stack:4096 @diff.lnk
	
