/*
This file is part of GNU DIFF.

GNU DIFF is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GNU DIFF is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU DIFF; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "diff.h"

/*
GNU did not include these routines and I had no UNIX documentation
to describe how they work -- so the below is my attemp at
reverse engineering how they work.

25-Aug-1989
James H. Thompson
VeriFone Inc.
100 Kahelu Ave
Mililani, HI 96789

808-623-2911

*/

FILE  *outfile;


int optind = 0;
char *optarg;
char *work_ptr;

getopt (argc, argv, table)
     int argc;
     char *argv[];
	  char *table;
{
	int c;
	optind++; /* point to next arg */
	if (optind >= argc) return EOF;

	optarg = argv[optind];
	c = optarg[0];
	if (c != '-')  return EOF;
	c = optarg[1];

	work_ptr = strchr(table, c);
	if (!work_ptr) {
		printf("Invalid option %s\n", optarg);
		exit(0);
		}

	/* if argument allowed then point to it */
	if (work_ptr[1] == ':') {
		optarg++;
		optarg++;
		}

	return c;
}

/* Here is the only call to this routine in the package */

      /* setup_output (files[0].name, files[1].name, depth); */

setup_output(char *f1, char *f2, int depth)
{

		outfile = stdout;

		fprintf(outfile,
		"GNU DIFF - Copyright (C) 1988, 1989 Free Software Foundation, Inc.\n");

		fprintf(outfile, "%s   %s   Depth=%d\n", f1, f2, depth);
		fprintf(outfile, "\n");

		}
