VERSION 2.00
Begin Form WallPaperForm 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Wall Paper Changer"
   ClientHeight    =   4830
   ClientLeft      =   1485
   ClientTop       =   2055
   ClientWidth     =   6360
   FontTransparent =   0   'False
   Height          =   5490
   Icon            =   WALLPA4A.FRX:0000
   Left            =   1440
   LinkTopic       =   "Form1"
   ScaleHeight     =   4830
   ScaleWidth      =   6360
   Top             =   1440
   Width           =   6450
   Begin CheckBox Check1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Tile WallPaper"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Left            =   1200
      TabIndex        =   8
      Top             =   3000
      Width           =   1815
   End
   Begin CommandButton Command4 
      Caption         =   "&Delete Old"
      Height          =   375
      Left            =   3960
      TabIndex        =   6
      Top             =   1320
      Width           =   1575
   End
   Begin PictureBox Picture1 
      BackColor       =   &H00FFFFFF&
      Height          =   255
      Left            =   0
      ScaleHeight     =   225
      ScaleWidth      =   465
      TabIndex        =   5
      Top             =   840
      Visible         =   0   'False
      Width           =   495
   End
   Begin CommandButton Command3 
      Caption         =   "&OK To Change"
      Height          =   375
      Left            =   3960
      TabIndex        =   4
      Top             =   1920
      Width           =   1575
   End
   Begin Frame Frame1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "New WallPaper"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00000000&
      Height          =   855
      Left            =   480
      TabIndex        =   3
      Top             =   3480
      Width           =   5415
      Begin Label Label1 
         BackStyle       =   0  'Transparent
         Caption         =   "(New WallPaper Not Loaded)"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   9.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   375
         Left            =   120
         TabIndex        =   2
         Top             =   360
         Width           =   5055
      End
   End
   Begin CommandButton Command2 
      Cancel          =   -1  'True
      Caption         =   "&Cancel"
      Height          =   375
      Left            =   3960
      TabIndex        =   1
      Top             =   2880
      Width           =   1575
   End
   Begin CommandButton Command1 
      Caption         =   "&Select New"
      Height          =   375
      Left            =   3960
      TabIndex        =   0
      Top             =   720
      Width           =   1575
   End
   Begin CommonDialog CMDialog1 
      Left            =   0
      Top             =   120
   End
   Begin Label ColorsLabel 
      BackStyle       =   0  'Transparent
      Caption         =   "Label3"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Left            =   3840
      TabIndex        =   9
      Top             =   240
      Width           =   2055
   End
   Begin Shape Shape4 
      BackColor       =   &H00808080&
      BackStyle       =   1  'Opaque
      Height          =   735
      Left            =   600
      Top             =   3720
      Width           =   5415
   End
   Begin Line Line4 
      BorderColor     =   &H00808080&
      BorderWidth     =   2
      X1              =   5715
      X2              =   5715
      Y1              =   630
      Y2              =   2475
   End
   Begin Line Line3 
      BorderColor     =   &H00808080&
      BorderWidth     =   2
      X1              =   3975
      X2              =   5670
      Y1              =   2475
      Y2              =   2475
   End
   Begin Shape Shape3 
      BorderColor     =   &H00E0E0E0&
      Height          =   1830
      Left            =   3810
      Top             =   615
      Width           =   1875
   End
   Begin Line Line2 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      X1              =   360
      X2              =   6120
      Y1              =   4590
      Y2              =   4590
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      X1              =   6150
      X2              =   6150
      Y1              =   255
      Y2              =   4575
   End
   Begin Shape Shape2 
      BorderColor     =   &H00FFFFFF&
      Height          =   4455
      Left            =   240
      Top             =   135
      Width           =   5895
   End
   Begin Label Label2 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "WallPaper Preview"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   240
      Left            =   1200
      TabIndex        =   7
      Top             =   240
      Width           =   1725
   End
   Begin Image Image1 
      BorderStyle     =   1  'Fixed Single
      Height          =   2055
      Left            =   600
      Top             =   600
      Visible         =   0   'False
      Width           =   2730
   End
   Begin Shape Shape1 
      BackColor       =   &H00000000&
      BorderColor     =   &H00000000&
      FillColor       =   &H00808080&
      FillStyle       =   0  'Solid
      Height          =   2055
      Left            =   720
      Top             =   720
      Width           =   2775
   End
   Begin Menu menuHelp 
      Caption         =   "&Help"
   End
   Begin Menu mneuAbout 
      Caption         =   "&About"
   End
End
' == Form: WallPaperForm ======================================
'
' Main Form for Wall Paper Changer application
'
' =============================================================
'

Sub ButtonsOff ()
   MousePointer = 11
   Command1.Enabled = False
   Command2.Enabled = False
   Command3.Enabled = False
   Command4.Enabled = False
End Sub

Sub ButtonsOn ()
   MousePointer = 0
   Command1.Enabled = True
   Command2.Enabled = True
   Command3.Enabled = True
   Command4.Enabled = True
End Sub

Sub Check1_Click ()
   NewTileWallPaper% = Check1.Value

   If Check1.Value = 1 Then
      Check1.FontBold = True
   Else
      Check1.FontBold = False
   End If

End Sub

Sub Command1_Click ()

   CMdialog1.CancelError = False
   CMdialog1.Filename = ""
   CMdialog1.Action = 1

'   WallPaperName$ = CurrentWallPaper$
   If CMdialog1.Filename = "" Then Exit Sub

   WallPaperName$ = CMdialog1.Filename
   Frame1.Caption = "Selected New WallPaper"
   Label1.Caption = WallPaperName$

' Check if user is trying to load a 16M color picture with 256 color video
   Call GetBmpColors(WallPaperName$, Wide%, High%, BmpColors&)
   If BmpColors& > 256 And SysColors& < 65536 Then
      Ans% = ColorWarning%()
      If Ans% <> 6 Then Exit Sub
   End If

' Load thumbnail of new wall paper
   Call ButtonsOff

   Image1.Visible = True
   Picture1.Visible = False
   Image1.Picture = LoadPicture(WallPaperName$)

   Call ButtonsOn
End Sub

Sub Command2_Click ()
    End
End Sub

Sub Command3_Click ()
' User said "OK" to permanantly change wall paper
' Change wallpaper everytime anyway

' force tile factor change either way
   SectionName$ = "desktop"
   KeyName$ = "tilewallpaper"
   StringIn$ = Str$(NewTileWallPaper%)
   R% = WriteProfileString%(SectionName$, ByVal KeyName$, ByVal StringIn$)

' If user is trying to use a 16m color image, better dim the lights!
   Call ButtonsOff
   R% = SystemParametersInfo%(spi_SetDeskWallPaper, 0, ByVal WallPaperName$, 3)
   Call ButtonsOn

' Make sure form redraws to avoid color palette problems
' and to make sure Windows redraws background if wall paper
' is deleted
      WallPaperForm.WindowState = 2
'      DoEvents
      WallPaperForm.WindowState = 0
      MousePointer = 0
   End

' Everything OK, so quit program
'   If (CurrentWallPaper$ = "") Or (CurrentWallPaper$ = NoneWall$) Then
'      CurrentWallPaper$ = "No WallPaper Defined Right Now"
'   End If
'   If CurrentWallPaper$ = WallPaperName$ Then
'      N$ = Chr$(13) + Chr$(10)
'      Msg$ = "You chose to continue with your" + N$
'      Msg$ = Msg$ + "current Wall Paper:" + N$ + N$ + N$
'      Msg$ = Msg$ + CurrentWallPaper$
'      WallPaperForm.Hide
'      MsgBox Msg$, 64, "Wall Paper Change"
'   End If

'   End

GotError:
   MsgBox ("Load picture error = " + Error$(Err))
   Exit Sub
End Sub

Sub Command4_Click ()
   If (CurrentWallPaper$ = "") Or (CurrentWallPaper$ = NoneWall$) Then
      MsgBox "No current WallPaper to delete", mb_IconExclamation
      Exit Sub
   End If

   N$ = Chr$(13) + Chr$(10)
   Msg$ = "Delete old Wall Paper?" + N$
   Msg$ = Msg$ + "(" + CurrentWallPaper$ + ")"
   Answer = MsgBox(Msg$, mb_IconStop + 1)
   If Answer = idOK Then
      SectionName$ = "desktop"
      KeyName$ = "wallpaper"
      StringIn$ = NoneWall$
      R% = WriteProfileString%(SectionName$, ByVal KeyName$, ByVal StringIn$)
      Call FindOldWallPaper
   End If

End Sub

' == FindOldWallPaper =========================================
'
' Purpose: get the name of the currently defined wall paper
' and the state of the tiling
'
'==============================================================
'
Sub FindOldWallPaper ()
   SectionName$ = "desktop"
   KeyName$ = "wallpaper"
   DefaultVal$ = "undefined"
   ReturnString$ = Space(60)
   R% = GetProfileString%(SectionName$, KeyName$, DefaultVal$, ReturnString$, 60)
   CurrentWallPaper$ = Left$(ReturnString$, R%)
   If CurrentWallPaper$ <> NoneWall$ Then
      CurrentWallPaper$ = UCase$(CurrentWallPaper$)
   End If

' If there isn't a backslash in the path to the wallpaper, then
' it must have been created by Desktop and stored in either the
' WINDOWS or WINDOWS/SYSTEMS
   
   SL% = InStr(CurrentWallPaper$, "\")
   If SL% = 0 And CurrentWallPaper$ <> "" And CurrentWallPaper <> NoneWall$ Then
      TempWin$ = WinDir$ + CurrentWallPaper$
      TempSys$ = WinSysDir$ + CurrentWallPaper$
      Win$ = Dir$(TempWin$)
      Sys$ = Dir$(TempSys$)
'      MsgBox "(" + Win$ + ")" + Chr$(13) + Chr$(10) + "(" + Sys$ + ")"
      If Win$ = "" Then
         CurrentWallPaper$ = TempSys$  ' BMP must be in System directory
      Else
         CurrentWallPaper$ = TempWin$  ' BMP must be in Windows directory
      End If
   End If

   WallPaperName$ = CurrentWallPaper$

   SectionName$ = "desktop"
   KeyName$ = "tilewallpaper"
   DefaultVal$ = "0"
   ReturnString$ = Space(60)
   R% = GetProfileString%(SectionName$, KeyName$, DefaultVal$, ReturnString$, 60)
   OldTileWallPaper% = Val(ReturnString$)

   If (CurrentWallPaper$ <> "") And (CurrentWallPaper$ <> NoneWall$) Then
      Frame1.Caption = "Current WallPaper"
      Label1.Caption = CurrentWallPaper$
      CMdialog1.Filter = "Bitmaps|*.bmp; *.rle"
      CMdialog1.DefaultExt = "BMP"

      ' Check if user is trying to load a 16M color picture with 256 color video
      Call GetBmpColors(CurrentWallPaper$, Wide%, High%, BmpColors&)

      If BmpColors& > 256 And SysColors& < 65536 Then
         Ans% = ColorWarning%()
         If Ans% <> 6 Then Exit Sub
      End If

      Call ButtonsOff
      Image1.Picture = LoadPicture(CurrentWallPaper$)
      Image1.Visible = True
      Picture1.Visible = False
      Call ButtonsOn
      DoEvents                      ' force draw of thumbnail
    Else
      Frame1.Caption = ""
      Label1.Caption = "No WallPaper Defined Right Now"

' Make Picture1 visible to cover Image1
      Picture1.Visible = True
   End If

End Sub

Sub Form_Load ()
   
   ColorsLabel.Caption = ""

' Find Windows directory
   WinDir$ = Space$(100)
   R% = GetWindowsDirectory%(WinDir$, 100)
   WinDir$ = Left$(WinDir$, R%) + "\"
   WinSysDir$ = Space$(100)
   R% = GetSystemDirectory%(WinSysDir$, 100)
   WinSysDir$ = Left$(WinSysDir, R%) + "\"

   CMdialog1.Filter = "Bitmaps|*.bmp; *.rle"
   CMdialog1.DefaultExt = "BMP"

   Image1.Stretch = True

' Center form on screen
   WallPaperForm.Left = (Screen.Width - WallPaperForm.Width) / 2
   WallPaperForm.Top = (Screen.Height - WallPaperForm.Height) / 2
   Show

'Both Picture1 and Image1 are invisible at program start

' Make Picture1 visible and same size as Image 1
   Picture1.Left = Image1.Left
   Picture1.Top = Image1.Top
   Picture1.Width = Image1.Width
   Picture1.Height = Image1.Height
   Picture1.Visible = True

' Find out how many colors video driver has
   SysColors& = GetScreenColors(Me)
   If Command$ = "/debug" Then
      ColorsLabel.Caption = "Screen Colors = " + Str$(SysColors&)
   End If

' Get current wallpaper info
   Call FindOldWallPaper

' force update of check box
   Check1.Value = OldTileWallPaper%

End Sub

Sub menuHelp_Click ()
   WallPaperForm.Hide
   HelpForm.Left = (Screen.Width - HelpForm.Width) / 2
   HelpForm.Top = (Screen.Height - HelpForm.Height) / 2
   HelpForm.Show modal
   WallPaperForm.Show
End Sub

Sub mneuAbout_Click ()
   WallPaperForm.Hide
   AboutForm.Label1.Caption = "Wall Paper Changer V" + Version$
   AboutForm.Show modal
   WallPaperForm.Show
End Sub

