' == GrafUtil.Bas.1 ============================================
'
' Collection of graphics utility routines
'
' Written by Jerry Rivers. Last modified: 01/22/95
'
'  1: 12/31/94    Original version, DoEffects sub added
'     01/02/95    Added BMP Types and subs for
'                 GetBmpcolors and GetScreenColors
'     01/05/95    ColorWarning sub: Fixed appearance of ColorWarning
'     01/12/95    DoEffects sub:
'                 Added calculations for amount picture moves
'                 during special effects. This stopped the
'                 small "hop" some pictures did at 1024 x 768
'
'===============================================================
'
' --------------------------------------------------------------
'
' Type Definitions
'
' --------------------------------------------------------------

' Bitmap Header Definition
'
Type BitMap '14 bytes
        Type As Integer
        Width As Integer
        Height As Integer
        WidthBytes As Integer
        Planes As String * 1
        BitsPixel As String * 1
        Bits As Long
End Type

Type BitMapInfoHeader '40 bytes
        Size As Long
        Width As Long
        Height As Long
        Planes As Integer
        BitCount As Integer
        Compression As Long
        SizeImage As Long
        XPelsPerMeter As Long
        YPelsPerMeter As Long
        ClrUsed As Long
        ClrImportant As Long
End Type

Type RgbTriple
        rgbtBlue As String * 1
        rgbtGreen As String * 1
        rgbtRed As String * 1
End Type

Type RgbQuad
        rgbBlue As String * 1
        rgbGreen As String * 1
        rgbRed As String * 1
        rgbReserved As String * 1
End Type

' structures for defining DIBs
Type BitMapCoreHeader '12 bytes
        bcSize As Long
        bcWidth As Integer
        bcHeight As Integer
        bcPlanes As Integer
        bcBitCount As Integer
End Type

' constants for the biCompression field
Global Const BI_RGB = 0&
Global Const BI_RLE8 = 1&
Global Const BI_RLE4 = 2&

Type BitMapInfo
        bmiHeader As BitMapInfoHeader
        bmiColors As String * 128 ' Array length is arbitrary; may be changed
End Type

Type BitMapCoreInfo
        bmciHeader As BitMapCoreHeader
        bmciColors As String * 96 ' Array length is arbitrary; may be changed
End Type

Type BitMapFileHeader
        bfType As Integer
        bfSize As Long
        bfReserved1 As Integer
        bfReserved2 As Integer
        bfOffBits As Long
End Type

' --------------------------------------------------------------
'
' Global variables
'
' --------------------------------------------------------------

Global SysColors&                   ' Number of screen colors

' --------------------------------------------------------------
'
' Useful Constants
'
' --------------------------------------------------------------
'
' Constants for DoEffects subroutine
'
Global Const deSuperimpose% = 0
Global Const deTopDown% = 1
Global Const deBottomUp% = 4
Global Const deLeftToRight% = 2
Global Const deRightToLeft% = 5
Global Const deDiagDown% = 3
Global Const deDiagUp% = 6

' --------------------------------------------------------------
'
' Declares and supporting constants
'
'---------------------------------------------------------------
'
' Function and constants to get device information
' Global Const BitsPixel = 12     '  Number of bits per pixel
' Global Const Planes = 14        '  Number of planes
Declare Function GetDeviceCaps% Lib "GDI" (ByVal hDC%, ByVal nIndex%)

' == ColorWarning ===============================================
'
' Puts up a MsgBox to warn user there are too many colors in
' the requested BMP file
'
' ===============================================================
'
Function ColorWarning% ()
   NL$ = Chr$(13) + Chr$(10)
   Msg$ = "You are trying to display a picture which has" + NL$
   Msg$ = Msg$ + "16 million colors, but your video driver can't" + NL$
   Msg$ = Msg$ + "display that many." + NL$ + NL$
   
   Msg$ = Msg$ + "THIS PICTURE MAY TAKE SEVERAL MINUTES TO DISPLAY!" + NL$ + NL$
   Msg$ = Msg$ + "Continue anyway?"
   Ans% = MsgBox(Msg$, 48 + 4, "Warning!")
   ColorWarning% = Ans%
End Function

' == DoEffects ===========================================================
'
' Provides visual effects for two Picture controls
'
' Inputs:
'
' Pic1         Name of first Picture control
' Pic2         Name of second Picture control
' Effects%     Type of effect desired.  Pic2 is transitioned across Pic1
'              according to the following list
'
'              0 = Superimpose (Pic2 upon Pic1)
'              1 = Top Down
'              4 = Bottom Up
'              2 = Left-to-Right
'              5 = Right-to-Left
'              3 = Diagonally down (upper left corner to lower right corner)
'              6 = Diagonally up (lower right corner to upper left corner)
'
' PicVisible%  State of Pic1.Visible (True or False)
' Wide%        Width of Pic1 and Pic2
' High%        Height of Pic1 and Pic2
'
' ========================================================================
'
Sub DoEffects (Pic1 As Control, Pic2 As Control, ByVal Effect%, ByVal PicVisible%, ByVal Wide%, ByVal High%)

'   If Command$ = "/db" Then
'      M$ = Str$(Wide%) + " X" + Str$(High%)
'      MsgBox M$
'   End If

' Determine amount to move a picture during each effects iteration.  This
' depends on the twips per pixel ratio.  A pleasing effect is about 48
' iterations, which is 200 TwipsX and 15 TwipsY when in 640 X 480 mode.
   ChgX = PicWidth% \ 48
   ChgY = PicHeight% \ 48

' setup coordinates to center pictures on-screen, independent of screen size
   LeftZero% = (Screen.Width - Wide%) / 2
   TopZero% = (Screen.Height - High%) / 2
'   If Command$ = "/db" Then
'      MsgBox "LeftZero:" + Str$(LeftZero%) + " TopZero:" + Str$(TopZero%)
'   End If

   On Error GoTo EffectError

' Suspend mouse move events during picture effects processing
   StopMouseMovement% = True

   If Effect% < 0 Or Effect% > 6 Then Effect% = 0

   Select Case Effect%
      Case 0                     ' Superimpose
         Pic1.Visible = PicVisible%
         Pic2.Visible = False
         Pic2.Left = LeftZero%
         Pic2.Top = TopZero%
         Pic2.Width = Wide%
         Pic2.Height = High%
         Pic2.Visible = True

      Case 1                     ' Top Down
         Pic1.Visible = PicVisible%
         Pic2.Visible = False

         Pic1.Left = LeftZero%
         Pic1.Top = TopZero%
         Pic1.Width = Wide%
         Pic1.Height = High%
         Pic1.ZOrder 1
         Pic1.Visible = PicVisible%
         
         Pic2.Left = LeftZero%
         Pic2.Top = TopZero%
         Pic2.Width = Wide%
         Pic2.Height = 0
         Pic2.Visible = True
         
         Do
            DoEvents
            Pic2.Height = Pic2.Height + ChgX
         Loop Until Pic2.Height >= High%
'         Pic2.Height = High%

      Case 4                     ' Bottom Up
         Pic1.Visible = PicVisible%
         Pic2.Visible = False

         Pic1.Left = LeftZero%
         Pic1.Top = TopZero%
         Pic1.Width = Wide%
         Pic1.Height = High%
         Pic1.ZOrder 1

         Pic2.Width = Wide%
         Pic2.Height = 0
         Pic2.Left = LeftZero%
         Pic2.Top = Screen.Height - ((Screen.Height - High%) / 2)
'         M$ = "Old Pic2.Top         = " + Str$(Pic2.Top)
         Pic2.Visible = True

         Do
            Pic2.Top = Pic2.Top - ChgX
            Pic2.Height = Pic2.Height + ChgX
            DoEvents
         Loop Until Pic2.Height >= High%
'         Pic2.Height = High%
'         Pic2.Top = TopZero%

'         If Command$ = "/db" Then
'            N$ = Chr$(13) + Chr$(10)
'            M$ = M$ + N$
'            M$ = M$ + "Screen Height =" + Str$(Screen.Height) + N$
'            M$ = M$ + "Pic2.Height   =" + Str$(Pic2.Height) + N$
'            M$ = M$ + "New Pic2.Top    = " + Str$(Pic2.Top) + N$
'            M$ = M$ + "High% =" + Str$(High%)
'            MouseCursor (True)
'            StopMouseMovement% = True
'            MsgBox M$
'         End If

      Case 2                     ' Left to right
         Pic1.Visible = PicVisible%
         Pic2.Visible = False

         Pic1.Top = TopZero%
         Pic1.Left = LeftZero%
         Pic1.Width = Wide%
         Pic1.Height = High%
         Pic1.ZOrder 1
         Pic1.Visible = PicVisible%

         Pic2.Top = TopZero%
         Pic2.Left = LeftZero%
         Pic2.Width = 0
         Pic2.Height = High%
         Pic2.Visible = True

         Do
            DoEvents
            Pic2.Width = Pic2.Width + ChgX
         Loop Until Pic2.Width >= Wide%
'         Pic2.Width = Wide%

      Case 5                     ' Right to left
         Pic1.Visible = PicVisible%
         Pic2.Visible = False

         Pic1.Top = TopZero%
         Pic1.Left = LeftZero%
         Pic1.Width = Wide%
         Pic1.Height = High%
         Pic1.Visible = PicVisible%
         Pic1.ZOrder 1

         Pic2.Top = TopZero%
         Pic2.Left = Screen.Width - ((Screen.Width - Wide%) / 2)
         Pic2.Width = 0
         Pic2.Height = High%
         Pic2.Visible = True

         Do
            Pic2.Move Pic2.Left - ChgX, Pic2.Top, Pic2.Width + ChgX, Pic2.Height
            DoEvents
         Loop Until Pic2.Width >= Wide%
'         Pic2.Left = LeftZero%
'         Pic2.Width = Wide%

      Case 3                     ' Diagonal down
         Pic1.Visible = PicVisible%
         Pic2.Visible = False

         Pic1.Top = TopZero%
         Pic1.Left = LeftZero%
         Pic1.Width = Wide%
         Pic1.Height = High%
         Pic1.Visible = PicVisible%
         Pic1.ZOrder 1

         Pic2.Top = TopZero%
         Pic2.Left = LeftZero%
         Pic2.Width = 0
         Pic2.Height = 0
         Pic2.Visible = True

         Do
            Pic2.Width = Pic2.Width + ChgX
            Pic2.Height = Pic2.Height + ChgY
            DoEvents
         Loop Until Pic2.Width >= Wide%
'         Pic2.Width = Wide%
'         Pic2.Height = High%

      Case 6                     ' Diagonal up
         Pic1.Visible = PicVisible%
         Pic2.Visible = False

         Pic2.Top = Screen.Height - ((Screen.Height - High%) / 2)
         Pic2.Left = Screen.Width - ((Screen.Width - Wide%) / 2)
         Pic2.Width = 0
         Pic2.Height = 0
         Pic2.Visible = True

         Pic1.Top = TopZero%
         Pic1.Left = LeftZero%
         Pic1.Width = Wide%
         Pic1.Height = High%
         Pic1.Visible = PicVisible%
         Pic1.ZOrder 1

         Do
            Pic2.Move Pic2.Left - ChgX, Pic2.Top - ChgY, Pic2.Width + ChgX, Pic2.Height + ChgY
            DoEvents
         Loop Until Pic2.Width >= Wide%
'         Pic2.Left = LeftZero%
'         Pic2.Top = TopZero%
'         Pic2.Width = Wide%
'         Pic2.Height = High%

   End Select

' Turn mouse move events back on, display effects are done!
   StopMouseMovement% = False
   Exit Sub
   
EffectError:
   MsgBox Error$(Err)
   Resume 0
End Sub

' == GetBmpColors ===============================================
'
' Finds bits per pixel, color planes, and number of colors
' in a BMP file
'
' BmpNname$     Full pathname to BMP picture
' BmpWidth%    Returned width of BMP
' BmpHeight%   Returned height of BMP
' BmpColors&   Returned number of BMP colors
'
' ===============================================================
'
Sub GetBmpColors (ByVal BMPname$, BmpWidth%, BmpHeight%, BmpColors&)

   Dim Header As BitMap
   Dim HeaderInfo As BitMapInfoHeader

   F = FreeFile            ' Find next available free file number
   Open BMPname$ For Binary As F
   Get F, , Header
   Get F, , HeaderInfo
   Close F

   BmpWidth% = HeaderInfo.Width
   BmpHeight% = HeaderInfo.Height
   BmpColors& = 2 ^ HeaderInfo.BitCount

End Sub

' == GetScreenColors ===========================================
'
' Returns the number of colors for the current display driver
'
Function GetScreenColors& (FormName As Form)
   BPP = GetDeviceCaps(FormName.hDC, BitsPixel)
   Cplanes = GetDeviceCaps(FormName.hDC, Planes)
   GetScreenColors& = (2 ^ BPP) ^ Cplanes

End Function

