' == GenUtil.Bas ================================================
'
' Collection of general utility routines
'
' Written by Jerry Rivers. Last modified: 01/22/95
'
' ===============================================================
'
' ---------------------------------------------------------------
'
' Useful Constants
'
'----------------------------------------------------------------

' QBcolor constants
Global Const qbBlack% = 0
Global Const qbDarkBlue = 1
Global Const qbDarkGreen = 2
Global Const qbDarkCyan = 3
Global Const qbDarkRed = 4
Global Const qbDarkMagenta = 5
Global Const qbDarkYellow = 6
Global Const qbGrey = 7
Global Const qbDarkGrey = 8
Global Const qbBlue = 9
Global Const qbGreen = 10
Global Const qbCyan = 11
Global Const qbRed = 12
Global Const qbMagenta = 13
Global Const qbYellow = 14
Global Const qbWhite = 15

' Device Parameters for GetDeviceCaps()
Global Const DRIVERVERSION = 0  '  Device driver version
Global Const TECHNOLOGY = 2     '  Device classification
Global Const HORZSIZE = 4       '  Horizontal size in millimeters
Global Const VERTSIZE = 6       '  Vertical size in millimeters
Global Const HORZRES = 8        '  Horizontal width in pixels
Global Const VERTRES = 10       '  Vertical width in pixels
Global Const BITSPIXEL = 12     '  Number of bits per pixel
Global Const PLANES = 14        '  Number of planes
Global Const NUMBRUSHES = 16    '  Number of brushes the device has
Global Const NUMPENS = 18       '  Number of pens the device has
Global Const NUMMARKERS = 20    '  Number of markers the device has
Global Const NUMFONTS = 22      '  Number of fonts the device has
Global Const NUMCOLORS = 24     '  Number of colors the device supports
Global Const PDEVICESIZE = 26   '  Size required for device descriptor
Global Const CURVECAPS = 28     '  Curve capabilities
Global Const LINECAPS = 30      '  Line capabilities
Global Const POLYGONALCAPS = 32 '  Polygonal capabilities
Global Const TEXTCAPS = 34      '  Text capabilities
Global Const CLIPCAPS = 36      '  Clipping capabilities
Global Const RASTERCAPS = 38    '  Bitblt capabilities
Global Const ASPECTX = 40       '  Length of the X leg
Global Const ASPECTY = 42       '  Length of the Y leg
Global Const ASPECTXY = 44      '  Length of the hypotenuse

Global Const LOGPIXELSX = 88    '  Logical pixels/inch in X
Global Const LOGPIXELSY = 90    '  Logical pixels/inch in Y
Global Const SIZEPALETTE = 104  '  Number of entries in physical palette
Global Const NUMRESERVED = 106  '  Number of reserved entries in palette
Global Const COLORRES = 108     '  Actual color resolution

' Device Capability Masks:

' Device Technologies
Global Const DT_PLOTTER = 0     '  Vector plotter
Global Const DT_RASDISPLAY = 1  '  Raster display
Global Const DT_RASPRINTER = 2  '  Raster printer
Global Const DT_RASCAMERA = 3   '  Raster camera
Global Const DT_CHARSTREAM = 4  '  Character-stream, PLP
Global Const DT_METAFILE = 5    '  Metafile, VDM
Global Const DT_DISPFILE = 6    '  Display-file

'
' ---------------------------------------------------------------
'
' Declarations and supporting constants
'
'----------------------------------------------------------------
'
' Functions and variables to find where Windows is installed
'
Global WinDir$          ' Points to Windows directory
Global WinSysDir$       ' Points to Windows System directory

Declare Function GetWindowsDirectory% Lib "Kernel" (ByVal lpBuffer$, ByVal nSize%)
Declare Function GetSystemDirectory% Lib "Kernel" (ByVal lpBuffer$, ByVal nSize%)

' Function to turn mouse cursor on/off
Declare Function ShowCursor% Lib "User" (ByVal bShow%)

' Functions to access .INI files
Declare Function GetProfileString% Lib "Kernel" (ByVal AppName$, ByVal KeyName$, ByVal Default$, ByVal ReturnedString$, ByVal Size%)
Declare Function GetPrivateProfileString% Lib "Kernel" (ByVal AppName$, ByVal KeyName$, ByVal Default$, ByVal RetStr$, ByVal Size%, ByVal FileName$)
Declare Function WriteProfileString% Lib "Kernel" (ByVal AppName$, KeyName As Any, StringIn As Any)
Declare Function WritePrivateProfileString% Lib "Kernel" (ByVal AppName$, ByVal KeyName$, ByVal StringIn$, ByVal FileName$)

' Function and constant to get systems parameter information
'
Global Const spi_SetDeskWallPaper = 20
Declare Function SystemParametersInfo Lib "User" (ByVal uAction As Integer, ByVal uParam As Integer, lpvParam As Any, ByVal fuWinIni As Integer) As Integer

Declare Function SetSysModalWindow% Lib "User" (ByVal Hwnd%)

' == Delay =======================================================
'
' General subroutine to perform a specific time delay without
' tying up Windows.
'
' Delay does NOT require a Timer control or Timer event, but
' does depend on the Timer function, which returns the total
' number of seconds since Midnight.
'
' Note that if Midnight passes while Delay is in progress,
' it will get erroneous results and fail.
'
' DelayTime     Number of milliseconds to delay
'
' ================================================================
'
Sub Delay (DelayTime)
   If DelayTime < 1 Then Exit Sub

   StartTime = Timer * 1000
   Do
      DoEvents
      CurrentTime = Timer * 1000
   Loop Until (CurrentTime - StartTime) >= DelayTime
End Sub

' == FullTrim$ =================================================
'
' Trims leading and trailing blank spaces from a string plus
' deletes an embedded zero byte (chr$(0)), which often occurs
' when using a Windows API function
'
' StringIn$       Input string
'
' Returns:        String with blanks and nulls removed
'
' ==============================================================
'
Function FullTrim$ (ByVal StringIn$)
   Zero% = InStr(StringIn$, Chr$(0))
   If Zero% > 0 Then StringIn$ = Left$(StringIn$, Zero% - 1)
    StringIn$ = LTrim$(RTrim$(StringIn$))
    FullTrim$ = StringIn$
End Function

' == MouseCursor =================================================
'
' Subroutine to turn the mouse pointer on or off
'
' OnOff%       True:  Turn mouse pointer ON
'              False: Turn mouse pointer OFF
'
' ================================================================
'
Sub MouseCursor (OnOff%)
   If OnOff% Then
   ' first, make sure mouse pointer was off
      Do While ShowCursor(False) >= 0
      Loop
   ' Now turn pointer on
      Do While ShowCursor(True) <= 0
      Loop
   End If
   If Not OnOff% Then
'    Hide mouse pointer
'    Do While ShowCursor(False) >= -1
'    Loop
'    Do While ShowCursor(True) < -1
'    Loop

   ' first, make sure mouse pointer was on
      Do While ShowCursor(True) <= 0
      Loop

   ' now turn pointer off
      Do While ShowCursor(False) >= -1
      Loop
   End If

End Sub

